/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.core;

import java.util.Collections;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;

public class ClassReplicaCreator {
    private static final String POWERMOCK_INSTANCE_DELEGATOR_FIELD_NAME = "powerMockInstanceDelegatorField";
    private static AtomicInteger counter = new AtomicInteger(0);

    public <T> Class<T> createClassReplica(Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("clazz cannot be null");
        }
        ClassPool classpool = ClassPool.getDefault();
        String originalClassName = clazz.getName();
        CtClass newClass = classpool.makeClass(this.generateReplicaClassName(clazz));
        try {
            CtMethod[] declaredMethods;
            CtClass originalClassAsCtClass = classpool.get(originalClassName);
            for (CtMethod ctMethod : declaredMethods = originalClassAsCtClass.getDeclaredMethods()) {
                String code = this.getReplicaMethodDelegationCode(clazz, ctMethod, null);
                CtNewMethod.make((CtClass)ctMethod.getReturnType(), (String)ctMethod.getName(), (CtClass[])ctMethod.getParameterTypes(), (CtClass[])ctMethod.getExceptionTypes(), (String)code, (CtClass)newClass);
            }
            return newClass.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> Class<T> createInstanceReplica(T delegator) {
        if (delegator == null) {
            throw new IllegalArgumentException("delegator cannot be null");
        }
        Class<?> clazz = delegator.getClass();
        ClassPool classpool = ClassPool.getDefault();
        String originalClassName = clazz.getName();
        CtClass newClass = classpool.makeClass(this.generateReplicaClassName(clazz));
        try {
            CtConstructor[] declaredConstructors;
            CtMethod[] declaredMethods;
            CtClass originalClassAsCtClass = classpool.get(originalClassName);
            this.copyFields(originalClassAsCtClass, newClass);
            this.addDelegatorField(delegator, newClass);
            for (CtMethod ctMethod : declaredMethods = originalClassAsCtClass.getDeclaredMethods()) {
                String code = this.getReplicaMethodDelegationCode(delegator.getClass(), ctMethod, POWERMOCK_INSTANCE_DELEGATOR_FIELD_NAME);
                CtMethod make2 = CtNewMethod.copy((CtMethod)ctMethod, (CtClass)newClass, null);
                newClass.addMethod(make2);
            }
            for (CtConstructor ctConstructor : declaredConstructors = originalClassAsCtClass.getDeclaredConstructors()) {
                CtConstructor copy = CtNewConstructor.copy((CtConstructor)ctConstructor, (CtClass)newClass, null);
                newClass.addConstructor(copy);
            }
            return newClass.toClass(this.getClass().getClassLoader(), this.getClass().getProtectionDomain());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private <T> void addDelegatorField(T delegator, CtClass replicaClass) throws CannotCompileException {
        CtField f = CtField.make((String)String.format("private %s %s = null;", delegator.getClass().getName(), POWERMOCK_INSTANCE_DELEGATOR_FIELD_NAME), (CtClass)replicaClass);
        replicaClass.addField(f);
    }

    private <T> String generateReplicaClassName(Class<T> clazz) {
        return "replica." + clazz.getName() + "$$PowerMock" + counter.getAndIncrement();
    }

    private void copyFields(CtClass originalClassAsCtClass, CtClass newClass) throws CannotCompileException, NotFoundException {
        CtField[] declaredFields = originalClassAsCtClass.getDeclaredFields();
        CtField[] undeclaredFields = originalClassAsCtClass.getFields();
        HashSet allFields = new HashSet();
        Collections.addAll(allFields, declaredFields);
        Collections.addAll(allFields, undeclaredFields);
        for (CtField ctField : allFields) {
            CtField f = new CtField(ctField.getType(), ctField.getName(), newClass);
            newClass.addField(f);
        }
    }

    private String getReplicaMethodDelegationCode(Class<?> clazz, CtMethod ctMethod, String classOrInstanceToDelegateTo) throws NotFoundException {
        StringBuilder builder = new StringBuilder();
        builder.append("{java.lang.reflect.Method originalMethod = ");
        builder.append(clazz.getName());
        builder.append(".class.getDeclaredMethod(\"");
        builder.append(ctMethod.getName());
        builder.append("\", ");
        String parametersAsString = ClassReplicaCreator.getParametersAsString(this.getParameterTypes(ctMethod));
        if ("".equals(parametersAsString)) {
            builder.append("null");
        } else {
            builder.append(parametersAsString);
        }
        builder.append(");\n");
        builder.append("originalMethod.setAccessible(true);\n");
        CtClass returnType = ctMethod.getReturnType();
        boolean isVoid = returnType.equals(CtClass.voidType);
        if (!isVoid) {
            builder.append("return (");
            builder.append(returnType.getName());
            builder.append(") ");
        }
        builder.append("originalMethod.invoke(");
        if (Modifier.isStatic((int)ctMethod.getModifiers()) || classOrInstanceToDelegateTo == null) {
            builder.append(clazz.getName());
            builder.append(".class");
        } else {
            builder.append(classOrInstanceToDelegateTo);
        }
        builder.append(", $args);}");
        return builder.toString();
    }

    private String[] getParameterTypes(CtMethod ctMethod) throws NotFoundException {
        CtClass[] parameterTypesAsCtClass = ctMethod.getParameterTypes();
        String[] parameterTypes = new String[parameterTypesAsCtClass.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameterTypes[i] = parameterTypesAsCtClass[i].getName() + ".class";
        }
        return parameterTypes;
    }

    private static String getParametersAsString(String[] types) {
        StringBuilder parametersAsString = new StringBuilder();
        if (types != null && types.length == 0) {
            parametersAsString.append("new Class[0]");
        } else {
            parametersAsString.append("new Class[] {");
            if (types != null) {
                for (int i = 0; i < types.length; ++i) {
                    parametersAsString.append(types[i]);
                    if (i == types.length - 1) continue;
                    parametersAsString.append(", ");
                }
            }
            parametersAsString.append("}");
        }
        return parametersAsString.toString();
    }
}

