/*
 * Decompiled with CFR 0.152.
 */
package de.fits.ldap.util;

import de.fits.ldap.util.LDAPAccessException;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.Connections;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.LDAPConnectionFactory;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.SimpleBindRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;

public class Util {
    private static final Logger LOGGER = Logger.getLogger(Util.class.getName());

    private Util() {
    }

    public static Connection buildConnection(String ldapServer, int ldapPort, DN bindUser, String bindPw, boolean useSSL) throws ErrorResultException, GeneralSecurityException, LDAPAccessException {
        LOGGER.log(Level.FINEST, "Entering buildConnection({0}, {1}, {2}, {3}, {4})", new Object[]{ldapServer, ldapPort, null == bindUser ? "null" : bindUser.toString(), bindPw, useSSL});
        Connection conn = Util.buildConnection(ldapServer, ldapPort, bindUser, bindPw, useSSL, false);
        LOGGER.log(Level.FINEST, "Leaving buildConnection(): {0}", conn);
        return conn;
    }

    public static Connection buildConnection(String ldapServer, int ldapPort, DN bindUser, String bindPw, boolean useSSL, boolean trustAll) throws ErrorResultException, GeneralSecurityException, LDAPAccessException {
        SimpleBindRequest bindRequest;
        LOGGER.log(Level.FINEST, "Entering buildConnection({0}, {1}, {2}, {3}, {4}, {5})", new Object[]{ldapServer, ldapPort, null == bindUser ? "null" : bindUser.toString(), bindPw, useSSL, trustAll});
        LDAPOptions options = new LDAPOptions();
        if (useSSL) {
            options.setSSLContext(Util.getSSLContext(trustAll));
        }
        options.setUseStartTLS(false);
        LDAPConnectionFactory factory = null;
        try {
            factory = new LDAPConnectionFactory(ldapServer, ldapPort, options);
        }
        catch (NullPointerException npe) {
            throw new LDAPAccessException(npe);
        }
        if (null != bindUser && null != bindPw && !bindPw.isEmpty() && null != (bindRequest = Requests.newSimpleBindRequest((String)bindUser.toString(), (char[])bindPw.toCharArray()))) {
            factory = Connections.newAuthenticatedConnectionFactory((ConnectionFactory)factory, (BindRequest)bindRequest);
        }
        Connection conn = factory.getConnection();
        LOGGER.log(Level.FINEST, "Leaving buildConnection(): {0}", conn);
        return conn;
    }

    public static SSLContext getSSLContext(boolean trustAll) throws NoSuchAlgorithmException, GeneralSecurityException {
        LOGGER.log(Level.FINEST, "Entering getSSLContext()");
        SSLContext result = null;
        SSLContext defaultContext = SSLContext.getDefault();
        List<String> protocols = Arrays.asList(defaultContext.getDefaultSSLParameters().getProtocols());
        String protocol = "TLSv1.2";
        if (!protocols.contains(protocol)) {
            protocol = protocols.get(0);
        }
        result = trustAll ? new SSLContextBuilder().setProtocol(protocol).setTrustManager((TrustManager)TrustManagers.trustAll()).getSSLContext() : SSLContext.getDefault();
        LOGGER.log(Level.FINEST, "Leaving getSSLContext(): {0}", result);
        return result;
    }

    public static Date toDate(String generalizedTime) throws ParseException {
        LOGGER.log(Level.FINEST, "Entering toDate()");
        Date result = null;
        if (null != generalizedTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssX");
            result = sdf.parse(generalizedTime);
        }
        LOGGER.log(Level.FINEST, "Leaving toDate(): {0}", result);
        return result;
    }

    public static String readFirstAttributeValueAsString(SearchResultEntry entry, String attrName) {
        LOGGER.log(Level.FINEST, "Entering readFirstAttributeValueAsString({0}, {1})", new Object[]{entry, attrName});
        String result = null;
        if (null == entry || null == entry.getAttribute(attrName)) {
            throw new NoSuchElementException("No entry");
        }
        result = entry.getAttribute(attrName).firstValueAsString();
        LOGGER.log(Level.FINEST, "Leaving readFirstAttributeValueAsString(): {0}", result);
        return result;
    }

    public static int readFirstAttributeValueAsInteger(SearchResultEntry entry, String attrName) throws ParseException {
        LOGGER.log(Level.FINEST, "Entering readFirstAttributeValueAsInteger({0}, {1})", new Object[]{entry, attrName});
        int result = 0;
        if (null == entry || null == entry.getAttribute(attrName)) {
            throw new NoSuchElementException("No entry");
        }
        String s = entry.getAttribute(attrName).firstValueAsString();
        NumberFormat nf = NumberFormat.getIntegerInstance();
        nf.setParseIntegerOnly(true);
        Number n = nf.parse(s);
        result = n.intValue();
        LOGGER.log(Level.FINEST, "Leaving readFirstAttributeValueAsInteger(): {0}", result);
        return result;
    }

    public static long readFirstAttributeValueAsLong(SearchResultEntry entry, String attrName) throws ParseException {
        LOGGER.log(Level.FINEST, "Entering readFirstAttributeValueAsLong({0}, {1})", new Object[]{entry, attrName});
        long result = 0L;
        if (null == entry || null == entry.getAttribute(attrName)) {
            throw new NoSuchElementException("No entry");
        }
        String s = entry.getAttribute(attrName).firstValueAsString();
        NumberFormat nf = NumberFormat.getNumberInstance();
        nf.setParseIntegerOnly(true);
        Number n = nf.parse(s);
        result = n.longValue();
        LOGGER.log(Level.FINEST, "Leaving readFirstAttributeValueAsLong(): {0}", result);
        return result;
    }

    public static Date readFirstAttributeValueAsDate(SearchResultEntry entry, String attrName) throws ParseException {
        LOGGER.log(Level.FINEST, "Entering readFirstAttributeValueAsDate({0}, {1})", new Object[]{entry, attrName});
        Date result = null;
        if (null == entry || null == entry.getAttribute(attrName)) {
            throw new NoSuchElementException("No entry");
        }
        String s = entry.getAttribute(attrName).firstValueAsString();
        result = Util.toDate(s);
        LOGGER.log(Level.FINEST, "Leaving readFirstAttributeValueAsDate(): {0}", result);
        return result;
    }

    public static SearchResultEntry getEntry(Connection conn, DN dn, String objectclass) throws LDAPAccessException {
        LOGGER.log(Level.FINEST, "Entering getEntry({0}, {1}, {2})", new Object[]{conn, dn, objectclass});
        SearchResultEntry result = null;
        Filter filter = null;
        if (null != objectclass) {
            filter = Filter.equality((String)"objectclass", (Object)objectclass);
        }
        result = Util.getEntry(conn, dn, filter);
        LOGGER.log(Level.FINEST, "Leaving getEntry(): {0}", result);
        return result;
    }

    public static SearchResultEntry getEntry(Connection conn, DN dn, Filter filter) throws LDAPAccessException {
        LOGGER.log(Level.FINEST, "Entering getEntry({0}, {1}, {2})", new Object[]{conn, dn, filter != null ? filter.toString() : null});
        SearchResultEntry result = null;
        Filter myFilter = null;
        myFilter = null != filter ? Filter.valueOf((String)filter.toString()) : Filter.present((String)"objectclass");
        SearchRequest sr = Requests.newSearchRequest((DN)dn, (SearchScope)SearchScope.BASE_OBJECT, (Filter)myFilter, (String[])new String[0]);
        try {
            result = conn.searchSingleEntry(sr);
        }
        catch (NoSuchElementException ex) {
            throw new LDAPAccessException(ex);
        }
        catch (ErrorResultException ex) {
            throw new LDAPAccessException((Exception)((Object)ex));
        }
        LOGGER.log(Level.FINEST, "Leaving getEntry(): {0}", result);
        return result;
    }
}

