/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import org.rrd4j.core.Util;
import org.rrd4j.data.DataProcessor;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.DownSampler;
import org.rrd4j.graph.ElementsNames;
import org.rrd4j.graph.FindUnit;
import org.rrd4j.graph.HRule;
import org.rrd4j.graph.HSpan;
import org.rrd4j.graph.ImageParameters;
import org.rrd4j.graph.ImageWorker;
import org.rrd4j.graph.LegendComposer;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.Line;
import org.rrd4j.graph.LogService;
import org.rrd4j.graph.Mapper;
import org.rrd4j.graph.PlotElement;
import org.rrd4j.graph.PrintText;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.RrdGraphDef;
import org.rrd4j.graph.RrdGraphInfo;
import org.rrd4j.graph.Source;
import org.rrd4j.graph.SourcedPlotElement;
import org.rrd4j.graph.Stack;
import org.rrd4j.graph.TimeAxis;
import org.rrd4j.graph.VRule;
import org.rrd4j.graph.VSpan;
import org.rrd4j.graph.ValueAxis;
import org.rrd4j.graph.ValueAxisLogarithmic;
import org.rrd4j.graph.ValueAxisMrtg;
import org.rrd4j.graph.ValueScaler;

class RrdGraphGenerator {
    private static final double[] SENSIBLE_VALUES = new double[]{1000.0, 900.0, 800.0, 750.0, 700.0, 600.0, 500.0, 400.0, 300.0, 250.0, 200.0, 125.0, 100.0, 90.0, 80.0, 75.0, 70.0, 60.0, 50.0, 40.0, 30.0, 25.0, 20.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.5, 3.0, 2.5, 2.0, 1.8, 1.5, 1.2, 1.0, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.0, -1.0};
    private static final int SYMBOLS_CENTER = 8;
    private static final char[] SYMBOLS = new char[]{'y', 'z', 'a', 'f', 'p', 'n', '\u00b5', 'm', ' ', 'k', 'M', 'G', 'T', 'P', 'E', 'Z', 'Y'};
    final RrdGraphDef gdef;
    final ImageWorker worker;
    private final DataProcessor dproc;
    Mapper mapper;
    final RrdGraphInfo info = new RrdGraphInfo();
    private final String signature;
    final ImageParameters im;

    RrdGraphGenerator(RrdGraphDef gdef, ImageWorker worker, DataProcessor dproc) {
        this.gdef = gdef;
        this.worker = worker;
        this.dproc = dproc;
        this.signature = gdef.getSignature();
        this.im = new ImageParameters();
    }

    void createGraph() throws IOException {
        boolean lazy = this.lazyCheck();
        if (!lazy || this.gdef.printStatementCount() != 0) {
            this.fetchData();
            this.resolveTextElements();
            if (this.gdef.shouldPlot() && !lazy) {
                this.initializeLimits();
                this.calculatePlotValues();
                this.findMinMaxValues();
                this.identifySiUnit();
                this.expandValueRange();
                this.removeOutOfRangeRules();
                this.removeOutOfRangeSpans();
                this.mapper = new Mapper(this.gdef, this.im);
                this.placeLegends();
                this.createImageWorker();
                this.drawBackground();
                this.drawData();
                this.drawGrid();
                this.drawAxis();
                this.drawText();
                this.drawLegend();
                this.drawRulesAndSpans();
                this.gator();
                this.drawOverlay();
                this.saveImage();
            }
        }
        this.collectInfo();
    }

    private void collectInfo() {
        this.info.filename = this.gdef.filename;
        this.info.width = this.im.xgif;
        this.info.height = this.im.ygif;
        for (CommentText comment : this.gdef.comments) {
            PrintText pt;
            if (!(comment instanceof PrintText) || !(pt = (PrintText)comment).isPrint()) continue;
            this.info.addPrintLine(pt.resolvedText);
        }
        if (this.gdef.imageInfo != null) {
            this.info.imgInfo = Util.sprintf(this.gdef.locale, this.gdef.imageInfo, this.gdef.filename, this.im.xgif, this.im.ygif);
        }
    }

    private void saveImage() throws IOException {
        if (!"-".equals(this.gdef.filename)) {
            Path imgpath = Paths.get(this.gdef.filename, new String[0]);
            this.worker.saveImage(this.gdef.filename);
            this.info.bytesSource = () -> {
                try {
                    return Files.readAllBytes(imgpath);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read image bytes", e);
                }
            };
            this.info.bytesCount = () -> {
                try {
                    return (int)Files.size(imgpath);
                }
                catch (IOException e) {
                    throw new IllegalStateException("Unable to read image informations", e);
                }
            };
        } else {
            byte[] content = this.worker.getImageBytes();
            this.info.bytesSource = () -> Arrays.copyOf(content, content.length);
            this.info.bytesCount = () -> content.length;
        }
    }

    private void drawOverlay() throws IOException {
        if (this.gdef.overlayImage != null) {
            this.worker.loadImage(this.gdef.overlayImage, 0, 0, this.im.xgif, this.im.ygif);
        }
    }

    private void gator() {
        if (!this.gdef.onlyGraph && this.gdef.showSignature) {
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            Font font = this.gdef.getFont(RrdGraphConstants.FONTTAG_WATERMARK);
            int x = (int)((double)(this.im.xgif - 2) - this.worker.getFontAscent(font));
            int y = 4;
            this.worker.transform(x, y, 1.5707963267948966);
            this.worker.drawString(this.signature, 0, 0, font, Color.LIGHT_GRAY);
            this.worker.reset();
            this.worker.setTextAntiAliasing(false);
        }
    }

    private void drawRulesAndSpans() {
        boolean found = false;
        for (PlotElement pe : this.gdef.plotElements) {
            PlotElement vr;
            PlotElement hr;
            if (pe instanceof HRule) {
                hr = (HRule)pe;
                if (!(hr.value >= this.im.minval) || !(hr.value <= this.im.maxval)) continue;
                int y = this.mapper.ytr(hr.value);
                if (!found) {
                    this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
                    found = true;
                }
                this.worker.drawLine(this.im.xorigin, y, this.im.xorigin + this.im.xsize, y, hr.color, hr.stroke);
                continue;
            }
            if (pe instanceof VRule) {
                vr = (VRule)pe;
                if (vr.timestamp < this.im.start || vr.timestamp > this.im.end) continue;
                int x = this.mapper.xtr(vr.timestamp);
                if (!found) {
                    this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
                    found = true;
                }
                this.worker.drawLine(x, this.im.yorigin, x, this.im.yorigin - this.im.ysize, vr.color, vr.stroke);
                continue;
            }
            if (pe instanceof HSpan) {
                hr = (HSpan)pe;
                int ys = this.mapper.ytr(((HSpan)hr).start);
                int ye = this.mapper.ytr(((HSpan)hr).end);
                int height = ys - ye;
                if (!found) {
                    this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
                    found = true;
                }
                this.worker.fillRect(this.im.xorigin, ys - height, this.im.xsize, height, ((HSpan)hr).color);
                continue;
            }
            if (!(pe instanceof VSpan)) continue;
            vr = (VSpan)pe;
            int xs = this.mapper.xtr(((VSpan)vr).start);
            int xe = this.mapper.xtr(((VSpan)vr).end);
            if (!found) {
                this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
                found = true;
            }
            this.worker.fillRect(xs, this.im.yorigin - this.im.ysize, xe - xs, this.im.ysize, ((VSpan)vr).color);
        }
        if (found) {
            this.worker.reset();
        }
    }

    private void drawText() {
        if (!this.gdef.onlyGraph) {
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            if (this.gdef.title != null) {
                int x = Math.max(2, this.im.xgif / 2 - (int)(this.worker.getStringWidth(this.gdef.title, this.gdef.getFont(RrdGraphConstants.FONTTAG_TITLE)) / 2.0));
                int y = 8 + (int)this.worker.getFontAscent(this.gdef.getFont(RrdGraphConstants.FONTTAG_TITLE));
                this.worker.drawString(this.gdef.title, x, y, this.gdef.getFont(RrdGraphConstants.FONTTAG_TITLE), this.gdef.getColor(ElementsNames.font));
            }
            if (this.gdef.verticalLabel != null) {
                int y = this.im.yorigin - this.im.ysize / 2 + (int)this.worker.getStringWidth(this.gdef.verticalLabel, this.gdef.getFont(RrdGraphConstants.FONTTAG_UNIT)) / 2;
                int ascent = (int)this.worker.getFontAscent(this.gdef.getFont(RrdGraphConstants.FONTTAG_UNIT));
                this.worker.transform(10, y, -1.5707963267948966);
                this.worker.drawString(this.gdef.verticalLabel, 0, ascent, this.gdef.getFont(RrdGraphConstants.FONTTAG_UNIT), this.gdef.getColor(ElementsNames.font));
                this.worker.reset();
            }
            this.worker.setTextAntiAliasing(false);
        }
    }

    private void drawGrid() {
        if (!this.gdef.onlyGraph) {
            boolean ok;
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            Paint shade1 = this.gdef.getColor(ElementsNames.shadea);
            Paint shade2 = this.gdef.getColor(ElementsNames.shadeb);
            BasicStroke borderStroke = new BasicStroke(1.0f);
            this.worker.drawLine(0, 0, this.im.xgif - 1, 0, shade1, borderStroke);
            this.worker.drawLine(1, 1, this.im.xgif - 2, 1, shade1, borderStroke);
            this.worker.drawLine(0, 0, 0, this.im.ygif - 1, shade1, borderStroke);
            this.worker.drawLine(1, 1, 1, this.im.ygif - 2, shade1, borderStroke);
            this.worker.drawLine(this.im.xgif - 1, 0, this.im.xgif - 1, this.im.ygif - 1, shade2, borderStroke);
            this.worker.drawLine(0, this.im.ygif - 1, this.im.xgif - 1, this.im.ygif - 1, shade2, borderStroke);
            this.worker.drawLine(this.im.xgif - 2, 1, this.im.xgif - 2, this.im.ygif - 2, shade2, borderStroke);
            this.worker.drawLine(1, this.im.ygif - 2, this.im.xgif - 2, this.im.ygif - 2, shade2, borderStroke);
            if (this.gdef.drawXGrid) {
                new TimeAxis(this).draw();
            }
            if (this.gdef.drawYGrid && !(ok = this.gdef.altYMrtg ? new ValueAxisMrtg(this).draw() : (this.gdef.logarithmic ? new ValueAxisLogarithmic(this, this.worker, this.gdef.locale).draw() : new ValueAxis(this).draw()))) {
                String msg = "No Data Found";
                this.worker.drawString(msg, this.im.xgif / 2 - (int)this.worker.getStringWidth(msg, this.gdef.getFont(RrdGraphConstants.FONTTAG_TITLE)) / 2, (2 * this.im.yorigin - this.im.ysize) / 2, this.gdef.getFont(RrdGraphConstants.FONTTAG_TITLE), this.gdef.getColor(ElementsNames.font));
            }
            this.worker.setTextAntiAliasing(false);
        }
    }

    private void drawData() {
        this.worker.setAntiAliasing(this.gdef.antiAliasing);
        this.worker.clip(this.im.xorigin, this.im.yorigin - this.gdef.height - 1, this.gdef.width, this.gdef.height + 2);
        double areaZero = this.mapper.ytr(this.im.minval > 0.0 ? this.im.minval : Math.min(this.im.maxval, 0.0));
        double[] x = this.gdef.downsampler == null ? this.xtr(this.dproc.getTimestamps()) : null;
        double[] lastY = null;
        for (PlotElement plotElement : this.gdef.plotElements) {
            double[] y;
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            SourcedPlotElement source = (SourcedPlotElement)plotElement;
            if (this.gdef.downsampler != null) {
                DownSampler.DataSet set = this.gdef.downsampler.downsize(this.dproc.getTimestamps(), source.getValues());
                x = this.xtr(set.timestamps);
                y = this.ytr(set.values);
            } else {
                y = this.ytr(source.getValues());
            }
            if (Line.class.isAssignableFrom(source.getClass())) {
                this.worker.drawPolyline(x, y, source.color, ((Line)source).stroke);
            } else if (Area.class.isAssignableFrom(source.getClass())) {
                if (source.parent == null) {
                    this.worker.fillPolygon(x, areaZero, y, source.color);
                } else {
                    this.worker.fillPolygon(x, lastY, y, source.color);
                    this.worker.drawPolyline(x, lastY, source.getParentColor(), new BasicStroke(0.0f));
                }
            } else if (source instanceof Stack) {
                Stack stack = (Stack)source;
                float width = stack.getParentLineWidth();
                if (width >= 0.0f) {
                    this.worker.drawPolyline(x, y, stack.color, new BasicStroke(width));
                } else {
                    this.worker.fillPolygon(x, lastY, y, stack.color);
                    this.worker.drawPolyline(x, lastY, stack.getParentColor(), new BasicStroke(0.0f));
                }
            } else {
                throw new IllegalStateException("Unknown plot source: " + source.getClass().getName());
            }
            lastY = y;
        }
        this.worker.reset();
        this.worker.setAntiAliasing(false);
    }

    private void drawAxis() {
        if (!this.gdef.onlyGraph) {
            Paint gridColor = this.gdef.getColor(ElementsNames.grid);
            Paint xaxisColor = this.gdef.getColor(ElementsNames.xaxis);
            Paint yaxisColor = this.gdef.getColor(ElementsNames.yaxis);
            Paint arrowColor = this.gdef.getColor(ElementsNames.arrow);
            BasicStroke stroke = new BasicStroke(1.0f);
            this.worker.drawLine(this.im.xorigin + this.im.xsize, this.im.yorigin, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin - 4, this.im.yorigin, this.im.xorigin + this.im.xsize + 4, this.im.yorigin, xaxisColor, stroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin + 4, this.im.xorigin, this.im.yorigin - this.im.ysize - 4, yaxisColor, stroke);
            if (arrowColor instanceof Color && ((Color)arrowColor).getAlpha() == 0) {
                return;
            }
            double[] xArrowX = new double[]{this.im.xorigin + this.im.xsize + 4, this.im.xorigin + this.im.xsize + 9, this.im.xorigin + this.im.xsize + 4};
            double[] xArrowY = new double[]{this.im.yorigin - 3, this.im.yorigin, this.im.yorigin + 3};
            this.worker.fillPolygon(xArrowX, (double)this.im.yorigin + 3.0, xArrowY, arrowColor);
            double[] yArrowX = new double[]{this.im.xorigin - 3, this.im.xorigin, this.im.xorigin + 3};
            double[] yArrowY = new double[]{this.im.yorigin - this.im.ysize - 4, this.im.yorigin - this.im.ysize - 9, this.im.yorigin - this.im.ysize - 4};
            this.worker.fillPolygon(yArrowX, (double)(this.im.yorigin - this.im.ysize) - 4.0, yArrowY, arrowColor);
        }
    }

    private void drawBackground() throws IOException {
        this.worker.fillRect(0, 0, this.im.xgif, this.im.ygif, this.gdef.getColor(ElementsNames.back));
        if (this.gdef.backgroundImage != null) {
            this.worker.loadImage(this.gdef.backgroundImage, 0, 0, this.im.xgif, this.im.ygif);
        }
        if (this.gdef.canvasImage != null) {
            this.worker.loadImage(this.gdef.canvasImage, this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xsize, this.im.ysize);
        }
        this.worker.fillRect(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xsize, this.im.ysize, this.gdef.getColor(ElementsNames.canvas));
    }

    private void createImageWorker() {
        this.worker.resize(this.im.xgif, this.im.ygif);
    }

    private void placeLegends() {
        if (!this.gdef.noLegend && !this.gdef.onlyGraph) {
            int border = (int)(this.getFontCharWidth(RrdGraphConstants.FontTag.LEGEND) * 2.0);
            LegendComposer lc = new LegendComposer(this, border, this.im.ygif, this.im.xgif - 2 * border);
            this.im.ygif = lc.placeComments() + 6;
        }
    }

    private void initializeLimits() {
        this.im.xsize = this.gdef.width;
        this.im.ysize = this.gdef.height;
        this.im.unitslength = this.gdef.unitsLength;
        this.im.xorigin = this.gdef.onlyGraph ? 0 : (int)(10.0 + (double)this.im.unitslength * this.getFontCharWidth(RrdGraphConstants.FONTTAG_AXIS));
        if (!this.gdef.onlyGraph && this.gdef.verticalLabel != null) {
            this.im.xorigin += (int)this.getFontHeight(RrdGraphConstants.FONTTAG_UNIT);
        }
        this.im.yorigin = this.gdef.onlyGraph ? this.im.ysize : 12 + this.im.ysize;
        if (!this.gdef.onlyGraph && this.gdef.title != null) {
            this.im.yorigin += (int)(this.getFontHeight(RrdGraphConstants.FONTTAG_TITLE) + 6.0);
        }
        if (this.gdef.onlyGraph) {
            this.im.xgif = this.im.xsize;
            this.im.ygif = this.im.yorigin;
        } else {
            this.im.xgif = 16 + this.im.xsize + this.im.xorigin;
            this.im.ygif = this.im.yorigin + (int)(2.0 * this.getFontHeight(RrdGraphConstants.FONTTAG_AXIS));
        }
    }

    private void removeOutOfRangeRules() {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (plotElement instanceof HRule) {
                ((HRule)plotElement).setLegendVisibility(this.im.minval, this.im.maxval, this.gdef.forceRulesLegend);
                continue;
            }
            if (!(plotElement instanceof VRule)) continue;
            ((VRule)plotElement).setLegendVisibility(this.im.start, this.im.end, this.gdef.forceRulesLegend);
        }
    }

    private void removeOutOfRangeSpans() {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (plotElement instanceof HSpan) {
                ((HSpan)plotElement).setLegendVisibility(this.im.minval, this.im.maxval, this.gdef.forceRulesLegend);
                continue;
            }
            if (!(plotElement instanceof VSpan)) continue;
            ((VSpan)plotElement).setLegendVisibility(this.im.start, this.im.end, this.gdef.forceRulesLegend);
        }
    }

    private void expandValueRange() {
        this.im.ygridstep = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.gridStep : Double.NaN;
        int n = this.im.ylabfact = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.labelFactor : 0;
        if (!this.gdef.rigid && !this.gdef.logarithmic) {
            if (Double.isNaN(this.im.ygridstep)) {
                if (this.gdef.altYMrtg) {
                    double scaledMax;
                    double scaledMin;
                    this.im.decimals = Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                    this.im.quadrant = 0;
                    if (this.im.minval < 0.0) {
                        this.im.quadrant = 2;
                        if (this.im.maxval <= 0.0) {
                            this.im.quadrant = 4;
                        }
                    }
                    switch (this.im.quadrant) {
                        case 2: {
                            this.im.scaledstep = Math.ceil(50.0 * Math.pow(10.0, -this.im.decimals) * Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaledMin = -2.0 * this.im.scaledstep;
                            scaledMax = 2.0 * this.im.scaledstep;
                            break;
                        }
                        case 4: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * Math.abs(this.im.minval)) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaledMin = -4.0 * this.im.scaledstep;
                            scaledMax = 0.0;
                            break;
                        }
                        default: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * this.im.maxval) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaledMin = 0.0;
                            scaledMax = 4.0 * this.im.scaledstep;
                        }
                    }
                    this.im.minval = scaledMin;
                    this.im.maxval = scaledMax;
                } else if (this.gdef.altAutoscale || this.gdef.altAutoscaleMin && this.gdef.altAutoscaleMax) {
                    double delt = this.im.maxval - this.im.minval;
                    double adj = delt * 0.1;
                    double fact = 2.0 * Math.pow(10.0, Math.floor(Math.log10(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval)))) - 2.0);
                    if (delt < fact) {
                        adj = (fact - delt) * 0.55;
                    }
                    this.im.minval -= adj;
                    this.im.maxval += adj;
                } else if (this.gdef.altAutoscaleMin) {
                    double adj = (this.im.maxval - this.im.minval) * 0.1;
                    this.im.minval -= adj;
                } else if (this.gdef.altAutoscaleMax) {
                    double adj = (this.im.maxval - this.im.minval) * 0.1;
                    this.im.maxval += adj;
                } else {
                    double scaledMin = this.im.minval / this.im.magfact;
                    double scaledMax = this.im.maxval / this.im.magfact;
                    int i = 1;
                    while (SENSIBLE_VALUES[i] > 0.0) {
                        if (SENSIBLE_VALUES[i - 1] >= scaledMin && SENSIBLE_VALUES[i] <= scaledMin) {
                            this.im.minval = SENSIBLE_VALUES[i] * this.im.magfact;
                        }
                        if (-SENSIBLE_VALUES[i - 1] <= scaledMin && -SENSIBLE_VALUES[i] >= scaledMin) {
                            this.im.minval = -SENSIBLE_VALUES[i - 1] * this.im.magfact;
                        }
                        if (SENSIBLE_VALUES[i - 1] >= scaledMax && SENSIBLE_VALUES[i] <= scaledMax) {
                            this.im.maxval = SENSIBLE_VALUES[i - 1] * this.im.magfact;
                        }
                        if (-SENSIBLE_VALUES[i - 1] <= scaledMax && -SENSIBLE_VALUES[i] >= scaledMax) {
                            this.im.maxval = -SENSIBLE_VALUES[i] * this.im.magfact;
                        }
                        ++i;
                    }
                }
            } else {
                this.im.minval = (double)this.im.ylabfact * this.im.ygridstep * Math.floor(this.im.minval / ((double)this.im.ylabfact * this.im.ygridstep));
                this.im.maxval = (double)this.im.ylabfact * this.im.ygridstep * Math.ceil(this.im.maxval / ((double)this.im.ylabfact * this.im.ygridstep));
            }
        }
    }

    private void identifySiUnit() {
        this.im.unitsexponent = this.gdef.unitsExponent;
        this.im.base = this.gdef.base;
        if (!this.gdef.logarithmic) {
            double digits = this.im.unitsexponent != Integer.MAX_VALUE ? Math.floor((double)this.im.unitsexponent / 3.0) : Math.floor(Math.log(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval))) / Math.log(this.im.base));
            this.im.magfact = Math.pow(this.im.base, digits);
            this.im.symbol = FindUnit.resolveSymbol((int)digits);
        }
    }

    private void findMinMaxValues() {
        double minval = Double.NaN;
        double maxval = Double.NaN;
        for (PlotElement pe : this.gdef.plotElements) {
            if (!(pe instanceof SourcedPlotElement)) continue;
            minval = Util.min(((SourcedPlotElement)pe).getMinValue(), minval);
            maxval = Util.max(((SourcedPlotElement)pe).getMaxValue(), maxval);
        }
        if (Double.isNaN(minval)) {
            minval = 0.0;
        }
        if (Double.isNaN(maxval)) {
            maxval = 1.0;
        }
        this.im.minval = this.gdef.minValue;
        this.im.maxval = this.gdef.maxValue;
        if (Double.isNaN(this.im.minval) || !this.gdef.logarithmic && !this.gdef.rigid && this.im.minval > minval) {
            this.im.minval = minval;
        }
        if (Double.isNaN(this.im.maxval) || !this.gdef.rigid && this.im.maxval < maxval) {
            this.im.maxval = this.gdef.logarithmic ? maxval * 1.1 : maxval;
        }
        if (this.im.minval > this.im.maxval) {
            this.im.minval = 0.99 * this.im.maxval;
        }
        if (Math.abs(this.im.minval - this.im.maxval) < 1.0E-7) {
            this.im.maxval *= 1.01;
            if (!this.gdef.logarithmic) {
                this.im.minval *= 0.99;
            }
            if (this.im.maxval == 0.0) {
                this.im.maxval = 1.0;
            }
        }
        if (this.gdef.logarithmic) {
            this.im.log = LogService.resolve(this.im);
        }
    }

    private void calculatePlotValues() {
        for (PlotElement pe : this.gdef.plotElements) {
            if (!(pe instanceof SourcedPlotElement)) continue;
            ((SourcedPlotElement)pe).assignValues(this.dproc);
        }
    }

    private void resolveTextElements() {
        ValueScaler valueScaler = new ValueScaler(this.gdef.base);
        for (CommentText comment : this.gdef.comments) {
            comment.resolveText(this.gdef.locale, this.dproc, valueScaler);
        }
    }

    private void fetchData() throws IOException {
        this.dproc.setPixelCount(this.gdef.width);
        if (this.gdef.poolUsed) {
            this.dproc.setPoolUsed(true);
            this.dproc.setPool(this.gdef.getPool());
        }
        this.dproc.setTimeZone(this.gdef.tz);
        if (this.gdef.step > 0L) {
            this.dproc.setStep(this.gdef.step);
            this.dproc.setFetchRequestResolution(this.gdef.step);
        }
        for (Source src : this.gdef.sources) {
            src.requestData(this.dproc);
        }
        this.dproc.processData();
        this.im.start = this.gdef.startTime;
        this.im.end = this.gdef.endTime;
    }

    private boolean lazyCheck() throws IOException {
        if (!this.gdef.lazy || !Util.fileExists(this.gdef.filename)) {
            return false;
        }
        long secPerPixel = (this.gdef.endTime - this.gdef.startTime) / (long)this.gdef.width;
        long elapsed = Util.getTimestamp() - Util.getLastModifiedTime(this.gdef.filename);
        return elapsed <= secPerPixel;
    }

    private void drawLegend() {
        if (!this.gdef.onlyGraph && !this.gdef.noLegend) {
            this.worker.setTextAntiAliasing(this.gdef.textAntiAliasing);
            int ascent = (int)this.worker.getFontAscent(this.gdef.getFont(RrdGraphConstants.FONTTAG_LEGEND));
            int box = (int)this.getBox();
            int boxSpace = (int)this.getBoxSpace();
            for (CommentText c : this.gdef.comments) {
                if (!c.isValidGraphElement()) continue;
                int x = c.x;
                int y = c.y + ascent;
                if (c instanceof LegendText) {
                    boolean lt;
                    this.worker.fillRect(x, y - box, box, box, this.gdef.getColor(ElementsNames.frame));
                    Paint bc = this.gdef.getColor(ElementsNames.back);
                    Paint lc = ((LegendText)c).legendColor;
                    boolean bt = bc.getTransparency() != 1;
                    boolean bl = lt = lc.getTransparency() != 1;
                    if (bt && lt) {
                        this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, this.gdef.getColor(ElementsNames.canvas));
                    }
                    if (lt) {
                        this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, bc);
                    }
                    this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, lc);
                    this.worker.drawString(c.resolvedText, x + boxSpace, y, this.gdef.getFont(RrdGraphConstants.FONTTAG_LEGEND), this.gdef.getColor(ElementsNames.font));
                    continue;
                }
                this.worker.drawString(c.resolvedText, x, y, this.gdef.getFont(RrdGraphConstants.FONTTAG_LEGEND), this.gdef.getColor(ElementsNames.font));
            }
            this.worker.setTextAntiAliasing(false);
        }
    }

    double getFontHeight(RrdGraphConstants.FontTag fonttag) {
        return this.worker.getFontHeight(this.gdef.getFont(fonttag));
    }

    double getFontCharWidth(RrdGraphConstants.FontTag fonttag) {
        return this.worker.getStringWidth("a", this.gdef.getFont(fonttag));
    }

    double getInterlegendSpace() {
        return this.getFontCharWidth(RrdGraphConstants.FONTTAG_LEGEND) * 2.0;
    }

    double getLeading() {
        return this.getFontHeight(RrdGraphConstants.FONTTAG_LEGEND) * 1.2;
    }

    double getSmallLeading() {
        return this.getFontHeight(RrdGraphConstants.FONTTAG_LEGEND) * 0.7;
    }

    double getBoxSpace() {
        return Math.ceil(this.getFontHeight(RrdGraphConstants.FONTTAG_LEGEND) * 1.2);
    }

    private double getBox() {
        return this.getFontHeight(RrdGraphConstants.FONTTAG_LEGEND) * 0.9;
    }

    private double[] xtr(long[] timestamps) {
        double[] timestampsDev = new double[2 * timestamps.length - 1];
        int i = 0;
        int j = 0;
        while (i < timestamps.length) {
            timestampsDev[j] = this.mapper.xtr(timestamps[i]);
            if (i < timestamps.length - 1) {
                timestampsDev[j + 1] = timestampsDev[j];
            }
            ++i;
            j += 2;
        }
        return timestampsDev;
    }

    private double[] ytr(double[] values) {
        double[] valuesDev = new double[2 * values.length - 1];
        int i = 0;
        int j = 0;
        while (i < values.length) {
            valuesDev[j] = Double.isNaN(values[i]) ? Double.NaN : (double)this.mapper.ytr(values[i]);
            if (j > 0) {
                valuesDev[j - 1] = valuesDev[j];
            }
            ++i;
            j += 2;
        }
        return valuesDev;
    }
}

