/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.connection.ServerDescription;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.bson.conversions.Bson;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendAnnotation;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMongoDBNewBackend;

@RrdBackendAnnotation(name="MONGODBNEW", shouldValidateHeader=false, scheme="mongodb")
public class RrdMongoDBNewBackendFactory
extends RrdBackendFactory {
    private final URI rootUri;
    private final MongoClient client;
    private final MongoCollection<DBObject> rrdCollection;

    public RrdMongoDBNewBackendFactory(MongoClient client, MongoCollection<DBObject> rrdCollection) {
        this.client = client;
        this.rrdCollection = rrdCollection;
        MongoNamespace ns = rrdCollection.getNamespace();
        List<ServerAddress> servers = client.getClusterDescription().getServerDescriptions().stream().map(ServerDescription::getAddress).collect(Collectors.toList());
        this.rootUri = this.buildRootUri(ns.getDatabaseName(), ns.getCollectionName(), servers);
        this.makeIndex();
    }

    private URI buildRootUri(String dbName, String collectionName, List<ServerAddress> servers) {
        StringBuilder buffer = new StringBuilder();
        for (ServerAddress sa : servers) {
            buffer.append(sa.getHost()).append(":").append(sa.getPort()).append(",");
        }
        buffer.deleteCharAt(buffer.length() - 1);
        try {
            return new URI("mongodb", buffer.toString(), "/" + dbName + "/" + collectionName + "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
    }

    private void makeIndex() {
        this.rrdCollection.createIndex((Bson)new BasicDBObject("path", (Object)1));
    }

    @Override
    public URI getRootUri() {
        return this.rootUri;
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdMongoDBNewBackend(path, this.rrdCollection);
    }

    @Override
    protected boolean exists(String path) throws IOException {
        BasicDBObject query = new BasicDBObject();
        query.put((Object)"path", (Object)path);
        return this.rrdCollection.countDocuments((Bson)query) != 0L;
    }

    @Override
    protected URI resolve(URI rootUri, URI uri, boolean relative) {
        try {
            URI tryUri = new URI(uri.getScheme(), null, uri.getPath(), uri.getQuery(), uri.getFragment());
            URI resolvedUri = super.resolve(rootUri, tryUri, relative);
            if (resolvedUri == null) {
                return null;
            }
            String rawHost = uri.getRawAuthority();
            if (rawHost == null || rawHost.isEmpty()) {
                return resolvedUri;
            }
            HashSet<ServerAddress> tryHosts = new HashSet<ServerAddress>();
            int n = 0;
            String[] stringArray = rawHost.split(",");
            int n2 = stringArray.length;
            if (n < n2) {
                String hostInfo = stringArray[n];
                tryHosts.add(this.resolveServerAddress(hostInfo));
                if (!Collections.disjoint(tryHosts, this.servers())) {
                    return resolvedUri;
                }
                return null;
            }
        }
        catch (URISyntaxException e) {
            return null;
        }
        return null;
    }

    private ServerAddress resolveServerAddress(String hostInfo) {
        String[] parts = hostInfo.split(":");
        if (parts.length == 1) {
            return new ServerAddress(parts[0]);
        }
        if (parts.length == 2) {
            try {
                return new ServerAddress(parts[0], Integer.parseInt(parts[1]));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("can't parse mongodb URI " + hostInfo);
            }
        }
        throw new IllegalArgumentException("can't parse mongodb URI " + hostInfo);
    }

    public List<ServerAddress> servers() {
        return this.client.getClusterDescription().getServerDescriptions().stream().map(ServerDescription::getAddress).collect(Collectors.toList());
    }

    @Override
    public boolean canStore(URI uri) {
        if ((uri = this.resolve(this.rootUri, uri, false)) == null) {
            return false;
        }
        String rawHost = uri.getRawAuthority();
        if (rawHost == null || rawHost.isEmpty()) {
            return true;
        }
        HashSet<ServerAddress> tryHosts = new HashSet<ServerAddress>();
        for (String hostInfo : rawHost.split(",")) {
            tryHosts.add(this.resolveServerAddress(hostInfo));
        }
        return !Collections.disjoint(tryHosts, this.servers());
    }

    @Override
    public void close() throws IOException {
        this.client.close();
    }
}

