/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import java.net.URI;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Stream;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;

public class RrdDbPool {
    public static final int INITIAL_CAPACITY = 200;
    private int maxCapacity = 200;
    private Semaphore usage = new Semaphore(this.maxCapacity);
    private final ReentrantReadWriteLock.WriteLock usageWLock;
    private final ReentrantReadWriteLock.ReadLock usageRLock;
    private final Condition fullCondition;
    private final AtomicBoolean waitFull = new AtomicBoolean(false);
    private final ConcurrentMap<URI, RrdEntry> pool = new ConcurrentHashMap<URI, RrdEntry>(200);
    private RrdBackendFactory defaultFactory;

    public static RrdDbPool getInstance() {
        return RrdDbPoolSingletonHolder.instance;
    }

    public RrdDbPool() {
        this(RrdBackendFactory.getDefaultFactory());
    }

    public RrdDbPool(RrdBackendFactory defaultFactory) {
        this.defaultFactory = defaultFactory;
        ReentrantReadWriteLock usageLock = new ReentrantReadWriteLock(true);
        this.usageWLock = usageLock.writeLock();
        this.usageRLock = usageLock.readLock();
        this.fullCondition = this.usageWLock.newCondition();
    }

    public int getOpenFileCount() {
        return this.pool.size();
    }

    public URI[] getOpenUri() {
        return (URI[])this.pool.keySet().stream().toArray(URI[]::new);
    }

    public Stream<URI> getOpenUriStream() {
        return this.pool.keySet().stream();
    }

    public String[] getOpenFiles() {
        return (String[])this.pool.keySet().stream().map(URI::getPath).toArray(String[]::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RrdEntry getEntry(URI uri, boolean cancreate) throws InterruptedException {
        RrdEntry ref = null;
        try {
            CompletableFuture holder = new CompletableFuture();
            do {
                try {
                    ref = this.pool.compute(uri, (u, e) -> {
                        try {
                            if (e == null) {
                                if (!cancreate) throw new IllegalStateException("Unknown URI in pool: " + u);
                                this.usageRLock.lockInterruptibly();
                                try {
                                    if (!this.usage.tryAcquire()) {
                                        throw new PoolFullException();
                                    }
                                    RrdEntry r = new RrdEntry((URI)u);
                                    holder.complete(r);
                                    r.lock.lock();
                                    RrdEntry rrdEntry = new RrdEntry(r);
                                    return rrdEntry;
                                }
                                finally {
                                    this.usageRLock.unlock();
                                }
                            }
                            if (e.placeholder) {
                                return e;
                            }
                            e.lock.lock();
                            holder.complete(e);
                            return new RrdEntry((RrdEntry)e);
                        }
                        catch (InterruptedException ex) {
                            holder.completeExceptionally(ex);
                            return null;
                        }
                    });
                }
                catch (PoolFullException e2) {
                    ref = null;
                    try {
                        this.usageWLock.lockInterruptibly();
                        this.waitFull.set(true);
                        this.fullCondition.await();
                    }
                    catch (InterruptedException ex) {
                        holder.completeExceptionally(ex);
                        Thread.currentThread().interrupt();
                    }
                    finally {
                        if (this.usageWLock.isHeldByCurrentThread()) {
                            this.waitFull.set(false);
                            this.usageWLock.unlock();
                        }
                    }
                }
                if (ref == null || holder.isDone()) continue;
                ref.lock.lockInterruptibly();
                ref.lock.unlock();
            } while (!holder.isDone());
            return (RrdEntry)holder.get();
        }
        catch (ExecutionException e3) {
            InterruptedException ex = (InterruptedException)e3.getCause();
            Thread.currentThread().interrupt();
            throw ex;
        }
        catch (InterruptedException | RuntimeException e4) {
            this.passNext(ACTION.SWAP, ref);
            if (e4 instanceof InterruptedException) {
                Thread.currentThread().interrupt();
            }
            throw e4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void passNext(ACTION a, RrdEntry e) {
        if (e == null) {
            return;
        }
        RrdEntry o = null;
        switch (a.ordinal()) {
            case 0: {
                o = this.pool.put(e.uri, e);
                break;
            }
            case 1: {
                o = (RrdEntry)this.pool.remove(e.uri);
                this.usage.release();
                assert (o == null || o.placeholder);
                if (!this.waitFull.get()) break;
                try {
                    this.usageWLock.lockInterruptibly();
                    this.fullCondition.signalAll();
                    if (!this.usageWLock.isHeldByCurrentThread()) break;
                    this.usageWLock.unlock();
                    break;
                }
                catch (InterruptedException e1) {
                    try {
                        Thread.currentThread().interrupt();
                        if (!this.usageWLock.isHeldByCurrentThread()) break;
                        this.usageWLock.unlock();
                        break;
                    }
                    catch (Throwable throwable) {
                        if (this.usageWLock.isHeldByCurrentThread()) {
                            this.usageWLock.unlock();
                        }
                        throw throwable;
                    }
                }
            }
        }
        assert (o != e) : String.format("Same entry, action=%s, entry=%s\n", new Object[]{a, e});
        assert (o == null || e.placeholder && !o.placeholder || o.placeholder && !e.placeholder) : String.format("Inconsistent entry, action=%s, in=%s out=%s\n", new Object[]{a, e, o});
        e.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void release(RrdDb rrdDb) throws IOException {
        RrdEntry ref;
        if (rrdDb == null) {
            return;
        }
        URI dburi = rrdDb.getCanonicalUri();
        try {
            ref = this.getEntry(dburi, false);
        }
        catch (IllegalStateException e) {
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Release interrupted for " + rrdDb.getPath(), e);
        }
        if (ref == null) {
            throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], not using pool for it");
        }
        if (ref.rrdDb == null) {
            this.passNext(ACTION.DROP, ref);
            throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], pool corruption");
        }
        if (ref.count <= 0) {
            this.passNext(ACTION.DROP, ref);
            throw new IllegalStateException("Could not release [" + rrdDb.getPath() + "], the file was never requested");
        }
        if (--ref.count == 0) {
            try {
                ref.rrdDb.internalClose();
                ref.rrdDb = null;
            }
            finally {
                this.passNext(ACTION.DROP, ref);
                ref.waitempty.countDown();
            }
        } else {
            this.passNext(ACTION.SWAP, ref);
        }
    }

    public RrdDb requestRrdDb(String path) throws IOException {
        return this.requestRrdDb(this.defaultFactory.getUri(path), this.defaultFactory);
    }

    public RrdDb requestRrdDb(URI uri) throws IOException {
        return this.requestRrdDb(uri, this.checkFactory(uri));
    }

    private RrdEntry waitEmpty(URI uri) throws InterruptedException {
        RrdEntry ref = this.getEntry(uri, true);
        try {
            while (ref.count != 0) {
                this.passNext(ACTION.SWAP, ref);
                ref.waitempty.await();
                ref = this.getEntry(uri, true);
            }
            return ref;
        }
        catch (InterruptedException e) {
            this.passNext(ACTION.SWAP, ref);
            Thread.currentThread().interrupt();
            throw e;
        }
    }

    private RrdEntry requestEmpty(URI uri) throws InterruptedException {
        return this.waitEmpty(uri);
    }

    RrdDb requestRrdDb(URI uri, RrdBackendFactory factory) throws IOException {
        uri = factory.getCanonicalUri(uri);
        try {
            RrdEntry ref = this.getEntry(uri, true);
            if (ref.count == 0) {
                try {
                    ref.rrdDb = RrdDb.getBuilder().setPath(factory.getPath(uri)).setBackendFactory(factory).setPoolInternal(this).build();
                }
                catch (IOException | RuntimeException e) {
                    this.passNext(ACTION.DROP, ref);
                    throw e;
                }
            }
            ++ref.count;
            this.passNext(ACTION.SWAP, ref);
            return ref.rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("request interrupted for " + uri, e);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    RrdDb requestRrdDb(RrdDef rrdDef, RrdBackendFactory factory) throws IOException {
        RrdDb rrdDb;
        RrdEntry ref = null;
        try {
            URI uri = factory.getCanonicalUri(rrdDef.getUri());
            ref = this.requestEmpty(uri);
            ref.rrdDb = RrdDb.getBuilder().setRrdDef(rrdDef).setBackendFactory(factory).setPoolInternal(this).build();
            ref.count = 1;
            rrdDb = ref.rrdDb;
        }
        catch (InterruptedException e) {
            try {
                Thread.currentThread().interrupt();
                throw new IllegalStateException("request interrupted for new rrdDef " + rrdDef.getPath(), e);
                catch (RuntimeException e2) {
                    this.passNext(ACTION.DROP, ref);
                    ref = null;
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                this.passNext(ACTION.SWAP, ref);
                throw throwable;
            }
        }
        this.passNext(ACTION.SWAP, ref);
        return rrdDb;
    }

    private RrdDb requestRrdDb(RrdDb.Builder builder, URI uri, RrdBackendFactory factory) throws IOException {
        RrdEntry ref = null;
        uri = factory.getCanonicalUri(uri);
        try {
            ref = this.requestEmpty(uri);
            ref.rrdDb = builder.setPath(uri).setBackendFactory(factory).setPoolInternal(this).build();
            ref.count = 1;
            RrdDb rrdDb = ref.rrdDb;
            return rrdDb;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("request interrupted for new rrd " + uri, e);
        }
        catch (RuntimeException e) {
            this.passNext(ACTION.DROP, ref);
            ref = null;
            throw e;
        }
        finally {
            this.passNext(ACTION.SWAP, ref);
        }
    }

    RrdDb requestRrdDb(URI uri, RrdBackendFactory factory, DataImporter importer) throws IOException {
        return this.requestRrdDb(RrdDb.getBuilder().setImporter(importer), uri, factory);
    }

    public RrdDb requestRrdDb(RrdDef rrdDef) throws IOException {
        return this.requestRrdDb(rrdDef, this.checkFactory(rrdDef.getUri()));
    }

    public RrdDb requestRrdDb(String path, String sourcePath) throws IOException {
        URI uri = this.defaultFactory.getUri(path);
        return this.requestRrdDb(RrdDb.getBuilder().setExternalPath(sourcePath), uri, this.defaultFactory);
    }

    public RrdDb requestRrdDb(URI uri, String sourcePath) throws IOException {
        return this.requestRrdDb(RrdDb.getBuilder().setExternalPath(sourcePath), uri, this.checkFactory(uri));
    }

    @Deprecated
    public void setDefaultFactory(RrdBackendFactory defaultFactory) {
        try {
            this.usageWLock.lockInterruptibly();
            if (this.usage.availablePermits() != this.maxCapacity) {
                throw new IllegalStateException("Can only be done on a empty pool");
            }
            this.defaultFactory = defaultFactory;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Factory not changed");
        }
        finally {
            if (this.usageWLock.isHeldByCurrentThread()) {
                this.usageWLock.unlock();
            }
        }
    }

    public void setCapacity(int newCapacity) {
        try {
            this.usageWLock.lockInterruptibly();
            if (this.usage.availablePermits() != this.maxCapacity) {
                throw new IllegalStateException("Can only be done on a empty pool");
            }
            this.maxCapacity = newCapacity;
            this.usage = new Semaphore(this.maxCapacity);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Resizing interrupted");
        }
        finally {
            if (this.usageWLock.isHeldByCurrentThread()) {
                this.usageWLock.unlock();
            }
        }
    }

    public int getCapacity() {
        try {
            this.usageRLock.lockInterruptibly();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Interrupted, can't get pool size");
        }
        try {
            int n = this.maxCapacity;
            return n;
        }
        finally {
            this.usageRLock.unlock();
        }
    }

    public int getOpenCount(RrdDb rrdDb) {
        return this.getCanonicalUriUsage(rrdDb.getCanonicalUri());
    }

    public int getOpenCount(String path) {
        return this.getCanonicalUriUsage(this.defaultFactory.getCanonicalUri(this.defaultFactory.getUri(path)));
    }

    public int getOpenCount(URI uri) {
        return this.getCanonicalUriUsage(this.checkFactory(uri).getCanonicalUri(uri));
    }

    private int getCanonicalUriUsage(URI uri) {
        RrdEntry ref = null;
        try {
            ref = this.getEntry(uri, false);
            int n = Optional.ofNullable(ref).map(e -> e.count).orElse(0);
            return n;
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("getOpenCount interrupted", e2);
        }
        finally {
            this.passNext(ACTION.SWAP, ref);
        }
    }

    public Lock lockEmpty(long timeout, TimeUnit unit) throws InterruptedException {
        this.usageWLock.tryLock(timeout, unit);
        try {
            this.usage.acquire(this.maxCapacity);
        }
        catch (InterruptedException e) {
            this.usageWLock.unlock();
            Thread.currentThread().interrupt();
            throw e;
        }
        return this.usageWLock;
    }

    private RrdBackendFactory checkFactory(URI uri) {
        return this.defaultFactory.canStore(uri) ? this.defaultFactory : RrdBackendFactory.findFactory(uri);
    }

    private static class RrdDbPoolSingletonHolder {
        static final RrdDbPool instance = new RrdDbPool();

        private RrdDbPoolSingletonHolder() {
        }
    }

    private static class RrdEntry {
        RrdDb rrdDb = null;
        int count = 0;
        final CountDownLatch waitempty;
        final ReentrantReadWriteLock inuse;
        final Lock lock;
        final boolean placeholder;
        final URI uri;

        RrdEntry(URI canonicalPath) {
            this.placeholder = false;
            this.uri = canonicalPath;
            this.inuse = new ReentrantReadWriteLock();
            this.lock = this.inuse.writeLock();
            this.waitempty = new CountDownLatch(1);
        }

        RrdEntry(RrdEntry parent) {
            assert (!parent.placeholder);
            this.placeholder = true;
            this.uri = parent.uri;
            this.inuse = null;
            this.lock = parent.inuse.readLock();
            this.waitempty = null;
        }

        public String toString() {
            if (this.placeholder) {
                return String.format("RrdEntry [placeholder, uri=%s]", this.uri);
            }
            return String.format("RrdEntry [count=%d, rrdDb=%s, uri %s]", this.count, this.rrdDb, this.uri);
        }
    }

    private static class PoolFullException
    extends RuntimeException {
        PoolFullException() {
            super("", null, false, false);
        }
    }

    private static enum ACTION {
        SWAP,
        DROP;

    }
}

