/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendAnnotation;
import org.rrd4j.core.RrdBackendException;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdBerkeleyDbBackend;

@RrdBackendAnnotation(name="BERKELEY", shouldValidateHeader=false)
public class RrdBerkeleyDbBackendFactory
extends RrdBackendFactory {
    private final Database rrdDatabase;
    private final Set<String> pathCache = new CopyOnWriteArraySet<String>();

    public RrdBerkeleyDbBackendFactory(Database rrdDatabase) {
        this.rrdDatabase = rrdDatabase;
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        if (this.pathCache.contains(path)) {
            DatabaseEntry theKey = new DatabaseEntry(path.getBytes(StandardCharsets.UTF_8));
            DatabaseEntry theData = new DatabaseEntry();
            try {
                this.rrdDatabase.get(null, theKey, theData, LockMode.DEFAULT);
            }
            catch (DatabaseException de) {
                throw new RrdBackendException("BerkeleyDB DatabaseException on " + path + "; " + de.getMessage(), de);
            }
            return new RrdBerkeleyDbBackend(theData.getData(), path, this.rrdDatabase);
        }
        return new RrdBerkeleyDbBackend(path, this.rrdDatabase);
    }

    @Override
    public URI getUri(String path) {
        try {
            return new URI("berkeley", "", this.rrdDatabase.getEnvironment().getHome().getAbsolutePath(), this.rrdDatabase.getDatabaseName(), path);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("can't extract URI from '" + path + "': " + e.getMessage(), e);
        }
    }

    @Override
    public String getPath(URI uri) {
        return uri.getFragment();
    }

    @Override
    public boolean canStore(URI uri) {
        if (!"berkeley".equals(uri.getScheme())) {
            return false;
        }
        if (!uri.getPath().isEmpty() && !uri.getPath().equals(this.rrdDatabase.getEnvironment().getHome().getAbsolutePath())) {
            return false;
        }
        return uri.getQuery().isEmpty() || uri.getQuery().equals(this.rrdDatabase.getDatabaseName());
    }

    public void delete(String path) {
        try {
            this.rrdDatabase.delete(null, new DatabaseEntry(path.getBytes(StandardCharsets.UTF_8)));
        }
        catch (DatabaseException de) {
            throw new RuntimeException(de.getMessage(), de);
        }
        this.pathCache.remove(path);
    }

    @Override
    protected boolean exists(String path) throws IOException {
        if (this.pathCache.contains(path)) {
            return true;
        }
        DatabaseEntry theKey = new DatabaseEntry(path.getBytes(StandardCharsets.UTF_8));
        DatabaseEntry theData = new DatabaseEntry();
        theData.setPartial(0, 0, true);
        try {
            boolean pathExists;
            boolean bl = pathExists = this.rrdDatabase.get(null, theKey, theData, LockMode.DEFAULT) == OperationStatus.SUCCESS;
            if (pathExists) {
                this.pathCache.add(path);
            }
            return pathExists;
        }
        catch (DatabaseException de) {
            throw new RrdBackendException("BerkeleyDB DatabaseException on " + path + "; " + de.getMessage(), de);
        }
    }

    @Override
    public void close() {
        this.rrdDatabase.close();
    }
}

