/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.Matcher;
import org.forgerock.opendj.ldif.AbstractLDIFWriter;
import org.forgerock.opendj.ldif.EntryWriter;

public final class LDIFEntryWriter
extends AbstractLDIFWriter
implements EntryWriter {
    public static String toString(Entry entry) {
        StringWriter writer = new StringWriter(128);
        try {
            new LDIFEntryWriter(writer).setAddUserFriendlyComments(true).writeEntry(entry).close();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return writer.toString();
    }

    public LDIFEntryWriter(List<String> ldifLines) {
        super(ldifLines);
    }

    public LDIFEntryWriter(OutputStream out) {
        super(out);
    }

    public LDIFEntryWriter(Writer writer) {
        super(writer);
    }

    @Override
    public void close() throws IOException {
        this.close0();
    }

    @Override
    public void flush() throws IOException {
        this.flush0();
    }

    public LDIFEntryWriter setAddUserFriendlyComments(boolean addUserFriendlyComments) {
        this.addUserFriendlyComments = addUserFriendlyComments;
        return this;
    }

    public LDIFEntryWriter setExcludeAllOperationalAttributes(boolean excludeOperationalAttributes) {
        this.excludeOperationalAttributes = excludeOperationalAttributes;
        return this;
    }

    public LDIFEntryWriter setExcludeAllUserAttributes(boolean excludeUserAttributes) {
        this.excludeUserAttributes = excludeUserAttributes;
        return this;
    }

    public LDIFEntryWriter setExcludeAttribute(AttributeDescription attributeDescription) {
        Validator.ensureNotNull(attributeDescription);
        this.excludeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFEntryWriter setExcludeBranch(DN excludeBranch) {
        Validator.ensureNotNull(excludeBranch);
        this.excludeBranches.add(excludeBranch);
        return this;
    }

    public LDIFEntryWriter setExcludeFilter(Matcher excludeFilter) {
        Validator.ensureNotNull(excludeFilter);
        this.excludeFilters.add(excludeFilter);
        return this;
    }

    public LDIFEntryWriter setIncludeAttribute(AttributeDescription attributeDescription) {
        Validator.ensureNotNull(attributeDescription);
        this.includeAttributes.add(attributeDescription);
        return this;
    }

    public LDIFEntryWriter setIncludeBranch(DN includeBranch) {
        Validator.ensureNotNull(includeBranch);
        this.includeBranches.add(includeBranch);
        return this;
    }

    public LDIFEntryWriter setIncludeFilter(Matcher includeFilter) {
        Validator.ensureNotNull(includeFilter);
        this.includeFilters.add(includeFilter);
        return this;
    }

    public LDIFEntryWriter setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
        return this;
    }

    @Override
    public LDIFEntryWriter writeComment(CharSequence comment) throws IOException {
        this.writeComment0(comment);
        return this;
    }

    @Override
    public LDIFEntryWriter writeEntry(Entry entry) throws IOException {
        Validator.ensureNotNull(entry);
        if (this.isBranchExcluded(entry.getName())) {
            return this;
        }
        if (this.isEntryExcluded(entry)) {
            return this;
        }
        this.writeKeyAndValue((CharSequence)"dn", entry.getName().toString());
        for (Attribute attribute : entry.getAllAttributes()) {
            if (this.isAttributeExcluded(attribute.getAttributeDescription())) continue;
            String attributeDescription = attribute.getAttributeDescriptionAsString();
            if (attribute.isEmpty()) {
                this.writeKeyAndValue((CharSequence)attributeDescription, ByteString.empty());
                continue;
            }
            for (ByteString value : attribute) {
                this.writeKeyAndValue((CharSequence)attributeDescription, value);
            }
        }
        this.impl.println();
        return this;
    }
}

