/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldif;

import com.forgerock.opendj.util.Validator;
import java.util.NoSuchElementException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.ErrorResultIOException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchResultReferenceIOException;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.EntryReader;

public class ConnectionEntryReader
implements EntryReader {
    private final BufferHandler buffer;
    private final FutureResult<Result> future;
    private Response nextResponse = null;

    public ConnectionEntryReader(Connection connection, SearchRequest searchRequest) {
        this(connection, searchRequest, new LinkedBlockingQueue<Response>());
    }

    public ConnectionEntryReader(Connection connection, SearchRequest searchRequest, BlockingQueue<Response> entries) {
        Validator.ensureNotNull(connection);
        this.buffer = new BufferHandler(entries);
        this.future = connection.searchAsync(searchRequest, null, this.buffer);
    }

    @Override
    public void close() {
        this.future.cancel(true);
    }

    @Override
    public boolean hasNext() throws ErrorResultIOException {
        Response r = this.getNextResponse();
        if (!(r instanceof Result)) {
            return true;
        }
        Result result = (Result)r;
        if (result.isSuccess()) {
            return false;
        }
        throw new ErrorResultIOException(ErrorResultException.newErrorResult(result));
    }

    public boolean isEntry() throws ErrorResultIOException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Response r = this.nextResponse;
        if (r instanceof SearchResultEntry) {
            return true;
        }
        if (r instanceof SearchResultReference) {
            return false;
        }
        throw new RuntimeException("Unexpected response type: " + r.getClass().toString());
    }

    public boolean isReference() throws ErrorResultIOException {
        return !this.isEntry();
    }

    @Override
    public SearchResultEntry readEntry() throws SearchResultReferenceIOException, ErrorResultIOException {
        if (this.isEntry()) {
            SearchResultEntry entry = (SearchResultEntry)this.nextResponse;
            this.nextResponse = null;
            return entry;
        }
        SearchResultReference reference = (SearchResultReference)this.nextResponse;
        this.nextResponse = null;
        throw new SearchResultReferenceIOException(reference);
    }

    public SearchResultReference readReference() throws ErrorResultIOException {
        if (this.isReference()) {
            SearchResultReference reference = (SearchResultReference)this.nextResponse;
            this.nextResponse = null;
            return reference;
        }
        return null;
    }

    public Result readResult() throws ErrorResultIOException {
        if (this.hasNext()) {
            throw new IllegalStateException();
        }
        return (Result)this.nextResponse;
    }

    private Response getNextResponse() throws ErrorResultIOException {
        while (this.nextResponse == null) {
            try {
                this.nextResponse = (Response)this.buffer.responses.poll(50L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                ErrorResultException ere = ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
                throw new ErrorResultIOException(ere);
            }
            if (this.nextResponse != null || !this.buffer.isInterrupted) continue;
            this.nextResponse = Responses.newResult(ResultCode.CLIENT_SIDE_LOCAL_ERROR);
            break;
        }
        return this.nextResponse;
    }

    private static final class BufferHandler
    implements SearchResultHandler {
        private final BlockingQueue<Response> responses;
        private volatile boolean isInterrupted = false;

        private BufferHandler(BlockingQueue<Response> responses) {
            this.responses = responses;
        }

        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            try {
                this.responses.put(entry);
                return true;
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            try {
                this.responses.put(error.getResult());
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public boolean handleReference(SearchResultReference reference) {
            try {
                this.responses.put(reference);
                return true;
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
                return false;
            }
        }

        @Override
        public void handleResult(Result result) {
            try {
                this.responses.put(result);
            }
            catch (InterruptedException e) {
                this.isInterrupted = true;
                Thread.currentThread().interrupt();
            }
        }
    }
}

