/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.PrintableStringSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class TelexNumberSyntaxImpl
extends AbstractSyntaxImpl {
    TelexNumberSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "TelexNumber";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return false;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        int pos;
        String valueString = value.toString();
        int valueLength = valueString.length();
        if (valueLength < 5) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_TOO_SHORT.get((Object)valueString));
            return false;
        }
        char c = valueString.charAt(0);
        if (!PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE.get((Object)valueString, (Object)String.valueOf(c), (Object)0));
            return false;
        }
        for (pos = 1; pos < valueLength; ++pos) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (PrintableStringSyntaxImpl.isPrintableCharacter(c)) continue;
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR.get((Object)valueString, (Object)String.valueOf(c), (Object)pos));
        }
        if (pos >= valueLength) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_TRUNCATED.get((Object)valueString));
            return false;
        }
        if (!PrintableStringSyntaxImpl.isPrintableCharacter(c = valueString.charAt(pos++))) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE.get((Object)valueString, (Object)String.valueOf(c), (Object)(pos - 1)));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (c == '$') {
                ++pos;
                break;
            }
            if (!PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR.get((Object)valueString, (Object)String.valueOf(c), (Object)pos));
                return false;
            }
            ++pos;
        }
        if (pos >= valueLength) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_TRUNCATED.get((Object)valueString));
            return false;
        }
        if (!PrintableStringSyntaxImpl.isPrintableCharacter(c = valueString.charAt(pos++))) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_NOT_PRINTABLE.get((Object)valueString, (Object)String.valueOf(c), (Object)(pos - 1)));
            return false;
        }
        while (pos < valueLength) {
            c = valueString.charAt(pos);
            if (!PrintableStringSyntaxImpl.isPrintableCharacter(c)) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_TELEX_ILLEGAL_CHAR.get((Object)valueString, (Object)String.valueOf(c), (Object)pos));
                return false;
            }
            ++pos;
        }
        return true;
    }
}

