/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.RegexSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SyntaxImpl;

public final class Syntax
extends SchemaElement {
    private final String oid;
    private final String definition;
    private MatchingRule equalityMatchingRule;
    private MatchingRule orderingMatchingRule;
    private MatchingRule substringMatchingRule;
    private MatchingRule approximateMatchingRule;
    private Schema schema;
    private SyntaxImpl impl;

    Syntax(Schema schema, String oid) {
        super("", Collections.singletonMap("X-SUBST", Collections.singletonList(schema.getDefaultSyntax().getOID())));
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.definition = this.buildDefinition();
        this.schema = schema;
        this.impl = schema.getDefaultSyntax().impl;
    }

    Syntax(String oid, String description, Map<String, List<String>> extraProperties, String definition, SyntaxImpl implementation) {
        super(description, extraProperties);
        Validator.ensureNotNull(oid);
        this.oid = oid;
        this.definition = definition != null ? definition : this.buildDefinition();
        this.impl = implementation;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof Syntax) {
            Syntax other = (Syntax)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public MatchingRule getApproximateMatchingRule() {
        return this.approximateMatchingRule;
    }

    public MatchingRule getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public String getOID() {
        return this.oid;
    }

    public MatchingRule getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public MatchingRule getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean isBEREncodingRequired() {
        return this.impl.isBEREncodingRequired();
    }

    public boolean isHumanReadable() {
        return this.impl.isHumanReadable();
    }

    @Override
    public String toString() {
        return this.definition;
    }

    public boolean valueIsAcceptable(ByteSequence value, LocalizableMessageBuilder invalidReason) {
        return this.impl.valueIsAcceptable(this.schema, value, invalidReason);
    }

    Syntax duplicate() {
        return new Syntax(this.oid, this.description, this.extraProperties, this.definition, this.impl);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        buffer.append(this.oid);
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        LocalizableMessage message;
        this.schema = schema;
        if (this.impl == null) {
            for (Map.Entry property : this.extraProperties.entrySet()) {
                String value;
                Iterator values;
                if (((String)property.getKey()).equalsIgnoreCase("x-subst")) {
                    LocalizableMessage message2;
                    values = ((List)property.getValue()).iterator();
                    if (!values.hasNext()) continue;
                    value = (String)values.next();
                    if (value.equals(this.oid)) {
                        message2 = CoreMessages.ERR_ATTR_SYNTAX_CYCLIC_SUB_SYNTAX.get((Object)this.oid);
                        throw new SchemaException(message2);
                    }
                    if (!schema.hasSyntax(value)) {
                        message2 = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUB_SYNTAX.get((Object)this.oid, (Object)value);
                        throw new SchemaException(message2);
                    }
                    Syntax subSyntax = schema.getSyntax(value);
                    if (subSyntax.impl == null) {
                        subSyntax.validate(schema, warnings);
                    }
                    this.impl = subSyntax.impl;
                    continue;
                }
                if (!((String)property.getKey()).equalsIgnoreCase("x-pattern") || !(values = ((List)property.getValue()).iterator()).hasNext()) continue;
                value = (String)values.next();
                try {
                    Pattern pattern = Pattern.compile(value);
                    this.impl = new RegexSyntaxImpl(pattern);
                }
                catch (Exception e) {
                    LocalizableMessage message3 = CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN.get((Object)this.oid, (Object)value);
                    throw new SchemaException(message3);
                }
            }
            if (this.impl == null && Schema.getDefaultSchema().hasSyntax(this.oid)) {
                this.impl = Schema.getDefaultSchema().getSyntax((String)this.oid).impl;
            }
            if (this.impl == null && Schema.getCoreSchema().hasSyntax(this.oid)) {
                this.impl = Schema.getCoreSchema().getSyntax((String)this.oid).impl;
            }
            if (this.impl == null) {
                Syntax defaultSyntax = schema.getDefaultSyntax();
                if (defaultSyntax.impl == null) {
                    defaultSyntax.validate(schema, warnings);
                }
                this.impl = defaultSyntax.impl;
                LocalizableMessage message4 = CoreMessages.WARN_ATTR_SYNTAX_NOT_IMPLEMENTED1.get((Object)this.getDescription(), (Object)this.oid, (Object)schema.getDefaultSyntax().getOID());
                warnings.add(message4);
            }
        }
        if (this.impl.getEqualityMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getEqualityMatchingRule())) {
                this.equalityMatchingRule = schema.getMatchingRule(this.impl.getEqualityMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_EQUALITY_MATCHING_RULE.get((Object)this.impl.getEqualityMatchingRule(), (Object)this.impl.getName());
                warnings.add(message);
            }
        }
        if (this.impl.getOrderingMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getOrderingMatchingRule())) {
                this.orderingMatchingRule = schema.getMatchingRule(this.impl.getOrderingMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_ORDERING_MATCHING_RULE.get((Object)this.impl.getOrderingMatchingRule(), (Object)this.impl.getName());
                warnings.add(message);
            }
        }
        if (this.impl.getSubstringMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getSubstringMatchingRule())) {
                this.substringMatchingRule = schema.getMatchingRule(this.impl.getSubstringMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_SUBSTRING_MATCHING_RULE.get((Object)this.impl.getSubstringMatchingRule(), (Object)this.impl.getName());
                warnings.add(message);
            }
        }
        if (this.impl.getApproximateMatchingRule() != null) {
            if (schema.hasMatchingRule(this.impl.getApproximateMatchingRule())) {
                this.approximateMatchingRule = schema.getMatchingRule(this.impl.getApproximateMatchingRule());
            } else {
                message = CoreMessages.ERR_ATTR_SYNTAX_UNKNOWN_APPROXIMATE_MATCHING_RULE.get((Object)this.impl.getApproximateMatchingRule(), (Object)this.impl.getName());
                warnings.add(message);
            }
        }
    }
}

