/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;

public final class SchemaValidationPolicy {
    private Policy checkNameForms = Policy.REJECT;
    private Policy checkDITStructureRules = Policy.IGNORE;
    private Policy checkDITContentRules = Policy.REJECT;
    private Policy requireSingleStructuralObjectClass = Policy.REJECT;
    private Policy checkAttributesAndObjectClasses = Policy.REJECT;
    private Policy checkAttributeValues = Policy.REJECT;
    private EntryResolver checkDITStructureRulesEntryResolver = null;

    public static SchemaValidationPolicy copyOf(SchemaValidationPolicy policy) {
        return SchemaValidationPolicy.defaultPolicy().assign(policy);
    }

    public static SchemaValidationPolicy defaultPolicy() {
        return new SchemaValidationPolicy();
    }

    public static SchemaValidationPolicy ignoreAll() {
        return new SchemaValidationPolicy().checkAttributesAndObjectClasses(Policy.IGNORE).checkAttributeValues(Policy.IGNORE).checkDITContentRules(Policy.IGNORE).checkNameForms(Policy.IGNORE).requireSingleStructuralObjectClass(Policy.IGNORE);
    }

    private SchemaValidationPolicy() {
    }

    public Policy checkAttributesAndObjectClasses() {
        return this.checkAttributesAndObjectClasses;
    }

    public SchemaValidationPolicy checkAttributesAndObjectClasses(Policy policy) {
        this.checkAttributesAndObjectClasses = policy;
        return this;
    }

    public Policy checkAttributeValues() {
        return this.checkAttributeValues;
    }

    public SchemaValidationPolicy checkAttributeValues(Policy policy) {
        this.checkAttributeValues = policy;
        return this;
    }

    public Policy checkDITContentRules() {
        return this.checkDITContentRules;
    }

    public SchemaValidationPolicy checkDITContentRules(Policy policy) {
        this.checkDITContentRules = policy;
        return this;
    }

    public Policy checkDITStructureRules() {
        return this.checkDITStructureRules;
    }

    public SchemaValidationPolicy checkDITStructureRules(Policy policy, EntryResolver resolver) {
        if (this.checkDITStructureRules.needsChecking() && resolver == null) {
            throw new IllegalArgumentException("Validation of structure rules enabled by resolver was null");
        }
        this.checkDITStructureRules = policy;
        this.checkDITStructureRulesEntryResolver = resolver;
        return this;
    }

    public EntryResolver checkDITStructureRulesEntryResolver() {
        return this.checkDITStructureRulesEntryResolver;
    }

    public Policy checkNameForms() {
        return this.checkNameForms;
    }

    public SchemaValidationPolicy checkNameForms(Policy policy) {
        this.checkNameForms = policy;
        return this;
    }

    public Policy requireSingleStructuralObjectClass() {
        return this.requireSingleStructuralObjectClass;
    }

    public SchemaValidationPolicy requireSingleStructuralObjectClass(Policy policy) {
        this.requireSingleStructuralObjectClass = policy;
        return this;
    }

    SchemaValidationPolicy assign(SchemaValidationPolicy policy) {
        this.checkAttributeValues = policy.checkAttributeValues;
        this.checkNameForms = policy.checkNameForms;
        this.checkAttributesAndObjectClasses = policy.checkAttributesAndObjectClasses;
        this.checkDITContentRules = policy.checkDITContentRules;
        this.checkDITStructureRules = policy.checkDITStructureRules;
        this.checkDITStructureRulesEntryResolver = policy.checkDITStructureRulesEntryResolver;
        this.requireSingleStructuralObjectClass = policy.requireSingleStructuralObjectClass;
        return this;
    }

    public static enum Policy {
        IGNORE,
        WARN,
        REJECT;


        public boolean isIgnore() {
            return this == IGNORE;
        }

        public boolean isReject() {
            return this == REJECT;
        }

        public boolean isWarn() {
            return this == WARN;
        }

        public boolean needsChecking() {
            return this != IGNORE;
        }
    }

    public static interface EntryResolver {
        public Entry getEntry(DN var1) throws ErrorResultException;
    }
}

