/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.FutureResultTransformer;
import com.forgerock.opendj.util.RecursiveFutureResult;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import com.forgerock.opendj.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.Filter;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.ConflictingSchemaElementException;
import org.forgerock.opendj.ldap.schema.CoreSchemaImpl;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.DITStructureRule;
import org.forgerock.opendj.ldap.schema.EnumOrderingMatchingRule;
import org.forgerock.opendj.ldap.schema.EnumSyntaxImpl;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.SchemaUtils;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.SyntaxImpl;

public final class SchemaBuilder {
    private static final String ATTR_SUBSCHEMA_SUBENTRY = "subschemaSubentry";
    private static final String[] SUBSCHEMA_ATTRS = new String[]{"ldapSyntaxes", "attributeTypes", "dITContentRules", "dITStructureRules", "matchingRuleUse", "matchingRules", "nameForms", "objectClasses"};
    private static final Filter SUBSCHEMA_FILTER = Filter.valueOf("(objectClass=subschema)");
    private static final String[] SUBSCHEMA_SUBENTRY_ATTRS = new String[]{"subschemaSubentry"};
    private Map<Integer, DITStructureRule> id2StructureRules;
    private Map<String, List<AttributeType>> name2AttributeTypes;
    private Map<String, List<DITContentRule>> name2ContentRules;
    private Map<String, List<MatchingRule>> name2MatchingRules;
    private Map<String, List<MatchingRuleUse>> name2MatchingRuleUses;
    private Map<String, List<NameForm>> name2NameForms;
    private Map<String, List<ObjectClass>> name2ObjectClasses;
    private Map<String, List<DITStructureRule>> name2StructureRules;
    private Map<String, List<DITStructureRule>> nameForm2StructureRules;
    private Map<String, AttributeType> numericOID2AttributeTypes;
    private Map<String, DITContentRule> numericOID2ContentRules;
    private Map<String, MatchingRule> numericOID2MatchingRules;
    private Map<String, MatchingRuleUse> numericOID2MatchingRuleUses;
    private Map<String, NameForm> numericOID2NameForms;
    private Map<String, ObjectClass> numericOID2ObjectClasses;
    private Map<String, Syntax> numericOID2Syntaxes;
    private Map<String, List<NameForm>> objectClass2NameForms;
    private String schemaName;
    private List<LocalizableMessage> warnings;
    private boolean allowNonStandardTelephoneNumbers;
    private boolean allowZeroLengthDirectoryStrings;
    private boolean allowMalformedNamesAndOptions;
    private boolean allowMalformedJPEGPhotos;
    private String defaultSyntaxOID;
    private String defaultMatchingRuleOID;
    private Schema copyOnWriteSchema = null;
    private static final AtomicInteger NEXT_SCHEMA_ID = new AtomicInteger();

    private static SearchRequest getReadSchemaForEntrySearchRequest(DN dn) {
        return Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, Filter.objectClassPresent(), SUBSCHEMA_SUBENTRY_ATTRS);
    }

    private static SearchRequest getReadSchemaSearchRequest(DN dn) {
        return Requests.newSearchRequest(dn, SearchScope.BASE_OBJECT, SUBSCHEMA_FILTER, SUBSCHEMA_ATTRS);
    }

    private static DN getSubschemaSubentryDN(DN name, Entry entry) throws ErrorResultException {
        DN subschemaDN;
        Attribute subentryAttr = entry.getAttribute(ATTR_SUBSCHEMA_SUBENTRY);
        if (subentryAttr == null || subentryAttr.isEmpty()) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_NO_SUBSCHEMA_SUBENTRY_ATTR.get((Object)name.toString()).toString());
        }
        String dnString = subentryAttr.iterator().next().toString();
        try {
            subschemaDN = DN.valueOf(dnString);
        }
        catch (LocalizedIllegalArgumentException e) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_NO_RESULTS_RETURNED, CoreMessages.ERR_INVALID_SUBSCHEMA_SUBENTRY_ATTR.get((Object)name.toString(), (Object)dnString, (Object)e.getMessageObject()).toString());
        }
        return subschemaDN;
    }

    public SchemaBuilder() {
        this.preLazyInitBuilder(null, null);
    }

    public SchemaBuilder(Entry entry) {
        this.preLazyInitBuilder(entry.getName().toString(), null);
        this.addSchema(entry, true);
    }

    public SchemaBuilder(Schema schema) {
        this.preLazyInitBuilder(schema.getSchemaName(), schema);
    }

    public SchemaBuilder(String schemaName) {
        this.preLazyInitBuilder(schemaName, null);
    }

    public SchemaBuilder addAttributeType(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            String superiorType = null;
            String equalityMatchingRule = null;
            String orderingMatchingRule = null;
            String substringMatchingRule = null;
            String approximateMatchingRule = null;
            String syntax = null;
            boolean isSingleValue = false;
            boolean isCollective = false;
            boolean isNoUserModification = false;
            AttributeUsage attributeUsage = AttributeUsage.USER_APPLICATIONS;
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("sup")) {
                    superiorType = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("equality")) {
                    equalityMatchingRule = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("ordering")) {
                    orderingMatchingRule = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("substr")) {
                    substringMatchingRule = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("syntax")) {
                    syntax = SchemaUtils.readOIDLen(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("single-definition")) {
                    isSingleValue = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("single-value")) {
                    isSingleValue = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("collective")) {
                    isCollective = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("no-user-modification")) {
                    isNoUserModification = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("usage")) {
                    int length = 0;
                    reader.skipWhitespaces();
                    reader.mark();
                    while (" )".indexOf(reader.read()) == -1) {
                        ++length;
                    }
                    reader.reset();
                    String usageStr = reader.read(length);
                    if (usageStr.equalsIgnoreCase("userapplications")) {
                        attributeUsage = AttributeUsage.USER_APPLICATIONS;
                        continue;
                    }
                    if (usageStr.equalsIgnoreCase("directoryoperation")) {
                        attributeUsage = AttributeUsage.DIRECTORY_OPERATION;
                        continue;
                    }
                    if (usageStr.equalsIgnoreCase("distributedoperation")) {
                        attributeUsage = AttributeUsage.DISTRIBUTED_OPERATION;
                        continue;
                    }
                    if (usageStr.equalsIgnoreCase("dsaoperation")) {
                        attributeUsage = AttributeUsage.DSA_OPERATION;
                        continue;
                    }
                    LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_ATTRIBUTE_USAGE1.get((Object)definition, (Object)usageStr);
                    throw new LocalizedIllegalArgumentException(message);
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            List approxRules = (List)extraProperties.get("X-APPROX");
            if (approxRules != null && !approxRules.isEmpty()) {
                approximateMatchingRule = (String)approxRules.get(0);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            if (superiorType == null && syntax == null) {
                LocalizableMessage msg = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_MISSING_SYNTAX_AND_SUPERIOR.get((Object)definition);
                throw new LocalizedIllegalArgumentException(msg);
            }
            AttributeType attrType = new AttributeType(oid, names, description, isObsolete, superiorType, equalityMatchingRule, orderingMatchingRule, substringMatchingRule, approximateMatchingRule, syntax, isSingleValue, isCollective, isNoUserModification, attributeUsage, extraProperties, definition);
            this.addAttributeType(attrType, overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_ATTRTYPE_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addAttributeType(String oid, List<String> names, String description, boolean obsolete, String superiorType, String equalityMatchingRule, String orderingMatchingRule, String substringMatchingRule, String approximateMatchingRule, String syntax, boolean singleValue, boolean collective, boolean noUserModification, AttributeUsage attributeUsage, Map<String, List<String>> extraProperties, boolean overwrite) {
        this.lazyInitBuilder();
        AttributeType attrType = new AttributeType(oid, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, superiorType, equalityMatchingRule, orderingMatchingRule, substringMatchingRule, approximateMatchingRule, syntax, singleValue, collective, noUserModification, attributeUsage, SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null);
        this.addAttributeType(attrType, overwrite);
        return this;
    }

    public SchemaBuilder addDITContentRule(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String structuralClass = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            Set<String> auxiliaryClasses = Collections.emptySet();
            Set<String> optionalAttributes = Collections.emptySet();
            Set<String> prohibitedAttributes = Collections.emptySet();
            Set<String> requiredAttributes = Collections.emptySet();
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("aux")) {
                    auxiliaryClasses = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("must")) {
                    requiredAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("may")) {
                    optionalAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("not")) {
                    prohibitedAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DCR_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            DITContentRule rule = new DITContentRule(structuralClass, names, description, isObsolete, auxiliaryClasses, optionalAttributes, prohibitedAttributes, requiredAttributes, extraProperties, definition);
            this.addDITContentRule(rule, overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DCR_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addDITContentRule(String structuralClass, List<String> names, String description, boolean obsolete, Set<String> auxiliaryClasses, Set<String> optionalAttributes, Set<String> prohibitedAttributes, Set<String> requiredAttributes, Map<String, List<String>> extraProperties, boolean overwrite) {
        this.lazyInitBuilder();
        DITContentRule rule = new DITContentRule(structuralClass, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, SchemaUtils.unmodifiableCopyOfSet(auxiliaryClasses), SchemaUtils.unmodifiableCopyOfSet(optionalAttributes), SchemaUtils.unmodifiableCopyOfSet(prohibitedAttributes), SchemaUtils.unmodifiableCopyOfSet(requiredAttributes), SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null);
        this.addDITContentRule(rule, overwrite);
        return this;
    }

    SchemaBuilder addDITStructureRule(Integer ruleID, List<String> names, String description, boolean obsolete, String nameForm, Set<Integer> superiorRules, Map<String, List<String>> extraProperties, boolean overwrite) {
        this.lazyInitBuilder();
        DITStructureRule rule = new DITStructureRule(ruleID, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, nameForm, SchemaUtils.unmodifiableCopyOfSet(superiorRules), SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null);
        this.addDITStructureRule(rule, overwrite);
        return this;
    }

    public SchemaBuilder addDITStructureRule(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            Integer ruleID = SchemaUtils.readRuleID(reader);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            String nameForm = null;
            Set<Integer> superiorRules = Collections.emptySet();
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("form")) {
                    nameForm = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("sup")) {
                    superiorRules = SchemaUtils.readRuleIDs(reader);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (nameForm == null) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_DSR_NO_NAME_FORM.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            DITStructureRule rule = new DITStructureRule(ruleID, names, description, isObsolete, nameForm, superiorRules, extraProperties, definition);
            this.addDITStructureRule(rule, overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_DSR_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    public SchemaBuilder addEnumerationSyntax(String oid, String description, boolean overwrite, String ... enumerations) {
        Validator.ensureNotNull(enumerations);
        this.lazyInitBuilder();
        EnumSyntaxImpl enumImpl = new EnumSyntaxImpl(oid, Arrays.asList(enumerations));
        Syntax enumSyntax = new Syntax(oid, description, Collections.singletonMap("X-ENUM", Arrays.asList(enumerations)), null, enumImpl);
        MatchingRule enumOMR = new MatchingRule(enumImpl.getOrderingMatchingRule(), Collections.singletonList("enumOrderingMatch" + oid), "", false, oid, CoreSchemaImpl.OPENDS_ORIGIN, null, new EnumOrderingMatchingRule(enumImpl));
        this.addSyntax(enumSyntax, overwrite);
        try {
            this.addMatchingRule(enumOMR, overwrite);
        }
        catch (ConflictingSchemaElementException e) {
            this.removeSyntax(oid);
        }
        return this;
    }

    public SchemaBuilder addMatchingRule(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            String syntax = null;
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("syntax")) {
                    syntax = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (syntax == null) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MR_NO_SYNTAX.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            this.addMatchingRule(new MatchingRule(oid, names, description, isObsolete, syntax, extraProperties, definition, null), overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_MR_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addMatchingRule(String oid, List<String> names, String description, boolean obsolete, String assertionSyntax, Map<String, List<String>> extraProperties, MatchingRuleImpl implementation, boolean overwrite) {
        Validator.ensureNotNull(implementation);
        this.lazyInitBuilder();
        MatchingRule matchingRule = new MatchingRule(oid, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, assertionSyntax, SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null, implementation);
        this.addMatchingRule(matchingRule, overwrite);
        return this;
    }

    public SchemaBuilder addMatchingRuleUse(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            Set<String> attributes = null;
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("applies")) {
                    attributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (attributes == null || attributes.size() == 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_NO_ATTR.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            MatchingRuleUse use = new MatchingRuleUse(oid, names, description, isObsolete, attributes, extraProperties, definition);
            this.addMatchingRuleUse(use, overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addMatchingRuleUse(String oid, List<String> names, String description, boolean obsolete, Set<String> attributeOIDs, Map<String, List<String>> extraProperties, boolean overwrite) {
        this.lazyInitBuilder();
        MatchingRuleUse use = new MatchingRuleUse(oid, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, SchemaUtils.unmodifiableCopyOfSet(attributeOIDs), SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null);
        this.addMatchingRuleUse(use, overwrite);
        return this;
    }

    public SchemaBuilder addNameForm(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            LocalizableMessage message;
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message2 = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message2);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message3 = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)Character.valueOf(c));
                throw new LocalizedIllegalArgumentException(message3);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            String structuralClass = null;
            Set<String> optionalAttributes = Collections.emptySet();
            Set<String> requiredAttributes = null;
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("oc")) {
                    structuralClass = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("must")) {
                    requiredAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("may")) {
                    optionalAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message4 = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message4);
            }
            if (structuralClass == null) {
                message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_STRUCTURAL_CLASS1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (requiredAttributes == null || requiredAttributes.size() == 0) {
                message = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_NO_REQUIRED_ATTR.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            NameForm nameForm = new NameForm(oid, names, description, isObsolete, structuralClass, requiredAttributes, optionalAttributes, extraProperties, definition);
            this.addNameForm(nameForm, overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_NAME_FORM_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addNameForm(String oid, List<String> names, String description, boolean obsolete, String structuralClass, Set<String> requiredAttributes, Set<String> optionalAttributes, Map<String, List<String>> extraProperties, boolean overwrite) {
        this.lazyInitBuilder();
        NameForm nameForm = new NameForm(oid, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, structuralClass, SchemaUtils.unmodifiableCopyOfSet(requiredAttributes), SchemaUtils.unmodifiableCopyOfSet(optionalAttributes), SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null);
        this.addNameForm(nameForm, overwrite);
        return this;
    }

    public SchemaBuilder addObjectClass(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_EXPECTED_OPEN_PARENTHESIS1.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            List<String> names = Collections.emptyList();
            String description = "".intern();
            boolean isObsolete = false;
            Set<Object> superiorClasses = Collections.emptySet();
            Set<String> requiredAttributes = Collections.emptySet();
            Set<String> optionalAttributes = Collections.emptySet();
            ObjectClassType objectClassType = ObjectClassType.STRUCTURAL;
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("name")) {
                    names = SchemaUtils.readNameDescriptors(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("obsolete")) {
                    isObsolete = true;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("sup")) {
                    superiorClasses = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("abstract")) {
                    objectClassType = ObjectClassType.ABSTRACT;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("structural")) {
                    objectClassType = ObjectClassType.STRUCTURAL;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("auxiliary")) {
                    objectClassType = ObjectClassType.AUXILIARY;
                    continue;
                }
                if (tokenName.equalsIgnoreCase("must")) {
                    requiredAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.equalsIgnoreCase("may")) {
                    optionalAttributes = SchemaUtils.readOIDs(reader, this.allowMalformedNamesAndOptions);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap<String, List<String>>();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (oid.equals("1.3.6.1.4.1.1466.101.120.111")) {
                this.addObjectClass(new ObjectClass(description, extraProperties), overwrite);
            } else {
                if (objectClassType == ObjectClassType.STRUCTURAL && superiorClasses.isEmpty()) {
                    superiorClasses = Collections.singleton("top");
                }
                if (!extraProperties.isEmpty()) {
                    extraProperties = Collections.unmodifiableMap(extraProperties);
                }
                this.addObjectClass(new ObjectClass(oid, names, description, isObsolete, superiorClasses, requiredAttributes, optionalAttributes, objectClassType, extraProperties, definition), overwrite);
            }
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_OBJECTCLASS_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addObjectClass(String oid, List<String> names, String description, boolean obsolete, Set<String> superiorClassOIDs, Set<String> requiredAttributeOIDs, Set<String> optionalAttributeOIDs, ObjectClassType objectClassType, Map<String, List<String>> extraProperties, boolean overwrite) {
        this.lazyInitBuilder();
        if (oid.equals("1.3.6.1.4.1.1466.101.120.111")) {
            this.addObjectClass(new ObjectClass(description, SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties)), overwrite);
        } else {
            if (objectClassType == ObjectClassType.STRUCTURAL && superiorClassOIDs.isEmpty()) {
                superiorClassOIDs = Collections.singleton("top");
            }
            this.addObjectClass(new ObjectClass(oid, SchemaUtils.unmodifiableCopyOfList(names), description, obsolete, SchemaUtils.unmodifiableCopyOfSet(superiorClassOIDs), SchemaUtils.unmodifiableCopyOfSet(requiredAttributeOIDs), SchemaUtils.unmodifiableCopyOfSet(optionalAttributeOIDs), objectClassType, SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null), overwrite);
        }
        return this;
    }

    public SchemaBuilder addPatternSyntax(String oid, String description, Pattern pattern, boolean overwrite) {
        Validator.ensureNotNull(pattern);
        this.lazyInitBuilder();
        this.addSyntax(new Syntax(oid, description, Collections.singletonMap("X-PATTERN", Collections.singletonList(pattern.toString())), null, null), overwrite);
        return this;
    }

    public SchemaBuilder addSchema(Connection connection, DN name, boolean overwrite) throws ErrorResultException {
        SearchRequest request = SchemaBuilder.getReadSchemaSearchRequest(name);
        SearchResultEntry entry = connection.searchSingleEntry(request);
        return this.addSchema(entry, overwrite);
    }

    public SchemaBuilder addSchema(Entry entry, boolean overwrite) {
        Validator.ensureNotNull(entry);
        this.lazyInitBuilder();
        Attribute attr = entry.getAttribute("ldapSyntaxes");
        if (attr != null) {
            for (ByteString def : attr) {
                try {
                    this.addSyntax(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("attributeTypes")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addAttributeType(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("objectClasses")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addObjectClass(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("matchingRuleUse")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addMatchingRuleUse(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("matchingRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addMatchingRule(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("dITContentRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addDITContentRule(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("dITStructureRules")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addDITStructureRule(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        if ((attr = entry.getAttribute("nameForms")) != null) {
            for (ByteString def : attr) {
                try {
                    this.addNameForm(def.toString(), overwrite);
                }
                catch (LocalizedIllegalArgumentException e) {
                    this.warnings.add(e.getMessageObject());
                }
            }
        }
        return this;
    }

    public SchemaBuilder addSchema(Schema schema, boolean overwrite) {
        Validator.ensureNotNull(schema);
        this.lazyInitBuilder();
        this.addSchema0(schema, overwrite);
        return this;
    }

    public FutureResult<SchemaBuilder> addSchemaAsync(Connection connection, DN name, ResultHandler<? super SchemaBuilder> handler, final boolean overwrite) {
        SearchRequest request = SchemaBuilder.getReadSchemaSearchRequest(name);
        FutureResultTransformer<SearchResultEntry, SchemaBuilder> future = new FutureResultTransformer<SearchResultEntry, SchemaBuilder>(handler){

            @Override
            protected SchemaBuilder transformResult(SearchResultEntry result) throws ErrorResultException {
                SchemaBuilder.this.addSchema(result, overwrite);
                return SchemaBuilder.this;
            }
        };
        FutureResult<SearchResultEntry> innerFuture = connection.searchSingleEntryAsync(request, (ResultHandler<? super SearchResultEntry>)future);
        future.setFutureResult(innerFuture);
        return future;
    }

    public SchemaBuilder addSchemaForEntry(Connection connection, DN name, boolean overwrite) throws ErrorResultException {
        SearchRequest request = SchemaBuilder.getReadSchemaForEntrySearchRequest(name);
        SearchResultEntry entry = connection.searchSingleEntry(request);
        DN subschemaDN = SchemaBuilder.getSubschemaSubentryDN(name, entry);
        return this.addSchema(connection, subschemaDN, overwrite);
    }

    public FutureResult<SchemaBuilder> addSchemaForEntryAsync(final Connection connection, final DN name, ResultHandler<? super SchemaBuilder> handler, final boolean overwrite) {
        RecursiveFutureResult<SearchResultEntry, SchemaBuilder> future = new RecursiveFutureResult<SearchResultEntry, SchemaBuilder>(handler){

            @Override
            protected FutureResult<SchemaBuilder> chainResult(SearchResultEntry innerResult, ResultHandler<? super SchemaBuilder> handler) throws ErrorResultException {
                DN subschemaDN = SchemaBuilder.getSubschemaSubentryDN(name, innerResult);
                return SchemaBuilder.this.addSchemaAsync(connection, subschemaDN, handler, overwrite);
            }
        };
        SearchRequest request = SchemaBuilder.getReadSchemaForEntrySearchRequest(name);
        FutureResult<SearchResultEntry> innerFuture = connection.searchSingleEntryAsync(request, (ResultHandler<? super SearchResultEntry>)future);
        future.setFutureResult(innerFuture);
        return future;
    }

    public SchemaBuilder addSubstitutionSyntax(String oid, String description, String substituteSyntax, boolean overwrite) {
        Validator.ensureNotNull(substituteSyntax);
        this.lazyInitBuilder();
        this.addSyntax(new Syntax(oid, description, Collections.singletonMap("X-SUBST", Collections.singletonList(substituteSyntax)), null, null), overwrite);
        return this;
    }

    public SchemaBuilder addSyntax(String definition, boolean overwrite) {
        Validator.ensureNotNull(definition);
        this.lazyInitBuilder();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE1.get((Object)definition);
                throw new LocalizedIllegalArgumentException(message);
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                throw new LocalizedIllegalArgumentException(message);
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, this.allowMalformedNamesAndOptions);
            String description = "".intern();
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("desc")) {
                    description = SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                throw new LocalizedIllegalArgumentException(message);
            }
            if (!extraProperties.isEmpty()) {
                extraProperties = Collections.unmodifiableMap(extraProperties);
            }
            for (Map.Entry property : extraProperties.entrySet()) {
                if (!((String)property.getKey()).equalsIgnoreCase("x-enum")) continue;
                EnumSyntaxImpl enumImpl = new EnumSyntaxImpl(oid, (List)property.getValue());
                Syntax enumSyntax = new Syntax(oid, description, extraProperties, definition, enumImpl);
                MatchingRule enumOMR = new MatchingRule(enumImpl.getOrderingMatchingRule(), Collections.singletonList("enumOrderingMatch" + oid), "", false, oid, CoreSchemaImpl.OPENDS_ORIGIN, null, new EnumOrderingMatchingRule(enumImpl));
                this.addSyntax(enumSyntax, overwrite);
                this.addMatchingRule(enumOMR, overwrite);
                return this;
            }
            this.addSyntax(new Syntax(oid, description, extraProperties, definition, null), overwrite);
        }
        catch (DecodeException e) {
            LocalizableMessage msg = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID1.get((Object)definition, (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(msg, e.getCause());
        }
        return this;
    }

    SchemaBuilder addSyntax(String oid, String description, Map<String, List<String>> extraProperties, SyntaxImpl implementation, boolean overwrite) {
        this.lazyInitBuilder();
        this.addSyntax(new Syntax(oid, description, SchemaUtils.unmodifiableCopyOfExtraProperties(extraProperties), null, implementation), overwrite);
        return this;
    }

    public SchemaBuilder allowMalformedNamesAndOptions(boolean allowMalformedNamesAndOptions) {
        this.lazyInitBuilder();
        this.allowMalformedNamesAndOptions = allowMalformedNamesAndOptions;
        return this;
    }

    public SchemaBuilder allowMalformedJPEGPhotos(boolean allowMalformedJPEGPhotos) {
        this.lazyInitBuilder();
        this.allowMalformedJPEGPhotos = allowMalformedJPEGPhotos;
        return this;
    }

    public SchemaBuilder allowNonStandardTelephoneNumbers(boolean allowNonStandardTelephoneNumbers) {
        this.lazyInitBuilder();
        this.allowNonStandardTelephoneNumbers = allowNonStandardTelephoneNumbers;
        return this;
    }

    public SchemaBuilder allowZeroLengthDirectoryStrings(boolean allowZeroLengthDirectoryStrings) {
        this.lazyInitBuilder();
        this.allowZeroLengthDirectoryStrings = allowZeroLengthDirectoryStrings;
        return this;
    }

    public SchemaBuilder defaultSyntax(Syntax syntax) {
        return this.defaultSyntax(syntax.getOID());
    }

    public SchemaBuilder defaultMatchingRule(MatchingRule rule) {
        return this.defaultMatchingRule(rule.getOID());
    }

    public SchemaBuilder defaultSyntax(String syntaxOID) {
        this.lazyInitBuilder();
        this.defaultSyntaxOID = syntaxOID;
        return this;
    }

    public SchemaBuilder defaultMatchingRule(String ruleOID) {
        this.lazyInitBuilder();
        this.defaultMatchingRuleOID = ruleOID;
        return this;
    }

    public boolean removeAttributeType(String name) {
        this.lazyInitBuilder();
        AttributeType element = this.numericOID2AttributeTypes.get(name);
        if (element != null) {
            this.removeAttributeType(element);
            return true;
        }
        List<AttributeType> elements = this.name2AttributeTypes.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (AttributeType e : elements) {
                this.removeAttributeType(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeDITContentRule(String name) {
        this.lazyInitBuilder();
        DITContentRule element = this.numericOID2ContentRules.get(name);
        if (element != null) {
            this.removeDITContentRule(element);
            return true;
        }
        List<DITContentRule> elements = this.name2ContentRules.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (DITContentRule e : elements) {
                this.removeDITContentRule(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeDITStructureRule(int ruleID) {
        this.lazyInitBuilder();
        DITStructureRule element = this.id2StructureRules.get(ruleID);
        if (element != null) {
            this.removeDITStructureRule(element);
            return true;
        }
        return false;
    }

    public boolean removeMatchingRule(String name) {
        this.lazyInitBuilder();
        MatchingRule element = this.numericOID2MatchingRules.get(name);
        if (element != null) {
            this.removeMatchingRule(element);
            return true;
        }
        List<MatchingRule> elements = this.name2MatchingRules.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (MatchingRule e : elements) {
                this.removeMatchingRule(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeMatchingRuleUse(String name) {
        this.lazyInitBuilder();
        MatchingRuleUse element = this.numericOID2MatchingRuleUses.get(name);
        if (element != null) {
            this.removeMatchingRuleUse(element);
            return true;
        }
        List<MatchingRuleUse> elements = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (MatchingRuleUse e : elements) {
                this.removeMatchingRuleUse(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeNameForm(String name) {
        this.lazyInitBuilder();
        NameForm element = this.numericOID2NameForms.get(name);
        if (element != null) {
            this.removeNameForm(element);
            return true;
        }
        List<NameForm> elements = this.name2NameForms.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (NameForm e : elements) {
                this.removeNameForm(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeObjectClass(String name) {
        this.lazyInitBuilder();
        ObjectClass element = this.numericOID2ObjectClasses.get(name);
        if (element != null) {
            this.removeObjectClass(element);
            return true;
        }
        List<ObjectClass> elements = this.name2ObjectClasses.get(StaticUtils.toLowerCase(name));
        if (elements != null) {
            for (ObjectClass e : elements) {
                this.removeObjectClass(e);
            }
            return true;
        }
        return false;
    }

    public boolean removeSyntax(String numericOID) {
        this.lazyInitBuilder();
        Syntax element = this.numericOID2Syntaxes.get(numericOID);
        if (element != null) {
            this.removeSyntax(element);
            return true;
        }
        return false;
    }

    public Schema toSchema() {
        MatchingRule defaultMatchingRule;
        if (this.copyOnWriteSchema != null) {
            return this.copyOnWriteSchema;
        }
        this.lazyInitBuilder();
        String localSchemaName = this.schemaName != null ? this.schemaName : String.format("Schema#%d", NEXT_SCHEMA_ID.getAndIncrement());
        Syntax defaultSyntax = this.numericOID2Syntaxes.get(this.defaultSyntaxOID);
        if (defaultSyntax == null) {
            defaultSyntax = Schema.getCoreSchema().getDefaultSyntax();
        }
        if ((defaultMatchingRule = this.numericOID2MatchingRules.get(this.defaultMatchingRuleOID)) == null) {
            defaultMatchingRule = Schema.getCoreSchema().getDefaultMatchingRule();
        }
        Schema schema = new Schema(localSchemaName, this.allowMalformedNamesAndOptions, this.allowMalformedJPEGPhotos, this.allowNonStandardTelephoneNumbers, this.allowZeroLengthDirectoryStrings, defaultSyntax, defaultMatchingRule, this.numericOID2Syntaxes, this.numericOID2MatchingRules, this.numericOID2MatchingRuleUses, this.numericOID2AttributeTypes, this.numericOID2ObjectClasses, this.numericOID2NameForms, this.numericOID2ContentRules, this.id2StructureRules, this.name2MatchingRules, this.name2MatchingRuleUses, this.name2AttributeTypes, this.name2ObjectClasses, this.name2NameForms, this.name2ContentRules, this.name2StructureRules, this.objectClass2NameForms, this.nameForm2StructureRules, this.warnings);
        this.validate(schema);
        this.preLazyInitBuilder(this.schemaName, schema);
        return schema;
    }

    private void addAttributeType(AttributeType attribute, boolean overwrite) {
        if (this.numericOID2AttributeTypes.containsKey(attribute.getOID())) {
            AttributeType conflictingAttribute = this.numericOID2AttributeTypes.get(attribute.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_ATTRIBUTE_OID.get((Object)attribute.getNameOrOID(), (Object)attribute.getOID(), (Object)conflictingAttribute.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeAttributeType(conflictingAttribute);
        }
        this.numericOID2AttributeTypes.put(attribute.getOID(), attribute);
        for (String name : attribute.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<AttributeType> attrs = this.name2AttributeTypes.get(lowerName);
            if (attrs == null) {
                this.name2AttributeTypes.put(lowerName, Collections.singletonList(attribute));
                continue;
            }
            if (attrs.size() == 1) {
                attrs = new ArrayList<AttributeType>(attrs);
                attrs.add(attribute);
                this.name2AttributeTypes.put(lowerName, attrs);
                continue;
            }
            attrs.add(attribute);
        }
    }

    private void addDITContentRule(DITContentRule rule, boolean overwrite) {
        if (this.numericOID2ContentRules.containsKey(rule.getStructuralClassOID())) {
            DITContentRule conflictingRule = this.numericOID2ContentRules.get(rule.getStructuralClassOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_CONTENT_RULE1.get((Object)rule.getNameOrOID(), (Object)rule.getStructuralClassOID(), (Object)conflictingRule.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeDITContentRule(conflictingRule);
        }
        this.numericOID2ContentRules.put(rule.getStructuralClassOID(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITContentRule> rules = this.name2ContentRules.get(lowerName);
            if (rules == null) {
                this.name2ContentRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DITContentRule>(rules);
                rules.add(rule);
                this.name2ContentRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
    }

    private void addDITStructureRule(DITStructureRule rule, boolean overwrite) {
        if (this.id2StructureRules.containsKey(rule.getRuleID())) {
            DITStructureRule conflictingRule = this.id2StructureRules.get(rule.getRuleID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_DIT_STRUCTURE_RULE_ID.get((Object)rule.getNameOrRuleID(), (Object)rule.getRuleID(), (Object)conflictingRule.getNameOrRuleID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeDITStructureRule(conflictingRule);
        }
        this.id2StructureRules.put(rule.getRuleID(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITStructureRule> rules = this.name2StructureRules.get(lowerName);
            if (rules == null) {
                this.name2StructureRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<DITStructureRule>(rules);
                rules.add(rule);
                this.name2StructureRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
    }

    private void addMatchingRule(MatchingRule rule, boolean overwrite) {
        if (this.numericOID2MatchingRules.containsKey(rule.getOID())) {
            MatchingRule conflictingRule = this.numericOID2MatchingRules.get(rule.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_MR_OID.get((Object)rule.getNameOrOID(), (Object)rule.getOID(), (Object)conflictingRule.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeMatchingRule(conflictingRule);
        }
        this.numericOID2MatchingRules.put(rule.getOID(), rule);
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRule> rules = this.name2MatchingRules.get(lowerName);
            if (rules == null) {
                this.name2MatchingRules.put(lowerName, Collections.singletonList(rule));
                continue;
            }
            if (rules.size() == 1) {
                rules = new ArrayList<MatchingRule>(rules);
                rules.add(rule);
                this.name2MatchingRules.put(lowerName, rules);
                continue;
            }
            rules.add(rule);
        }
    }

    private void addMatchingRuleUse(MatchingRuleUse use, boolean overwrite) {
        if (this.numericOID2MatchingRuleUses.containsKey(use.getMatchingRuleOID())) {
            MatchingRuleUse conflictingUse = this.numericOID2MatchingRuleUses.get(use.getMatchingRuleOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_MATCHING_RULE_USE.get((Object)use.getNameOrOID(), (Object)use.getMatchingRuleOID(), (Object)conflictingUse.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeMatchingRuleUse(conflictingUse);
        }
        this.numericOID2MatchingRuleUses.put(use.getMatchingRuleOID(), use);
        for (String name : use.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(lowerName);
            if (uses == null) {
                this.name2MatchingRuleUses.put(lowerName, Collections.singletonList(use));
                continue;
            }
            if (uses.size() == 1) {
                uses = new ArrayList<MatchingRuleUse>(uses);
                uses.add(use);
                this.name2MatchingRuleUses.put(lowerName, uses);
                continue;
            }
            uses.add(use);
        }
    }

    private void addNameForm(NameForm form, boolean overwrite) {
        if (this.numericOID2NameForms.containsKey(form.getOID())) {
            NameForm conflictingForm = this.numericOID2NameForms.get(form.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_NAME_FORM_OID.get((Object)form.getNameOrOID(), (Object)form.getOID(), (Object)conflictingForm.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeNameForm(conflictingForm);
        }
        this.numericOID2NameForms.put(form.getOID(), form);
        for (String name : form.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<NameForm> forms = this.name2NameForms.get(lowerName);
            if (forms == null) {
                this.name2NameForms.put(lowerName, Collections.singletonList(form));
                continue;
            }
            if (forms.size() == 1) {
                forms = new ArrayList<NameForm>(forms);
                forms.add(form);
                this.name2NameForms.put(lowerName, forms);
                continue;
            }
            forms.add(form);
        }
    }

    private void addObjectClass(ObjectClass oc, boolean overwrite) {
        if (this.numericOID2ObjectClasses.containsKey(oc.getOID())) {
            ObjectClass conflictingOC = this.numericOID2ObjectClasses.get(oc.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_OBJECTCLASS_OID1.get((Object)oc.getNameOrOID(), (Object)oc.getOID(), (Object)conflictingOC.getNameOrOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeObjectClass(conflictingOC);
        }
        this.numericOID2ObjectClasses.put(oc.getOID(), oc);
        for (String name : oc.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<ObjectClass> classes = this.name2ObjectClasses.get(lowerName);
            if (classes == null) {
                this.name2ObjectClasses.put(lowerName, Collections.singletonList(oc));
                continue;
            }
            if (classes.size() == 1) {
                classes = new ArrayList<ObjectClass>(classes);
                classes.add(oc);
                this.name2ObjectClasses.put(lowerName, classes);
                continue;
            }
            classes.add(oc);
        }
    }

    private void addSchema0(Schema schema, boolean overwrite) {
        for (Syntax syntax : schema.getSyntaxes()) {
            this.addSyntax(syntax.duplicate(), overwrite);
        }
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            this.addMatchingRule(matchingRule.duplicate(), overwrite);
        }
        for (MatchingRuleUse matchingRuleUse : schema.getMatchingRuleUses()) {
            this.addMatchingRuleUse(matchingRuleUse.duplicate(), overwrite);
        }
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            this.addAttributeType(attributeType.duplicate(), overwrite);
        }
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            this.addObjectClass(objectClass.duplicate(), overwrite);
        }
        for (NameForm nameForm : schema.getNameForms()) {
            this.addNameForm(nameForm.duplicate(), overwrite);
        }
        for (DITContentRule contentRule : schema.getDITContentRules()) {
            this.addDITContentRule(contentRule.duplicate(), overwrite);
        }
        for (DITStructureRule structureRule : schema.getDITStuctureRules()) {
            this.addDITStructureRule(structureRule.duplicate(), overwrite);
        }
    }

    private void addSyntax(Syntax syntax, boolean overwrite) {
        if (this.numericOID2Syntaxes.containsKey(syntax.getOID())) {
            Syntax conflictingSyntax = this.numericOID2Syntaxes.get(syntax.getOID());
            if (!overwrite) {
                LocalizableMessage message = CoreMessages.ERR_SCHEMA_CONFLICTING_SYNTAX_OID.get((Object)syntax.toString(), (Object)syntax.getOID(), (Object)conflictingSyntax.getOID());
                throw new ConflictingSchemaElementException(message);
            }
            this.removeSyntax(conflictingSyntax);
        }
        this.numericOID2Syntaxes.put(syntax.getOID(), syntax);
    }

    private void lazyInitBuilder() {
        if (this.numericOID2Syntaxes == null) {
            this.allowMalformedNamesAndOptions = true;
            this.allowMalformedJPEGPhotos = true;
            this.allowNonStandardTelephoneNumbers = true;
            this.allowZeroLengthDirectoryStrings = false;
            this.defaultSyntaxOID = "1.3.6.1.4.1.1466.115.121.1.40";
            this.defaultMatchingRuleOID = "2.5.13.17";
            this.numericOID2Syntaxes = new LinkedHashMap<String, Syntax>();
            this.numericOID2MatchingRules = new LinkedHashMap<String, MatchingRule>();
            this.numericOID2MatchingRuleUses = new LinkedHashMap<String, MatchingRuleUse>();
            this.numericOID2AttributeTypes = new LinkedHashMap<String, AttributeType>();
            this.numericOID2ObjectClasses = new LinkedHashMap<String, ObjectClass>();
            this.numericOID2NameForms = new LinkedHashMap<String, NameForm>();
            this.numericOID2ContentRules = new LinkedHashMap<String, DITContentRule>();
            this.id2StructureRules = new LinkedHashMap<Integer, DITStructureRule>();
            this.name2MatchingRules = new LinkedHashMap<String, List<MatchingRule>>();
            this.name2MatchingRuleUses = new LinkedHashMap<String, List<MatchingRuleUse>>();
            this.name2AttributeTypes = new LinkedHashMap<String, List<AttributeType>>();
            this.name2ObjectClasses = new LinkedHashMap<String, List<ObjectClass>>();
            this.name2NameForms = new LinkedHashMap<String, List<NameForm>>();
            this.name2ContentRules = new LinkedHashMap<String, List<DITContentRule>>();
            this.name2StructureRules = new LinkedHashMap<String, List<DITStructureRule>>();
            this.objectClass2NameForms = new HashMap<String, List<NameForm>>();
            this.nameForm2StructureRules = new HashMap<String, List<DITStructureRule>>();
            this.warnings = new LinkedList<LocalizableMessage>();
        }
        if (this.copyOnWriteSchema != null) {
            this.addSchema0(this.copyOnWriteSchema, true);
            this.allowMalformedNamesAndOptions = this.copyOnWriteSchema.allowMalformedNamesAndOptions();
            this.allowMalformedJPEGPhotos = this.copyOnWriteSchema.allowMalformedJPEGPhotos();
            this.allowNonStandardTelephoneNumbers = this.copyOnWriteSchema.allowNonStandardTelephoneNumbers();
            this.allowZeroLengthDirectoryStrings = this.copyOnWriteSchema.allowZeroLengthDirectoryStrings();
            this.defaultSyntaxOID = this.copyOnWriteSchema.getDefaultSyntax().getOID();
            this.defaultMatchingRuleOID = this.copyOnWriteSchema.getDefaultMatchingRule().getOID();
            this.copyOnWriteSchema = null;
        }
    }

    private void preLazyInitBuilder(String schemaName, Schema copyOnWriteSchema) {
        this.schemaName = schemaName;
        this.copyOnWriteSchema = copyOnWriteSchema;
        this.allowMalformedNamesAndOptions = true;
        this.allowMalformedJPEGPhotos = true;
        this.allowNonStandardTelephoneNumbers = true;
        this.allowZeroLengthDirectoryStrings = false;
        this.defaultSyntaxOID = null;
        this.defaultMatchingRuleOID = null;
        this.numericOID2Syntaxes = null;
        this.numericOID2MatchingRules = null;
        this.numericOID2MatchingRuleUses = null;
        this.numericOID2AttributeTypes = null;
        this.numericOID2ObjectClasses = null;
        this.numericOID2NameForms = null;
        this.numericOID2ContentRules = null;
        this.id2StructureRules = null;
        this.name2MatchingRules = null;
        this.name2MatchingRuleUses = null;
        this.name2AttributeTypes = null;
        this.name2ObjectClasses = null;
        this.name2NameForms = null;
        this.name2ContentRules = null;
        this.name2StructureRules = null;
        this.objectClass2NameForms = null;
        this.nameForm2StructureRules = null;
        this.warnings = null;
    }

    private void removeAttributeType(AttributeType attributeType) {
        this.numericOID2AttributeTypes.remove(attributeType.getOID());
        for (String name : attributeType.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<AttributeType> attributes = this.name2AttributeTypes.get(lowerName);
            if (attributes == null || !attributes.contains(attributeType)) continue;
            if (attributes.size() <= 1) {
                this.name2AttributeTypes.remove(lowerName);
                continue;
            }
            attributes.remove(attributeType);
        }
    }

    private void removeDITContentRule(DITContentRule rule) {
        this.numericOID2ContentRules.remove(rule.getStructuralClassOID());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITContentRule> rules = this.name2ContentRules.get(lowerName);
            if (rules == null || !rules.contains(rule)) continue;
            if (rules.size() <= 1) {
                this.name2ContentRules.remove(lowerName);
                continue;
            }
            rules.remove(rule);
        }
    }

    private void removeDITStructureRule(DITStructureRule rule) {
        this.id2StructureRules.remove(rule.getRuleID());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<DITStructureRule> rules = this.name2StructureRules.get(lowerName);
            if (rules == null || !rules.contains(rule)) continue;
            if (rules.size() <= 1) {
                this.name2StructureRules.remove(lowerName);
                continue;
            }
            rules.remove(rule);
        }
    }

    private void removeMatchingRule(MatchingRule rule) {
        this.numericOID2MatchingRules.remove(rule.getOID());
        for (String name : rule.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRule> rules = this.name2MatchingRules.get(lowerName);
            if (rules == null || !rules.contains(rule)) continue;
            if (rules.size() <= 1) {
                this.name2MatchingRules.remove(lowerName);
                continue;
            }
            rules.remove(rule);
        }
    }

    private void removeMatchingRuleUse(MatchingRuleUse use) {
        this.numericOID2MatchingRuleUses.remove(use.getMatchingRuleOID());
        for (String name : use.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(lowerName);
            if (uses == null || !uses.contains(use)) continue;
            if (uses.size() <= 1) {
                this.name2MatchingRuleUses.remove(lowerName);
                continue;
            }
            uses.remove(use);
        }
    }

    private void removeNameForm(NameForm form) {
        this.numericOID2NameForms.remove(form.getOID());
        this.name2NameForms.remove(form.getOID());
        for (String name : form.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<NameForm> forms = this.name2NameForms.get(lowerName);
            if (forms == null || !forms.contains(form)) continue;
            if (forms.size() <= 1) {
                this.name2NameForms.remove(lowerName);
                continue;
            }
            forms.remove(form);
        }
    }

    private void removeObjectClass(ObjectClass oc) {
        this.numericOID2ObjectClasses.remove(oc.getOID());
        this.name2ObjectClasses.remove(oc.getOID());
        for (String name : oc.getNames()) {
            String lowerName = StaticUtils.toLowerCase(name);
            List<ObjectClass> classes = this.name2ObjectClasses.get(lowerName);
            if (classes == null || !classes.contains(oc)) continue;
            if (classes.size() <= 1) {
                this.name2ObjectClasses.remove(lowerName);
                continue;
            }
            classes.remove(oc);
        }
    }

    private void removeSyntax(Syntax syntax) {
        this.numericOID2Syntaxes.remove(syntax.getOID());
    }

    private void validate(Schema schema) {
        for (Syntax syntax : this.numericOID2Syntaxes.values().toArray(new Syntax[this.numericOID2Syntaxes.values().size()])) {
            try {
                syntax.validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeSyntax(syntax);
                this.warnings.add(CoreMessages.ERR_SYNTAX_VALIDATION_FAIL.get((Object)syntax.toString(), (Object)e.getMessageObject()));
            }
        }
        for (SchemaElement schemaElement : this.numericOID2MatchingRules.values().toArray(new MatchingRule[this.numericOID2MatchingRules.values().size()])) {
            try {
                ((MatchingRule)schemaElement).validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeMatchingRule((MatchingRule)schemaElement);
                this.warnings.add(CoreMessages.ERR_MR_VALIDATION_FAIL.get((Object)((MatchingRule)schemaElement).toString(), (Object)e.getMessageObject()));
            }
        }
        LinkedList<AttributeType> invalidAttributeTypes = new LinkedList<AttributeType>();
        for (AttributeType attributeType : this.numericOID2AttributeTypes.values()) {
            attributeType.validate(schema, invalidAttributeTypes, this.warnings);
        }
        for (AttributeType attributeType : invalidAttributeTypes) {
            this.removeAttributeType(attributeType);
        }
        LinkedList<ObjectClass> invalidObjectClasses = new LinkedList<ObjectClass>();
        for (ObjectClass objectClass : this.numericOID2ObjectClasses.values()) {
            objectClass.validate(schema, invalidObjectClasses, this.warnings);
        }
        for (ObjectClass objectClass : invalidObjectClasses) {
            this.removeObjectClass(objectClass);
        }
        for (MatchingRuleUse matchingRuleUse : this.numericOID2MatchingRuleUses.values().toArray(new MatchingRuleUse[this.numericOID2MatchingRuleUses.values().size()])) {
            try {
                matchingRuleUse.validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeMatchingRuleUse(matchingRuleUse);
                this.warnings.add(CoreMessages.ERR_MRU_VALIDATION_FAIL.get((Object)matchingRuleUse.toString(), (Object)e.getMessageObject()));
            }
        }
        for (SchemaElement schemaElement : this.numericOID2NameForms.values().toArray(new NameForm[this.numericOID2NameForms.values().size()])) {
            try {
                ((NameForm)schemaElement).validate(schema, this.warnings);
                String ocOID = ((NameForm)schemaElement).getStructuralClass().getOID();
                List<NameForm> forms = this.objectClass2NameForms.get(ocOID);
                if (forms == null) {
                    this.objectClass2NameForms.put(ocOID, Collections.singletonList(schemaElement));
                    continue;
                }
                if (forms.size() == 1) {
                    forms = new ArrayList<NameForm>(forms);
                    forms.add((NameForm)schemaElement);
                    this.objectClass2NameForms.put(ocOID, forms);
                    continue;
                }
                forms.add((NameForm)schemaElement);
            }
            catch (SchemaException e) {
                this.removeNameForm((NameForm)schemaElement);
                this.warnings.add(CoreMessages.ERR_NAMEFORM_VALIDATION_FAIL.get((Object)((NameForm)schemaElement).toString(), (Object)e.getMessageObject()));
            }
        }
        for (SchemaElement schemaElement : this.numericOID2ContentRules.values().toArray(new DITContentRule[this.numericOID2ContentRules.values().size()])) {
            try {
                ((DITContentRule)schemaElement).validate(schema, this.warnings);
            }
            catch (SchemaException e) {
                this.removeDITContentRule((DITContentRule)schemaElement);
                this.warnings.add(CoreMessages.ERR_DCR_VALIDATION_FAIL.get((Object)((DITContentRule)schemaElement).toString(), (Object)e.getMessageObject()));
            }
        }
        LinkedList<DITStructureRule> invalidStructureRules = new LinkedList<DITStructureRule>();
        for (DITStructureRule rule : this.id2StructureRules.values()) {
            rule.validate(schema, invalidStructureRules, this.warnings);
        }
        for (DITStructureRule rule : invalidStructureRules) {
            this.removeDITStructureRule(rule);
        }
        for (DITStructureRule rule : this.id2StructureRules.values()) {
            String ocOID = rule.getNameForm().getOID();
            List<DITStructureRule> list = this.nameForm2StructureRules.get(ocOID);
            if (list == null) {
                this.nameForm2StructureRules.put(ocOID, Collections.singletonList(rule));
                continue;
            }
            if (list.size() == 1) {
                ArrayList<DITStructureRule> arrayList = new ArrayList<DITStructureRule>(list);
                arrayList.add(rule);
                this.nameForm2StructureRules.put(ocOID, arrayList);
                continue;
            }
            list.add(rule);
        }
    }
}

