/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.FutureResultTransformer;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.LinkedAttribute;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.CoreSchemaImpl;
import org.forgerock.opendj.ldap.schema.DITContentRule;
import org.forgerock.opendj.ldap.schema.DITStructureRule;
import org.forgerock.opendj.ldap.schema.DefaultSchema;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.MatchingRuleUse;
import org.forgerock.opendj.ldap.schema.NameForm;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.ObjectClassType;
import org.forgerock.opendj.ldap.schema.SchemaBuilder;
import org.forgerock.opendj.ldap.schema.SchemaValidationPolicy;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class Schema {
    private static final Schema EMPTY_STRICT_SCHEMA = new Schema(new EmptyImpl(true));
    private static final Schema EMPTY_NON_STRICT_SCHEMA = new Schema(new EmptyImpl(false));
    static final String ATTR_ATTRIBUTE_TYPES = "attributeTypes";
    static final String ATTR_DIT_CONTENT_RULES = "dITContentRules";
    static final String ATTR_DIT_STRUCTURE_RULES = "dITStructureRules";
    static final String ATTR_LDAP_SYNTAXES = "ldapSyntaxes";
    static final String ATTR_MATCHING_RULE_USE = "matchingRuleUse";
    static final String ATTR_MATCHING_RULES = "matchingRules";
    static final String ATTR_NAME_FORMS = "nameForms";
    static final String ATTR_OBJECT_CLASSES = "objectClasses";
    private final Impl impl;

    public static Schema getCoreSchema() {
        return CoreSchemaImpl.getInstance();
    }

    public static Schema getDefaultSchema() {
        return DefaultSchema.schema;
    }

    public static Schema getEmptySchema() {
        return EMPTY_NON_STRICT_SCHEMA;
    }

    public static Schema readSchema(Connection connection, DN name) throws ErrorResultException {
        return new SchemaBuilder().addSchema(connection, name, true).toSchema();
    }

    public static FutureResult<Schema> readSchemaAsync(Connection connection, DN name, ResultHandler<? super Schema> handler) {
        FutureResultTransformer<SchemaBuilder, Schema> future = new FutureResultTransformer<SchemaBuilder, Schema>(handler){

            @Override
            protected Schema transformResult(SchemaBuilder builder) throws ErrorResultException {
                return builder.toSchema();
            }
        };
        SchemaBuilder builder = new SchemaBuilder();
        FutureResult<SchemaBuilder> innerFuture = builder.addSchemaAsync(connection, name, (ResultHandler<? super SchemaBuilder>)future, true);
        future.setFutureResult(innerFuture);
        return future;
    }

    public static Schema readSchemaForEntry(Connection connection, DN name) throws ErrorResultException {
        return new SchemaBuilder().addSchemaForEntry(connection, name, true).toSchema();
    }

    public static FutureResult<Schema> readSchemaForEntryAsync(Connection connection, DN name, ResultHandler<? super Schema> handler) {
        FutureResultTransformer<SchemaBuilder, Schema> future = new FutureResultTransformer<SchemaBuilder, Schema>(handler){

            @Override
            protected Schema transformResult(SchemaBuilder builder) throws ErrorResultException {
                return builder.toSchema();
            }
        };
        SchemaBuilder builder = new SchemaBuilder();
        FutureResult<SchemaBuilder> innerFuture = builder.addSchemaForEntryAsync(connection, name, (ResultHandler<? super SchemaBuilder>)future, true);
        future.setFutureResult(innerFuture);
        return future;
    }

    public static void setDefaultSchema(Schema schema) {
        Validator.ensureNotNull(schema);
        DefaultSchema.schema = schema;
    }

    public static Schema valueOf(Entry entry) {
        return new SchemaBuilder(entry).toSchema();
    }

    Schema(String schemaName, boolean allowMalformedNamesAndOptions, boolean allowMalformedJPEGPhotos, boolean allowNonStandardTelephoneNumbers, boolean allowZeroLengthDirectoryStrings, Syntax defaultSyntax, MatchingRule defaultMatchingRule, Map<String, Syntax> numericOID2Syntaxes, Map<String, MatchingRule> numericOID2MatchingRules, Map<String, MatchingRuleUse> numericOID2MatchingRuleUses, Map<String, AttributeType> numericOID2AttributeTypes, Map<String, ObjectClass> numericOID2ObjectClasses, Map<String, NameForm> numericOID2NameForms, Map<String, DITContentRule> numericOID2ContentRules, Map<Integer, DITStructureRule> id2StructureRules, Map<String, List<MatchingRule>> name2MatchingRules, Map<String, List<MatchingRuleUse>> name2MatchingRuleUses, Map<String, List<AttributeType>> name2AttributeTypes, Map<String, List<ObjectClass>> name2ObjectClasses, Map<String, List<NameForm>> name2NameForms, Map<String, List<DITContentRule>> name2ContentRules, Map<String, List<DITStructureRule>> name2StructureRules, Map<String, List<NameForm>> objectClass2NameForms, Map<String, List<DITStructureRule>> nameForm2StructureRules, List<LocalizableMessage> warnings) {
        this.impl = new StrictImpl(schemaName, allowMalformedNamesAndOptions, allowMalformedJPEGPhotos, allowNonStandardTelephoneNumbers, allowZeroLengthDirectoryStrings, defaultSyntax, defaultMatchingRule, numericOID2Syntaxes, numericOID2MatchingRules, numericOID2MatchingRuleUses, numericOID2AttributeTypes, numericOID2ObjectClasses, numericOID2NameForms, numericOID2ContentRules, id2StructureRules, name2MatchingRules, name2MatchingRuleUses, name2AttributeTypes, name2ObjectClasses, name2NameForms, name2ContentRules, name2StructureRules, objectClass2NameForms, nameForm2StructureRules, warnings);
    }

    private Schema(Impl impl) {
        this.impl = impl;
    }

    public boolean allowMalformedNamesAndOptions() {
        return this.impl.allowMalformedNamesAndOptions();
    }

    public boolean allowMalformedJPEGPhotos() {
        return this.impl.allowMalformedJPEGPhotos();
    }

    public boolean allowNonStandardTelephoneNumbers() {
        return this.impl.allowNonStandardTelephoneNumbers();
    }

    public boolean allowZeroLengthDirectoryStrings() {
        return this.impl.allowZeroLengthDirectoryStrings();
    }

    public Schema asNonStrictSchema() {
        if (!this.impl.isStrict()) {
            return this;
        }
        if (this.impl instanceof StrictImpl) {
            return new Schema(new NonStrictImpl((StrictImpl)this.impl));
        }
        return EMPTY_NON_STRICT_SCHEMA;
    }

    public Schema asStrictSchema() {
        if (this.impl.isStrict()) {
            return this;
        }
        if (this.impl instanceof NonStrictImpl) {
            return new Schema(((NonStrictImpl)this.impl).strictImpl);
        }
        return EMPTY_STRICT_SCHEMA;
    }

    public MatchingRule getDefaultMatchingRule() {
        return this.impl.getDefaultMatchingRule();
    }

    public Syntax getDefaultSyntax() {
        return this.impl.getDefaultSyntax();
    }

    public AttributeType getAttributeType(String name) {
        return this.impl.getAttributeType(this, name);
    }

    public Collection<AttributeType> getAttributeTypes() {
        return this.impl.getAttributeTypes();
    }

    public List<AttributeType> getAttributeTypesWithName(String name) {
        return this.impl.getAttributeTypesWithName(name);
    }

    public DITContentRule getDITContentRule(ObjectClass structuralClass) {
        return this.impl.getDITContentRule(structuralClass);
    }

    public DITContentRule getDITContentRule(String name) {
        return this.impl.getDITContentRule(name);
    }

    public Collection<DITContentRule> getDITContentRules() {
        return this.impl.getDITContentRules();
    }

    public Collection<DITContentRule> getDITContentRulesWithName(String name) {
        return this.impl.getDITContentRulesWithName(name);
    }

    public DITStructureRule getDITStructureRule(int ruleID) {
        return this.impl.getDITStructureRule(ruleID);
    }

    public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
        return this.impl.getDITStructureRules(nameForm);
    }

    public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
        return this.impl.getDITStructureRulesWithName(name);
    }

    public Collection<DITStructureRule> getDITStuctureRules() {
        return this.impl.getDITStuctureRules();
    }

    public MatchingRule getMatchingRule(String name) {
        return this.impl.getMatchingRule(name);
    }

    public Collection<MatchingRule> getMatchingRules() {
        return this.impl.getMatchingRules();
    }

    public Collection<MatchingRule> getMatchingRulesWithName(String name) {
        return this.impl.getMatchingRulesWithName(name);
    }

    public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        return this.getMatchingRuleUse(matchingRule.getOID());
    }

    public MatchingRuleUse getMatchingRuleUse(String name) {
        return this.impl.getMatchingRuleUse(name);
    }

    public Collection<MatchingRuleUse> getMatchingRuleUses() {
        return this.impl.getMatchingRuleUses();
    }

    public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
        return this.impl.getMatchingRuleUsesWithName(name);
    }

    public NameForm getNameForm(String name) {
        return this.impl.getNameForm(name);
    }

    public Collection<NameForm> getNameForms() {
        return this.impl.getNameForms();
    }

    public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
        return this.impl.getNameForms(structuralClass);
    }

    public Collection<NameForm> getNameFormsWithName(String name) {
        return this.impl.getNameFormsWithName(name);
    }

    public ObjectClass getObjectClass(String name) {
        return this.impl.getObjectClass(name);
    }

    public Collection<ObjectClass> getObjectClasses() {
        return this.impl.getObjectClasses();
    }

    public Collection<ObjectClass> getObjectClassesWithName(String name) {
        return this.impl.getObjectClassesWithName(name);
    }

    public String getSchemaName() {
        return this.impl.getSchemaName();
    }

    public Syntax getSyntax(String numericOID) {
        return this.impl.getSyntax(this, numericOID);
    }

    public Collection<Syntax> getSyntaxes() {
        return this.impl.getSyntaxes();
    }

    public Collection<LocalizableMessage> getWarnings() {
        return this.impl.getWarnings();
    }

    public boolean hasAttributeType(String name) {
        return this.impl.hasAttributeType(name);
    }

    public boolean hasDITContentRule(String name) {
        return this.impl.hasDITContentRule(name);
    }

    public boolean hasDITStructureRule(int ruleID) {
        return this.impl.hasDITStructureRule(ruleID);
    }

    public boolean hasMatchingRule(String name) {
        return this.impl.hasMatchingRule(name);
    }

    public boolean hasMatchingRuleUse(String name) {
        return this.impl.hasMatchingRuleUse(name);
    }

    public boolean hasNameForm(String name) {
        return this.impl.hasNameForm(name);
    }

    public boolean hasObjectClass(String name) {
        return this.impl.hasObjectClass(name);
    }

    public boolean hasSyntax(String numericOID) {
        return this.impl.hasSyntax(numericOID);
    }

    public boolean isStrict() {
        return this.impl.isStrict();
    }

    public Entry toEntry(Entry entry) {
        LinkedAttribute attr = new LinkedAttribute(ATTR_LDAP_SYNTAXES);
        for (Syntax syntax : this.getSyntaxes()) {
            attr.add(new Object[]{syntax.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_ATTRIBUTE_TYPES);
        for (AttributeType attributeType : this.getAttributeTypes()) {
            attr.add(new Object[]{attributeType.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_OBJECT_CLASSES);
        for (ObjectClass objectClass : this.getObjectClasses()) {
            attr.add(new Object[]{objectClass.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_MATCHING_RULE_USE);
        for (MatchingRuleUse matchingRuleUse : this.getMatchingRuleUses()) {
            attr.add(new Object[]{matchingRuleUse.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_MATCHING_RULES);
        for (MatchingRule matchingRule : this.getMatchingRules()) {
            attr.add(new Object[]{matchingRule.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_DIT_CONTENT_RULES);
        for (DITContentRule ditContentRule : this.getDITContentRules()) {
            attr.add(new Object[]{ditContentRule.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_DIT_STRUCTURE_RULES);
        for (DITStructureRule ditStructureRule : this.getDITStuctureRules()) {
            attr.add(new Object[]{ditStructureRule.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        attr = new LinkedAttribute(ATTR_NAME_FORMS);
        for (NameForm nameForm : this.getNameForms()) {
            attr.add(new Object[]{nameForm.toString()});
        }
        if (!attr.isEmpty()) {
            entry.addAttribute(attr);
        }
        return entry;
    }

    public boolean validateEntry(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages) {
        ObjectClass structuralObjectClass = null;
        Attribute objectClassAttribute = entry.getAttribute(AttributeDescription.objectClass());
        LinkedList<ObjectClass> objectClasses = new LinkedList<ObjectClass>();
        if (objectClassAttribute != null) {
            for (ByteString v : objectClassAttribute) {
                ObjectClass objectClass;
                String objectClassName = v.toString();
                try {
                    objectClass = this.getObjectClass(objectClassName);
                    objectClasses.add(objectClass);
                }
                catch (UnknownSchemaElementException e) {
                    if (!policy.checkAttributesAndObjectClasses().needsChecking()) continue;
                    if (errorMessages != null) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_UNKNOWN_OBJECT_CLASS.get((Object)entry.getName().toString(), (Object)objectClassName);
                        errorMessages.add(message);
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
                if (objectClass.getObjectClassType() != ObjectClassType.STRUCTURAL) continue;
                if (structuralObjectClass == null || objectClass.isDescendantOf(structuralObjectClass)) {
                    structuralObjectClass = objectClass;
                    continue;
                }
                if (structuralObjectClass.isDescendantOf(objectClass) || !policy.requireSingleStructuralObjectClass().needsChecking()) continue;
                if (errorMessages != null) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_MULTIPLE_STRUCTURAL_CLASSES.get((Object)entry.getName().toString(), (Object)structuralObjectClass.getNameOrOID(), (Object)objectClassName);
                    errorMessages.add(message);
                }
                if (!policy.requireSingleStructuralObjectClass().isReject()) continue;
                return false;
            }
        }
        Collection<Object> ditStructureRules = Collections.emptyList();
        DITContentRule ditContentRule = null;
        if (structuralObjectClass == null) {
            if (policy.requireSingleStructuralObjectClass().needsChecking()) {
                if (errorMessages != null) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_NO_STRUCTURAL_CLASS.get((Object)entry.getName().toString());
                    errorMessages.add(message);
                }
                if (policy.requireSingleStructuralObjectClass().isReject()) {
                    return false;
                }
            }
        } else {
            ditContentRule = this.getDITContentRule(structuralObjectClass);
            if (ditContentRule != null && ditContentRule.isObsolete()) {
                ditContentRule = null;
            }
        }
        if (!this.checkAttributesAndObjectClasses(entry, policy, errorMessages, objectClasses, ditContentRule)) {
            return false;
        }
        if (policy.checkNameForms().needsChecking() && structuralObjectClass != null) {
            boolean foundMatchingNameForms = false;
            NameForm nameForm = null;
            LinkedList<LocalizableMessage> nameFormWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            for (NameForm nf : this.getNameForms(structuralObjectClass)) {
                if (nf.isObsolete()) continue;
                foundMatchingNameForms = true;
                if (!this.checkNameForm(entry, policy, nameFormWarnings, nf)) continue;
                nameForm = nf;
                break;
            }
            if (foundMatchingNameForms) {
                if (nameForm != null) {
                    ditStructureRules = this.getDITStructureRules(nameForm);
                } else {
                    if (errorMessages != null) {
                        errorMessages.addAll(nameFormWarnings);
                    }
                    if (policy.checkNameForms().isReject()) {
                        return false;
                    }
                }
            }
        }
        if (policy.checkDITStructureRules().needsChecking() && !entry.getName().isRootDN()) {
            boolean foundMatchingRules = false;
            boolean foundValidRule = false;
            LinkedList<LocalizableMessage> ruleWarnings = errorMessages != null ? new LinkedList<LocalizableMessage>() : null;
            ObjectClass parentStructuralObjectClass = null;
            boolean parentEntryHasBeenRead = false;
            for (DITStructureRule rule : ditStructureRules) {
                if (rule.isObsolete()) continue;
                foundMatchingRules = true;
                if (rule.getSuperiorRules().isEmpty()) {
                    foundValidRule = true;
                    break;
                }
                if (!parentEntryHasBeenRead) {
                    parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                    parentEntryHasBeenRead = true;
                }
                if (parentStructuralObjectClass == null || !this.checkDITStructureRule(entry, policy, ruleWarnings, rule, structuralObjectClass, parentStructuralObjectClass)) continue;
                foundValidRule = true;
                break;
            }
            if (foundMatchingRules) {
                if (!foundValidRule) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDITStructureRules().isReject()) {
                        return false;
                    }
                }
            } else {
                parentStructuralObjectClass = this.getParentStructuralObjectClass(entry, policy, ruleWarnings);
                if (parentStructuralObjectClass == null) {
                    if (errorMessages != null) {
                        errorMessages.addAll(ruleWarnings);
                    }
                    if (policy.checkDITStructureRules().isReject()) {
                        return false;
                    }
                } else {
                    for (NameForm nf : this.getNameForms(parentStructuralObjectClass)) {
                        if (nf.isObsolete()) continue;
                        for (DITStructureRule rule : this.getDITStructureRules(nf)) {
                            if (rule.isObsolete()) continue;
                            if (errorMessages != null) {
                                LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_MISSING_DSR.get((Object)entry.getName().toString(), (Object)rule.getNameOrRuleID());
                                errorMessages.add(message);
                            }
                            if (!policy.checkDITStructureRules().isReject()) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    private boolean checkAttributesAndObjectClasses(Entry entry, SchemaValidationPolicy policy, Collection<LocalizableMessage> errorMessages, List<ObjectClass> objectClasses, DITContentRule ditContentRule) {
        boolean checkDITContentRule = policy.checkDITContentRules().needsChecking() && ditContentRule != null;
        boolean checkObjectClasses = policy.checkAttributesAndObjectClasses().needsChecking();
        boolean checkAttributeValues = policy.checkAttributeValues().needsChecking();
        if (checkObjectClasses || checkDITContentRule) {
            for (ObjectClass objectClass : objectClasses) {
                if (checkDITContentRule && objectClass.getObjectClassType() == ObjectClassType.AUXILIARY && !ditContentRule.getAuxiliaryClasses().contains(objectClass)) {
                    if (errorMessages != null) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_AUXILIARY_OC.get((Object)entry.getName().toString(), (Object)objectClass.getNameOrOID(), (Object)ditContentRule.getNameOrOID());
                        errorMessages.add(message);
                    }
                    if (policy.checkDITContentRules().isReject()) {
                        return false;
                    }
                }
                if (!checkObjectClasses) continue;
                for (AttributeType t : objectClass.getDeclaredRequiredAttributes()) {
                    Attribute a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_OC_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID(), (Object)objectClass.getNameOrOID());
                        errorMessages.add(message);
                    }
                    if (!policy.checkAttributesAndObjectClasses().isReject()) continue;
                    return false;
                }
            }
            if (checkDITContentRule) {
                LocalizableMessage message;
                Attribute a;
                for (AttributeType t : ditContentRule.getRequiredAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        message = CoreMessages.ERR_ENTRY_SCHEMA_DCR_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID());
                        errorMessages.add(message);
                    }
                    if (!policy.checkDITContentRules().isReject()) continue;
                    return false;
                }
                for (AttributeType t : ditContentRule.getProhibitedAttributes()) {
                    a = Attributes.emptyAttribute(AttributeDescription.create(t));
                    if (!entry.containsAttribute(a, null)) continue;
                    if (errorMessages != null) {
                        message = CoreMessages.ERR_ENTRY_SCHEMA_DCR_PROHIBITED_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID());
                        errorMessages.add(message);
                    }
                    if (!policy.checkDITContentRules().isReject()) continue;
                    return false;
                }
            }
        }
        if (checkObjectClasses || checkDITContentRule || checkAttributeValues) {
            for (Attribute attribute : entry.getAllAttributes()) {
                LocalizableMessage message;
                AttributeType t = attribute.getAttributeDescription().getAttributeType();
                if (!t.isOperational() && (checkObjectClasses || checkDITContentRule)) {
                    boolean isAllowed = false;
                    for (ObjectClass objectClass : objectClasses) {
                        if (!objectClass.isRequiredOrOptional(t)) continue;
                        isAllowed = true;
                        break;
                    }
                    if (!isAllowed && ditContentRule != null && ditContentRule.isRequiredOrOptional(t)) {
                        isAllowed = true;
                    }
                    if (!isAllowed) {
                        if (errorMessages != null) {
                            message = ditContentRule == null ? CoreMessages.ERR_ENTRY_SCHEMA_OC_DISALLOWED_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID()) : CoreMessages.ERR_ENTRY_SCHEMA_DCR_DISALLOWED_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID(), (Object)ditContentRule.getNameOrOID());
                            errorMessages.add(message);
                        }
                        if (policy.checkAttributesAndObjectClasses().isReject() || policy.checkDITContentRules().isReject()) {
                            return false;
                        }
                    }
                }
                if (!checkAttributeValues) continue;
                int sz = attribute.size();
                if (sz == 0) {
                    if (errorMessages != null) {
                        message = CoreMessages.ERR_ENTRY_SCHEMA_AT_EMPTY_ATTRIBUTE.get((Object)entry.getName().toString(), (Object)t.getNameOrOID());
                        errorMessages.add(message);
                    }
                    if (!policy.checkAttributeValues().isReject()) continue;
                    return false;
                }
                if (sz <= 1 || !t.isSingleValue()) continue;
                if (errorMessages != null) {
                    message = CoreMessages.ERR_ENTRY_SCHEMA_AT_SINGLE_VALUED_ATTRIBUTE.get((Object)entry.getName().toString(), (Object)t.getNameOrOID());
                    errorMessages.add(message);
                }
                if (!policy.checkAttributeValues().isReject()) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkDITStructureRule(Entry entry, SchemaValidationPolicy policy, List<LocalizableMessage> ruleWarnings, DITStructureRule rule, ObjectClass structuralObjectClass, ObjectClass parentStructuralObjectClass) {
        boolean matchFound = false;
        for (DITStructureRule parentRule : rule.getSuperiorRules()) {
            if (!parentRule.getNameForm().getStructuralClass().equals(parentStructuralObjectClass)) continue;
            matchFound = true;
        }
        if (!matchFound) {
            if (ruleWarnings != null) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_ILLEGAL_OC.get((Object)entry.getName().toString(), (Object)rule.getNameOrRuleID(), (Object)structuralObjectClass.getNameOrOID(), (Object)parentStructuralObjectClass.getNameOrOID());
                ruleWarnings.add(message);
            }
            return false;
        }
        return true;
    }

    private boolean checkNameForm(Entry entry, SchemaValidationPolicy policy, List<LocalizableMessage> nameFormWarnings, NameForm nameForm) {
        RDN rdn = entry.getName().rdn();
        if (rdn != null) {
            for (AttributeType t : nameForm.getRequiredAttributes()) {
                if (rdn.getAttributeValue(t) != null) continue;
                if (nameFormWarnings != null) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_NF_MISSING_MUST_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID(), (Object)nameForm.getNameOrOID());
                    nameFormWarnings.add(message);
                }
                return false;
            }
            for (AVA ava : rdn) {
                AttributeType t = ava.getAttributeType();
                if (nameForm.isRequiredOrOptional(t)) continue;
                if (nameFormWarnings != null) {
                    LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_NF_DISALLOWED_ATTRIBUTES.get((Object)entry.getName().toString(), (Object)t.getNameOrOID(), (Object)nameForm.getNameOrOID());
                    nameFormWarnings.add(message);
                }
                return false;
            }
        }
        return true;
    }

    private ObjectClass getParentStructuralObjectClass(Entry entry, SchemaValidationPolicy policy, List<LocalizableMessage> ruleWarnings) {
        Entry parentEntry;
        try {
            parentEntry = policy.checkDITStructureRulesEntryResolver().getEntry(entry.getName().parent());
        }
        catch (ErrorResultException e) {
            if (ruleWarnings != null) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_PARENT_NOT_FOUND.get((Object)entry.getName().toString(), (Object)e.getResult().getDiagnosticMessage());
                ruleWarnings.add(message);
            }
            return null;
        }
        ObjectClass parentStructuralObjectClass = Entries.getStructuralObjectClass(parentEntry, this);
        if (parentStructuralObjectClass == null) {
            if (ruleWarnings != null) {
                LocalizableMessage message = CoreMessages.ERR_ENTRY_SCHEMA_DSR_NO_PARENT_OC.get((Object)entry.getName().toString());
                ruleWarnings.add(message);
            }
            return null;
        }
        return parentStructuralObjectClass;
    }

    private static final class StrictImpl
    implements Impl {
        private final Map<Integer, DITStructureRule> id2StructureRules;
        private final Map<String, List<AttributeType>> name2AttributeTypes;
        private final Map<String, List<DITContentRule>> name2ContentRules;
        private final Map<String, List<MatchingRule>> name2MatchingRules;
        private final Map<String, List<MatchingRuleUse>> name2MatchingRuleUses;
        private final Map<String, List<NameForm>> name2NameForms;
        private final Map<String, List<ObjectClass>> name2ObjectClasses;
        private final Map<String, List<DITStructureRule>> name2StructureRules;
        private final Map<String, List<DITStructureRule>> nameForm2StructureRules;
        private final Map<String, AttributeType> numericOID2AttributeTypes;
        private final Map<String, DITContentRule> numericOID2ContentRules;
        private final Map<String, MatchingRule> numericOID2MatchingRules;
        private final Map<String, MatchingRuleUse> numericOID2MatchingRuleUses;
        private final Map<String, NameForm> numericOID2NameForms;
        private final Map<String, ObjectClass> numericOID2ObjectClasses;
        private final Map<String, Syntax> numericOID2Syntaxes;
        private final Map<String, List<NameForm>> objectClass2NameForms;
        private final List<LocalizableMessage> warnings;
        private final String schemaName;
        private final boolean allowMalformedJPEGPhotos;
        private final boolean allowNonStandardTelephoneNumbers;
        private final boolean allowZeroLengthDirectoryStrings;
        private final boolean allowMalformedNamesAndOptions;
        private final Syntax defaultSyntax;
        private final MatchingRule defaultMatchingRule;

        StrictImpl(String schemaName, boolean allowMalformedNamesAndOptions, boolean allowMalformedJPEGPhotos, boolean allowNonStandardTelephoneNumbers, boolean allowZeroLengthDirectoryStrings, Syntax defaultSyntax, MatchingRule defaultMatchingRule, Map<String, Syntax> numericOID2Syntaxes, Map<String, MatchingRule> numericOID2MatchingRules, Map<String, MatchingRuleUse> numericOID2MatchingRuleUses, Map<String, AttributeType> numericOID2AttributeTypes, Map<String, ObjectClass> numericOID2ObjectClasses, Map<String, NameForm> numericOID2NameForms, Map<String, DITContentRule> numericOID2ContentRules, Map<Integer, DITStructureRule> id2StructureRules, Map<String, List<MatchingRule>> name2MatchingRules, Map<String, List<MatchingRuleUse>> name2MatchingRuleUses, Map<String, List<AttributeType>> name2AttributeTypes, Map<String, List<ObjectClass>> name2ObjectClasses, Map<String, List<NameForm>> name2NameForms, Map<String, List<DITContentRule>> name2ContentRules, Map<String, List<DITStructureRule>> name2StructureRules, Map<String, List<NameForm>> objectClass2NameForms, Map<String, List<DITStructureRule>> nameForm2StructureRules, List<LocalizableMessage> warnings) {
            this.schemaName = schemaName;
            this.allowMalformedNamesAndOptions = allowMalformedNamesAndOptions;
            this.allowMalformedJPEGPhotos = allowMalformedJPEGPhotos;
            this.allowNonStandardTelephoneNumbers = allowNonStandardTelephoneNumbers;
            this.allowZeroLengthDirectoryStrings = allowZeroLengthDirectoryStrings;
            this.defaultSyntax = defaultSyntax;
            this.defaultMatchingRule = defaultMatchingRule;
            this.numericOID2Syntaxes = Collections.unmodifiableMap(numericOID2Syntaxes);
            this.numericOID2MatchingRules = Collections.unmodifiableMap(numericOID2MatchingRules);
            this.numericOID2MatchingRuleUses = Collections.unmodifiableMap(numericOID2MatchingRuleUses);
            this.numericOID2AttributeTypes = Collections.unmodifiableMap(numericOID2AttributeTypes);
            this.numericOID2ObjectClasses = Collections.unmodifiableMap(numericOID2ObjectClasses);
            this.numericOID2NameForms = Collections.unmodifiableMap(numericOID2NameForms);
            this.numericOID2ContentRules = Collections.unmodifiableMap(numericOID2ContentRules);
            this.id2StructureRules = Collections.unmodifiableMap(id2StructureRules);
            this.name2MatchingRules = Collections.unmodifiableMap(name2MatchingRules);
            this.name2MatchingRuleUses = Collections.unmodifiableMap(name2MatchingRuleUses);
            this.name2AttributeTypes = Collections.unmodifiableMap(name2AttributeTypes);
            this.name2ObjectClasses = Collections.unmodifiableMap(name2ObjectClasses);
            this.name2NameForms = Collections.unmodifiableMap(name2NameForms);
            this.name2ContentRules = Collections.unmodifiableMap(name2ContentRules);
            this.name2StructureRules = Collections.unmodifiableMap(name2StructureRules);
            this.objectClass2NameForms = Collections.unmodifiableMap(objectClass2NameForms);
            this.nameForm2StructureRules = Collections.unmodifiableMap(nameForm2StructureRules);
            this.warnings = Collections.unmodifiableList(warnings);
        }

        @Override
        public boolean allowMalformedNamesAndOptions() {
            return this.allowMalformedNamesAndOptions;
        }

        @Override
        public boolean allowMalformedJPEGPhotos() {
            return this.allowMalformedJPEGPhotos;
        }

        @Override
        public boolean allowNonStandardTelephoneNumbers() {
            return this.allowNonStandardTelephoneNumbers;
        }

        @Override
        public boolean allowZeroLengthDirectoryStrings() {
            return this.allowZeroLengthDirectoryStrings;
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.defaultSyntax;
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.defaultMatchingRule;
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String name) {
            AttributeType type = this.getAttributeType0(name);
            if (type != null) {
                return type;
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.numericOID2AttributeTypes.values();
        }

        @Override
        public List<AttributeType> getAttributeTypesWithName(String name) {
            List<AttributeType> attributes = this.name2AttributeTypes.get(StaticUtils.toLowerCase(name));
            if (attributes == null) {
                return Collections.emptyList();
            }
            return attributes;
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return this.numericOID2ContentRules.get(structuralClass.getOID());
        }

        @Override
        public DITContentRule getDITContentRule(String name) {
            DITContentRule rule = this.numericOID2ContentRules.get(name);
            if (rule != null) {
                return rule;
            }
            List<DITContentRule> rules = this.name2ContentRules.get(StaticUtils.toLowerCase(name));
            if (rules != null) {
                if (rules.size() == 1) {
                    return rules.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_AMBIGIOUS.get((Object)name));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return this.numericOID2ContentRules.values();
        }

        @Override
        public Collection<DITContentRule> getDITContentRulesWithName(String name) {
            List<DITContentRule> rules = this.name2ContentRules.get(StaticUtils.toLowerCase(name));
            if (rules == null) {
                return Collections.emptyList();
            }
            return rules;
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            DITStructureRule rule = this.id2StructureRules.get(ruleID);
            if (rule == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_DSR_UNKNOWN.get((Object)String.valueOf(ruleID)));
            }
            return rule;
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            List<DITStructureRule> rules = this.nameForm2StructureRules.get(nameForm.getOID());
            if (rules == null) {
                return Collections.emptyList();
            }
            return rules;
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
            List<DITStructureRule> rules = this.name2StructureRules.get(StaticUtils.toLowerCase(name));
            if (rules == null) {
                return Collections.emptyList();
            }
            return rules;
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return this.id2StructureRules.values();
        }

        @Override
        public MatchingRule getMatchingRule(String name) {
            MatchingRule rule = this.numericOID2MatchingRules.get(name);
            if (rule != null) {
                return rule;
            }
            List<MatchingRule> rules = this.name2MatchingRules.get(StaticUtils.toLowerCase(name));
            if (rules != null) {
                if (rules.size() == 1) {
                    return rules.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_MR_AMBIGIOUS.get((Object)name));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MR_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.numericOID2MatchingRules.values();
        }

        @Override
        public Collection<MatchingRule> getMatchingRulesWithName(String name) {
            List<MatchingRule> rules = this.name2MatchingRules.get(StaticUtils.toLowerCase(name));
            if (rules == null) {
                return Collections.emptyList();
            }
            return rules;
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.numericOID2MatchingRuleUses.get(matchingRule.getOID());
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String name) {
            MatchingRuleUse rule = this.numericOID2MatchingRuleUses.get(name);
            if (rule != null) {
                return rule;
            }
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(name));
            if (uses != null) {
                if (uses.size() == 1) {
                    return uses.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_AMBIGIOUS.get((Object)name));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.numericOID2MatchingRuleUses.values();
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
            List<MatchingRuleUse> rules = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(name));
            if (rules == null) {
                return Collections.emptyList();
            }
            return rules;
        }

        @Override
        public NameForm getNameForm(String name) {
            NameForm form = this.numericOID2NameForms.get(name);
            if (form != null) {
                return form;
            }
            List<NameForm> forms = this.name2NameForms.get(StaticUtils.toLowerCase(name));
            if (forms != null) {
                if (forms.size() == 1) {
                    return forms.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_AMBIGIOUS.get((Object)name));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.numericOID2NameForms.values();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            List<NameForm> forms = this.objectClass2NameForms.get(structuralClass.getOID());
            if (forms == null) {
                return Collections.emptyList();
            }
            return forms;
        }

        @Override
        public Collection<NameForm> getNameFormsWithName(String name) {
            List<NameForm> forms = this.name2NameForms.get(StaticUtils.toLowerCase(name));
            if (forms == null) {
                return Collections.emptyList();
            }
            return forms;
        }

        @Override
        public ObjectClass getObjectClass(String name) {
            ObjectClass oc = this.numericOID2ObjectClasses.get(name);
            if (oc != null) {
                return oc;
            }
            List<ObjectClass> classes = this.name2ObjectClasses.get(StaticUtils.toLowerCase(name));
            if (classes != null) {
                if (classes.size() == 1) {
                    return classes.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_AMBIGIOUS.get((Object)name));
            }
            throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.numericOID2ObjectClasses.values();
        }

        @Override
        public Collection<ObjectClass> getObjectClassesWithName(String name) {
            List<ObjectClass> classes = this.name2ObjectClasses.get(StaticUtils.toLowerCase(name));
            if (classes == null) {
                return Collections.emptyList();
            }
            return classes;
        }

        @Override
        public String getSchemaName() {
            return this.schemaName;
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            Syntax syntax = this.numericOID2Syntaxes.get(numericOID);
            if (syntax == null) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_SYNTAX_UNKNOWN.get((Object)numericOID));
            }
            return syntax;
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.numericOID2Syntaxes.values();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.warnings;
        }

        @Override
        public boolean hasAttributeType(String name) {
            if (this.numericOID2AttributeTypes.containsKey(name)) {
                return true;
            }
            List<AttributeType> attributes = this.name2AttributeTypes.get(StaticUtils.toLowerCase(name));
            return attributes != null && attributes.size() == 1;
        }

        @Override
        public boolean hasDITContentRule(String name) {
            if (this.numericOID2ContentRules.containsKey(name)) {
                return true;
            }
            List<DITContentRule> rules = this.name2ContentRules.get(StaticUtils.toLowerCase(name));
            return rules != null && rules.size() == 1;
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return this.id2StructureRules.containsKey(ruleID);
        }

        @Override
        public boolean hasMatchingRule(String name) {
            if (this.numericOID2MatchingRules.containsKey(name)) {
                return true;
            }
            List<MatchingRule> rules = this.name2MatchingRules.get(StaticUtils.toLowerCase(name));
            return rules != null && rules.size() == 1;
        }

        @Override
        public boolean hasMatchingRuleUse(String name) {
            if (this.numericOID2MatchingRuleUses.containsKey(name)) {
                return true;
            }
            List<MatchingRuleUse> uses = this.name2MatchingRuleUses.get(StaticUtils.toLowerCase(name));
            return uses != null && uses.size() == 1;
        }

        @Override
        public boolean hasNameForm(String name) {
            if (this.numericOID2NameForms.containsKey(name)) {
                return true;
            }
            List<NameForm> forms = this.name2NameForms.get(StaticUtils.toLowerCase(name));
            return forms != null && forms.size() == 1;
        }

        @Override
        public boolean hasObjectClass(String name) {
            if (this.numericOID2ObjectClasses.containsKey(name)) {
                return true;
            }
            List<ObjectClass> classes = this.name2ObjectClasses.get(StaticUtils.toLowerCase(name));
            return classes != null && classes.size() == 1;
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return this.numericOID2Syntaxes.containsKey(numericOID);
        }

        @Override
        public boolean isStrict() {
            return true;
        }

        AttributeType getAttributeType0(String name) {
            AttributeType type = this.numericOID2AttributeTypes.get(name);
            if (type != null) {
                return type;
            }
            List<AttributeType> attributes = this.name2AttributeTypes.get(StaticUtils.toLowerCase(name));
            if (attributes != null) {
                if (attributes.size() == 1) {
                    return attributes.get(0);
                }
                throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_AMBIGIOUS.get((Object)name));
            }
            return null;
        }
    }

    private static final class NonStrictImpl
    implements Impl {
        private final StrictImpl strictImpl;

        private NonStrictImpl(StrictImpl strictImpl) {
            this.strictImpl = strictImpl;
        }

        @Override
        public boolean allowMalformedNamesAndOptions() {
            return this.strictImpl.allowMalformedNamesAndOptions();
        }

        @Override
        public boolean allowMalformedJPEGPhotos() {
            return this.strictImpl.allowMalformedJPEGPhotos();
        }

        @Override
        public boolean allowNonStandardTelephoneNumbers() {
            return this.strictImpl.allowNonStandardTelephoneNumbers();
        }

        @Override
        public boolean allowZeroLengthDirectoryStrings() {
            return this.strictImpl.allowZeroLengthDirectoryStrings();
        }

        @Override
        public Syntax getDefaultSyntax() {
            return this.strictImpl.getDefaultSyntax();
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return this.strictImpl.getDefaultMatchingRule();
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String name) {
            AttributeType type = this.strictImpl.getAttributeType0(name);
            return type != null ? type : new AttributeType(schema, name);
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return this.strictImpl.getAttributeTypes();
        }

        @Override
        public List<AttributeType> getAttributeTypesWithName(String name) {
            return this.strictImpl.getAttributeTypesWithName(name);
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return this.strictImpl.getDITContentRule(structuralClass);
        }

        @Override
        public DITContentRule getDITContentRule(String name) {
            return this.strictImpl.getDITContentRule(name);
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return this.strictImpl.getDITContentRules();
        }

        @Override
        public Collection<DITContentRule> getDITContentRulesWithName(String name) {
            return this.strictImpl.getDITContentRulesWithName(name);
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            return this.strictImpl.getDITStructureRule(ruleID);
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            return this.strictImpl.getDITStructureRules(nameForm);
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
            return this.strictImpl.getDITStructureRulesWithName(name);
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return this.strictImpl.getDITStuctureRules();
        }

        @Override
        public MatchingRule getMatchingRule(String name) {
            return this.strictImpl.getMatchingRule(name);
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return this.strictImpl.getMatchingRules();
        }

        @Override
        public Collection<MatchingRule> getMatchingRulesWithName(String name) {
            return this.strictImpl.getMatchingRulesWithName(name);
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return this.strictImpl.getMatchingRuleUse(matchingRule);
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String name) {
            return this.strictImpl.getMatchingRuleUse(name);
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return this.strictImpl.getMatchingRuleUses();
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
            return this.strictImpl.getMatchingRuleUsesWithName(name);
        }

        @Override
        public NameForm getNameForm(String name) {
            return this.strictImpl.getNameForm(name);
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return this.strictImpl.getNameForms();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            return this.strictImpl.getNameForms(structuralClass);
        }

        @Override
        public Collection<NameForm> getNameFormsWithName(String name) {
            return this.strictImpl.getNameFormsWithName(name);
        }

        @Override
        public ObjectClass getObjectClass(String name) {
            return this.strictImpl.getObjectClass(name);
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return this.strictImpl.getObjectClasses();
        }

        @Override
        public Collection<ObjectClass> getObjectClassesWithName(String name) {
            return this.strictImpl.getObjectClassesWithName(name);
        }

        @Override
        public String getSchemaName() {
            return this.strictImpl.getSchemaName();
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            if (!this.strictImpl.hasSyntax(numericOID)) {
                return new Syntax(schema, numericOID);
            }
            return this.strictImpl.getSyntax(schema, numericOID);
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return this.strictImpl.getSyntaxes();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return this.strictImpl.getWarnings();
        }

        @Override
        public boolean hasAttributeType(String name) {
            return this.strictImpl.hasAttributeType(name);
        }

        @Override
        public boolean hasDITContentRule(String name) {
            return this.strictImpl.hasDITContentRule(name);
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return this.strictImpl.hasDITStructureRule(ruleID);
        }

        @Override
        public boolean hasMatchingRule(String name) {
            return this.strictImpl.hasMatchingRule(name);
        }

        @Override
        public boolean hasMatchingRuleUse(String name) {
            return this.strictImpl.hasMatchingRuleUse(name);
        }

        @Override
        public boolean hasNameForm(String name) {
            return this.strictImpl.hasNameForm(name);
        }

        @Override
        public boolean hasObjectClass(String name) {
            return this.strictImpl.hasObjectClass(name);
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return this.strictImpl.hasSyntax(numericOID);
        }

        @Override
        public boolean isStrict() {
            return false;
        }
    }

    private static interface Impl {
        public boolean allowMalformedNamesAndOptions();

        public boolean allowMalformedJPEGPhotos();

        public boolean allowNonStandardTelephoneNumbers();

        public boolean allowZeroLengthDirectoryStrings();

        public MatchingRule getDefaultMatchingRule();

        public Syntax getDefaultSyntax();

        public AttributeType getAttributeType(Schema var1, String var2);

        public Collection<AttributeType> getAttributeTypes();

        public List<AttributeType> getAttributeTypesWithName(String var1);

        public DITContentRule getDITContentRule(ObjectClass var1);

        public DITContentRule getDITContentRule(String var1);

        public Collection<DITContentRule> getDITContentRules();

        public Collection<DITContentRule> getDITContentRulesWithName(String var1);

        public DITStructureRule getDITStructureRule(int var1);

        public Collection<DITStructureRule> getDITStructureRules(NameForm var1);

        public Collection<DITStructureRule> getDITStructureRulesWithName(String var1);

        public Collection<DITStructureRule> getDITStuctureRules();

        public MatchingRule getMatchingRule(String var1);

        public Collection<MatchingRule> getMatchingRules();

        public Collection<MatchingRule> getMatchingRulesWithName(String var1);

        public MatchingRuleUse getMatchingRuleUse(MatchingRule var1);

        public MatchingRuleUse getMatchingRuleUse(String var1);

        public Collection<MatchingRuleUse> getMatchingRuleUses();

        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String var1);

        public NameForm getNameForm(String var1);

        public Collection<NameForm> getNameForms();

        public Collection<NameForm> getNameForms(ObjectClass var1);

        public Collection<NameForm> getNameFormsWithName(String var1);

        public ObjectClass getObjectClass(String var1);

        public Collection<ObjectClass> getObjectClasses();

        public Collection<ObjectClass> getObjectClassesWithName(String var1);

        public String getSchemaName();

        public Syntax getSyntax(Schema var1, String var2);

        public Collection<Syntax> getSyntaxes();

        public Collection<LocalizableMessage> getWarnings();

        public boolean hasAttributeType(String var1);

        public boolean hasDITContentRule(String var1);

        public boolean hasDITStructureRule(int var1);

        public boolean hasMatchingRule(String var1);

        public boolean hasMatchingRuleUse(String var1);

        public boolean hasNameForm(String var1);

        public boolean hasObjectClass(String var1);

        public boolean hasSyntax(String var1);

        public boolean isStrict();
    }

    private static final class EmptyImpl
    implements Impl {
        private final boolean isStrict;

        private EmptyImpl(boolean isStrict) {
            this.isStrict = isStrict;
        }

        @Override
        public boolean allowMalformedNamesAndOptions() {
            return true;
        }

        @Override
        public boolean allowNonStandardTelephoneNumbers() {
            return true;
        }

        @Override
        public boolean allowMalformedJPEGPhotos() {
            return true;
        }

        @Override
        public boolean allowZeroLengthDirectoryStrings() {
            return false;
        }

        @Override
        public Syntax getDefaultSyntax() {
            return Schema.getCoreSchema().getDefaultSyntax();
        }

        @Override
        public MatchingRule getDefaultMatchingRule() {
            return Schema.getCoreSchema().getDefaultMatchingRule();
        }

        @Override
        public AttributeType getAttributeType(Schema schema, String name) {
            if (this.isStrict) {
                throw new UnknownSchemaElementException(CoreMessages.WARN_ATTR_TYPE_UNKNOWN.get((Object)name));
            }
            return new AttributeType(schema, name);
        }

        @Override
        public Collection<AttributeType> getAttributeTypes() {
            return Collections.emptyList();
        }

        @Override
        public List<AttributeType> getAttributeTypesWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public DITContentRule getDITContentRule(ObjectClass structuralClass) {
            return null;
        }

        @Override
        public DITContentRule getDITContentRule(String name) {
            throw new UnknownSchemaElementException(CoreMessages.WARN_DCR_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<DITContentRule> getDITContentRules() {
            return Collections.emptyList();
        }

        @Override
        public Collection<DITContentRule> getDITContentRulesWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public DITStructureRule getDITStructureRule(int ruleID) {
            throw new UnknownSchemaElementException(CoreMessages.WARN_DSR_UNKNOWN.get((Object)String.valueOf(ruleID)));
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRules(NameForm nameForm) {
            return Collections.emptyList();
        }

        @Override
        public Collection<DITStructureRule> getDITStructureRulesWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public Collection<DITStructureRule> getDITStuctureRules() {
            return Collections.emptyList();
        }

        @Override
        public MatchingRule getMatchingRule(String name) {
            throw new UnknownSchemaElementException(CoreMessages.WARN_MR_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<MatchingRule> getMatchingRules() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MatchingRule> getMatchingRulesWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
            return null;
        }

        @Override
        public MatchingRuleUse getMatchingRuleUse(String name) {
            throw new UnknownSchemaElementException(CoreMessages.WARN_MRU_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUses() {
            return Collections.emptyList();
        }

        @Override
        public Collection<MatchingRuleUse> getMatchingRuleUsesWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public NameForm getNameForm(String name) {
            throw new UnknownSchemaElementException(CoreMessages.WARN_NAMEFORM_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<NameForm> getNameForms() {
            return Collections.emptyList();
        }

        @Override
        public Collection<NameForm> getNameForms(ObjectClass structuralClass) {
            return Collections.emptyList();
        }

        @Override
        public Collection<NameForm> getNameFormsWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public ObjectClass getObjectClass(String name) {
            throw new UnknownSchemaElementException(CoreMessages.WARN_OBJECTCLASS_UNKNOWN.get((Object)name));
        }

        @Override
        public Collection<ObjectClass> getObjectClasses() {
            return Collections.emptyList();
        }

        @Override
        public Collection<ObjectClass> getObjectClassesWithName(String name) {
            return Collections.emptyList();
        }

        @Override
        public String getSchemaName() {
            return "Empty Schema";
        }

        @Override
        public Syntax getSyntax(Schema schema, String numericOID) {
            return new Syntax(schema, numericOID);
        }

        @Override
        public Collection<Syntax> getSyntaxes() {
            return Collections.emptyList();
        }

        @Override
        public Collection<LocalizableMessage> getWarnings() {
            return Collections.emptyList();
        }

        @Override
        public boolean hasAttributeType(String name) {
            return false;
        }

        @Override
        public boolean hasDITContentRule(String name) {
            return false;
        }

        @Override
        public boolean hasDITStructureRule(int ruleID) {
            return false;
        }

        @Override
        public boolean hasMatchingRule(String name) {
            return false;
        }

        @Override
        public boolean hasMatchingRuleUse(String name) {
            return false;
        }

        @Override
        public boolean hasNameForm(String name) {
            return false;
        }

        @Override
        public boolean hasObjectClass(String name) {
            return false;
        }

        @Override
        public boolean hasSyntax(String numericOID) {
            return false;
        }

        @Override
        public boolean isStrict() {
            return this.isStrict;
        }
    }
}

