/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class OIDSyntaxImpl
extends AbstractSyntaxImpl {
    OIDSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.0";
    }

    @Override
    public String getName() {
        return "OID";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        try {
            SchemaUtils.readOID(new SubstringReader(value.toString()), schema.allowMalformedNamesAndOptions());
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
    }
}

