/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.SchemaException;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class MatchingRuleUse
extends SchemaElement {
    private final String oid;
    private final List<String> names;
    private final boolean isObsolete;
    private final Set<String> attributeOIDs;
    private final String definition;
    private MatchingRule matchingRule;
    private Set<AttributeType> attributes = Collections.emptySet();

    MatchingRuleUse(String oid, List<String> names, String description, boolean obsolete, Set<String> attributeOIDs, Map<String, List<String>> extraProperties, String definition) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)oid, names, attributeOIDs);
        this.oid = oid;
        this.names = names;
        this.isObsolete = obsolete;
        this.attributeOIDs = attributeOIDs;
        this.definition = definition != null ? definition : this.buildDefinition();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MatchingRuleUse) {
            MatchingRuleUse other = (MatchingRuleUse)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public Set<AttributeType> getAttributes() {
        return this.attributes;
    }

    public MatchingRule getMatchingRule() {
        return this.matchingRule;
    }

    public String getMatchingRuleOID() {
        return this.oid;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public boolean hasAttribute(AttributeType attributeType) {
        return this.attributes.contains(attributeType);
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.oid.equals(value);
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    @Override
    public String toString() {
        return this.definition;
    }

    MatchingRuleUse duplicate() {
        return new MatchingRuleUse(this.oid, this.names, this.description, this.isObsolete, this.attributeOIDs, this.extraProperties, this.definition);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        String firstName;
        Iterator<String> iterator;
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            iterator = this.names.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (!this.attributeOIDs.isEmpty()) {
            iterator = this.attributeOIDs.iterator();
            firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" APPLIES ( ");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append(" $ ");
                    buffer.append(iterator.next());
                }
                buffer.append(" )");
            } else {
                buffer.append(" APPLIES ");
                buffer.append(firstName);
            }
        }
    }

    void validate(Schema schema, List<LocalizableMessage> warnings) throws SchemaException {
        try {
            this.matchingRule = schema.getMatchingRule(this.oid);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_MATCHING_RULE1.get((Object)this.getNameOrOID(), (Object)this.oid);
            throw new SchemaException(message, (Throwable)((Object)e));
        }
        this.attributes = new HashSet<AttributeType>(this.attributeOIDs.size());
        for (String attribute : this.attributeOIDs) {
            AttributeType attributeType;
            try {
                attributeType = schema.getAttributeType(attribute);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_MRUSE_UNKNOWN_ATTR1.get((Object)this.getNameOrOID(), (Object)attribute);
                throw new SchemaException(message, (Throwable)((Object)e));
            }
            this.attributes.add(attributeType);
        }
        this.attributes = Collections.unmodifiableSet(this.attributes);
    }
}

