/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class LDAPSyntaxDescriptionSyntaxImpl
extends AbstractSyntaxImpl {
    LDAPSyntaxDescriptionSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.30";
    }

    @Override
    public String getName() {
        return "LDAPSyntaxDescription";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String definition = value.toString();
        try {
            String tokenName;
            SubstringReader reader = new SubstringReader(definition);
            reader.skipWhitespaces();
            if (reader.remaining() <= 0) {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EMPTY_VALUE1.get((Object)definition);
                DecodeException e = DecodeException.error(message);
                StaticUtils.DEBUG_LOG.throwing("LDAPSyntaxDescriptionSyntax", "valueIsAcceptable", e);
                throw e;
            }
            char c = reader.read();
            if (c != '(') {
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_EXPECTED_OPEN_PARENTHESIS.get((Object)definition, (Object)(reader.pos() - 1), (Object)String.valueOf(c));
                DecodeException e = DecodeException.error(message);
                StaticUtils.DEBUG_LOG.throwing("LDAPSyntaxDescriptionSyntax", "valueIsAcceptable", e);
                throw e;
            }
            reader.skipWhitespaces();
            String oid = SchemaUtils.readOID(reader, schema.allowMalformedNamesAndOptions());
            Map<String, List<String>> extraProperties = Collections.emptyMap();
            while ((tokenName = SchemaUtils.readTokenName(reader)) != null) {
                if (tokenName.equalsIgnoreCase("desc")) {
                    SchemaUtils.readQuotedString(reader);
                    continue;
                }
                if (tokenName.matches("^X-[A-Za-z_-]+$")) {
                    if (extraProperties.isEmpty()) {
                        extraProperties = new HashMap();
                    }
                    extraProperties.put(tokenName, SchemaUtils.readExtensions(reader));
                    continue;
                }
                LocalizableMessage message = CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_ILLEGAL_TOKEN1.get((Object)definition, (Object)tokenName);
                DecodeException e = DecodeException.error(message);
                StaticUtils.DEBUG_LOG.throwing("LDAPSyntaxDescriptionSyntax", "valueIsAcceptable", e);
                throw e;
            }
            for (Map.Entry property : extraProperties.entrySet()) {
                Iterator values;
                if (((String)property.getKey()).equalsIgnoreCase("x-pattern")) {
                    values = ((List)property.getValue()).iterator();
                    if (!values.hasNext()) continue;
                    String pattern = (String)values.next();
                    try {
                        Pattern.compile((String)values.next());
                        break;
                    }
                    catch (Exception e) {
                        LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_REGEX_INVALID_PATTERN.get((Object)oid, (Object)pattern);
                        DecodeException de = DecodeException.error(message, e);
                        StaticUtils.DEBUG_LOG.throwing("LDAPSyntaxDescriptionSyntax", "valueIsAcceptable", de);
                        throw de;
                    }
                }
                if (!((String)property.getKey()).equalsIgnoreCase("x-enum")) continue;
                values = (List)property.getValue();
                for (int i = 0; i < values.size() - 1; ++i) {
                    String entry = (String)values.get(i);
                    for (int j = i + 1; j < values.size(); ++j) {
                        if (!entry.equals(values.get(j))) continue;
                        LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_LDAPSYNTAX_ENUM_DUPLICATE_VALUE.get((Object)oid, (Object)entry, (Object)j);
                        DecodeException e = DecodeException.error(message);
                        StaticUtils.DEBUG_LOG.throwing("LDAPSyntaxDescriptionSyntax", "valueIsAcceptable", e);
                        throw e;
                    }
                }
            }
            return true;
        }
        catch (DecodeException de) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ATTRSYNTAX_INVALID1.get((Object)definition, (Object)de.getMessageObject()));
            return false;
        }
    }
}

