/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StringPrepProfile;
import org.forgerock.opendj.ldap.Assertion;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConditionResult;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class KeywordEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    KeywordEqualityMatchingRuleImpl() {
    }

    @Override
    public Assertion getAssertion(Schema schema, ByteSequence value) throws DecodeException {
        final String normalStr = this.normalize(value);
        return new Assertion(){

            @Override
            public ConditionResult matches(ByteSequence attributeValue) {
                char c;
                String valueStr1 = attributeValue.toString();
                int pos = valueStr1.indexOf(normalStr);
                if (pos < 0) {
                    return ConditionResult.FALSE;
                }
                if (pos > 0) {
                    c = valueStr1.charAt(pos - 1);
                    switch (c) {
                        case ' ': 
                        case '#': 
                        case '$': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case '=': 
                        case '_': {
                            break;
                        }
                        default: {
                            return ConditionResult.FALSE;
                        }
                    }
                }
                if (valueStr1.length() > pos + normalStr.length()) {
                    c = valueStr1.charAt(pos + normalStr.length());
                    switch (c) {
                        case ' ': 
                        case '#': 
                        case '$': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case '=': 
                        case '_': {
                            break;
                        }
                        default: {
                            return ConditionResult.FALSE;
                        }
                    }
                }
                return ConditionResult.TRUE;
            }
        };
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) {
        return ByteString.valueOf(this.normalize(value));
    }

    private String normalize(ByteSequence value) {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, true, true);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return " ".intern();
            }
            return "".intern();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return buffer.toString();
    }
}

