/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;

final class IA5StringSyntaxImpl
extends AbstractSyntaxImpl {
    IA5StringSyntaxImpl() {
    }

    @Override
    public String getApproximateMatchingRule() {
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.2";
    }

    @Override
    public String getName() {
        return "IA5String";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.3";
    }

    @Override
    public String getSubstringMatchingRule() {
        return "2.5.13.4";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        for (int i = 0; i < value.length(); ++i) {
            byte b = value.byteAt(i);
            if ((b & 0x7F) == b) continue;
            LocalizableMessage message = CoreMessages.WARN_ATTR_SYNTAX_IA5_ILLEGAL_CHARACTER.get((Object)value.toString(), (Object)String.valueOf(b));
            invalidReason.append(message);
            return false;
        }
        return true;
    }
}

