/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.forgerock.opendj.ldap.schema.AttributeType;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.ObjectClass;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;

final class GenerateCoreSchema {
    private static final Set<String> ABBREVIATIONS = new HashSet<String>(Arrays.asList("SASL", "LDAP", "DN", "DIT", "RDN", "JPEG", "OID", "UUID", "IA5", "UID", "UTC", "X500", "X121", "C", "CN", "O", "OU", "L", "DC", "ISDN", "SN", "ST"));

    public static void main(String[] args) {
        String description;
        GenerateCoreSchema.testSplitNameIntoWords();
        Schema schema = Schema.getCoreSchema();
        TreeMap<String, Syntax> syntaxes = new TreeMap<String, Syntax>();
        for (Syntax syntax : schema.getSyntaxes()) {
            if (GenerateCoreSchema.isOpenDSOID(syntax.getOID())) continue;
            String name = syntax.getDescription().replaceAll(" Syntax$", "");
            String fieldName = name.replace(" ", "_").toUpperCase(Locale.ENGLISH).concat("_SYNTAX");
            syntaxes.put(fieldName, syntax);
        }
        TreeMap<String, MatchingRule> matchingRules = new TreeMap<String, MatchingRule>();
        for (MatchingRule matchingRule : schema.getMatchingRules()) {
            if (GenerateCoreSchema.isOpenDSOID(matchingRule.getOID())) continue;
            String name = matchingRule.getNameOrOID().replaceAll("Match$", "");
            String string = GenerateCoreSchema.splitNameIntoWords(name).concat("_MATCHING_RULE");
            matchingRules.put(string, matchingRule);
        }
        TreeMap<String, AttributeType> attributeTypes = new TreeMap<String, AttributeType>();
        for (AttributeType attributeType : schema.getAttributeTypes()) {
            if (GenerateCoreSchema.isOpenDSOID(attributeType.getOID())) continue;
            String string = attributeType.getNameOrOID();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(string).concat("_ATTRIBUTE_TYPE");
            attributeTypes.put(fieldName, attributeType);
        }
        TreeMap<String, ObjectClass> objectClasses = new TreeMap<String, ObjectClass>();
        for (ObjectClass objectClass : schema.getObjectClasses()) {
            if (GenerateCoreSchema.isOpenDSOID(objectClass.getOID())) continue;
            String name = objectClass.getNameOrOID();
            String fieldName = GenerateCoreSchema.splitNameIntoWords(name).concat("_OBJECT_CLASS");
            objectClasses.put(fieldName, objectClass);
        }
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("package org.forgerock.opendj.ldap.schema;");
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("/**");
        System.out.println(" * The OpenDJ SDK core schema contains standard LDAP RFC schema elements. These include:");
        System.out.println(" * <ul>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4512\">RFC 4512 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): Directory Information");
        System.out.println(" * Models </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4517\">RFC 4517 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): Syntaxes and Matching");
        System.out.println(" * Rules </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4519\">RFC 4519 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): Schema for User");
        System.out.println(" * Applications </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc4530\">RFC 4530 -");
        System.out.println(" * Lightweight Directory Access Protocol (LDAP): entryUUID Operational");
        System.out.println(" * Attribute </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3045\">RFC 3045 - Storing");
        System.out.println(" * Vendor Information in the LDAP Root DSE </a>");
        System.out.println(" * <li><a href=\"http://tools.ietf.org/html/rfc3112\">RFC 3112 - LDAP");
        System.out.println(" * Authentication Password Schema </a>");
        System.out.println(" * </ul>");
        System.out.println(" * <p>");
        System.out.println(" * The core schema is non-strict: attempts to retrieve");
        System.out.println(" * non-existent Attribute Types will return a temporary");
        System.out.println(" * Attribute Type having the Octet String syntax.");
        System.out.println(" */");
        System.out.println("public final class CoreSchema");
        System.out.println("{");
        System.out.println("  // Core Syntaxes");
        for (Map.Entry entry : syntaxes.entrySet()) {
            System.out.println("  private static final Syntax " + (String)entry.getKey() + " =");
            System.out.println("    CoreSchemaImpl.getInstance().getSyntax(\"" + ((Syntax)entry.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("  // Core Matching Rules");
        for (Map.Entry entry : matchingRules.entrySet()) {
            System.out.println("  private static final MatchingRule " + (String)entry.getKey() + " =");
            System.out.println("    CoreSchemaImpl.getInstance().getMatchingRule(\"" + ((MatchingRule)entry.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("  // Core Attribute Types");
        for (Map.Entry entry : attributeTypes.entrySet()) {
            System.out.println("  private static final AttributeType " + (String)entry.getKey() + " =");
            System.out.println("    CoreSchemaImpl.getInstance().getAttributeType(\"" + ((AttributeType)entry.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println("  // Core Object Classes");
        for (Map.Entry entry : objectClasses.entrySet()) {
            System.out.println("  private static final ObjectClass " + (String)entry.getKey() + " =");
            System.out.println("    CoreSchemaImpl.getInstance().getObjectClass(\"" + ((ObjectClass)entry.getValue()).getOID() + "\");");
        }
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("  // Prevent instantiation");
        System.out.println("  private CoreSchema()");
        System.out.println("  {");
        System.out.println("    // Nothing to do.");
        System.out.println("  }");
        System.out.println();
        System.out.println();
        System.out.println();
        System.out.println("  /**");
        System.out.println("   * Returns a reference to the singleton core schema.");
        System.out.println("   *");
        System.out.println("   * @return The core schema.");
        System.out.println("   */");
        System.out.println("  public static Schema getInstance()");
        System.out.println("  {");
        System.out.println("    return CoreSchemaImpl.getInstance();");
        System.out.println("  }");
        for (Map.Entry entry : syntaxes.entrySet()) {
            System.out.println();
            System.out.println();
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((Syntax)entry.getValue()).getDescription().replaceAll(" Syntax$", "") + " Syntax");
            System.out.println("  /**");
            System.out.println("   * Returns a reference to the " + description);
            System.out.println("   * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((Syntax)entry.getValue()).getOID()) + ".");
            System.out.println("   *");
            System.out.println("   * @return A reference to the " + description + ".");
            System.out.println("   */");
            System.out.println("  public static Syntax get" + GenerateCoreSchema.toJavaName((String)entry.getKey()) + "()");
            System.out.println("  {");
            System.out.println("    return " + (String)entry.getKey() + ";");
            System.out.println("  }");
        }
        for (Map.Entry entry : matchingRules.entrySet()) {
            System.out.println();
            System.out.println();
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)entry.getValue()).getNameOrOID());
            System.out.println("  /**");
            System.out.println("   * Returns a reference to the " + description + " Matching Rule");
            System.out.println("   * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((MatchingRule)entry.getValue()).getOID()) + ".");
            System.out.println("   *");
            System.out.println("   * @return A reference to the " + description + " Matching Rule.");
            System.out.println("   */");
            System.out.println("  public static MatchingRule get" + GenerateCoreSchema.toJavaName((String)entry.getKey()) + "()");
            System.out.println("  {");
            System.out.println("    return " + (String)entry.getKey() + ";");
            System.out.println("  }");
        }
        for (Map.Entry entry : attributeTypes.entrySet()) {
            System.out.println();
            System.out.println();
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((AttributeType)entry.getValue()).getNameOrOID());
            System.out.println("  /**");
            System.out.println("   * Returns a reference to the " + description + " Attribute Type");
            System.out.println("   * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((AttributeType)entry.getValue()).getOID()) + ".");
            System.out.println("   *");
            System.out.println("   * @return A reference to the " + description + " Attribute Type.");
            System.out.println("   */");
            System.out.println("  public static AttributeType get" + GenerateCoreSchema.toJavaName((String)entry.getKey()) + "()");
            System.out.println("  {");
            System.out.println("    return " + (String)entry.getKey() + ";");
            System.out.println("  }");
        }
        for (Map.Entry entry : objectClasses.entrySet()) {
            System.out.println();
            System.out.println();
            System.out.println();
            description = GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)entry.getValue()).getNameOrOID());
            System.out.println("  /**");
            System.out.println("   * Returns a reference to the " + description + " Object Class");
            System.out.println("   * which has the OID " + GenerateCoreSchema.toCodeJavaDoc(((ObjectClass)entry.getValue()).getOID()) + ".");
            System.out.println("   *");
            System.out.println("   * @return A reference to the " + description + " Object Class.");
            System.out.println("   */");
            System.out.println("  public static ObjectClass get" + GenerateCoreSchema.toJavaName((String)entry.getKey()) + "()");
            System.out.println("  {");
            System.out.println("    return " + (String)entry.getKey() + ";");
            System.out.println("  }");
        }
        System.out.println("}");
    }

    private static boolean isOpenDSOID(String oid) {
        return oid.startsWith("1.3.6.1.4.1.26027.1.");
    }

    private static String splitNameIntoWords(String name) {
        String splitName = name.replaceAll("([A-Z][a-z])", "_$1");
        splitName = splitName.replaceAll("([a-z])([A-Z])", "$1_$2");
        return splitName.toUpperCase(Locale.ENGLISH);
    }

    private static void testSplitNameIntoWords() {
        String[][] values;
        for (String[] test : values = new String[][]{{"oneTwoThree", "ONE_TWO_THREE"}, {"oneTWOThree", "ONE_TWO_THREE"}, {"oneX500Three", "ONE_X500_THREE"}, {"oneTwoX500", "ONE_TWO_X500"}, {"oneTwoX500", "ONE_TWO_X500"}, {"x500TwoThree", "X500_TWO_THREE"}}) {
            String expected;
            String actual = GenerateCoreSchema.splitNameIntoWords(test[0]);
            if (actual.equals(expected = test[1])) continue;
            System.out.println("Test Split Failure: " + test[0] + " -> " + actual + " != " + expected);
        }
    }

    private static String toCodeJavaDoc(String text) {
        return String.format("{@code %s}", text);
    }

    private static String toJavaName(String splitName) {
        StringBuilder builder = new StringBuilder();
        for (String word : splitName.split("_")) {
            if (ABBREVIATIONS.contains(word)) {
                builder.append(word);
                continue;
            }
            builder.append(word.charAt(0));
            if (word.length() <= 1) continue;
            builder.append(word.substring(1).toLowerCase(Locale.ENGLISH));
        }
        return builder.toString();
    }

    private GenerateCoreSchema() {
    }
}

