/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import org.forgerock.i18n.LocalizableMessageBuilder;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSyntaxImpl;
import org.forgerock.opendj.ldap.schema.GuideSyntaxImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaUtils;

final class EnhancedGuideSyntaxImpl
extends AbstractSyntaxImpl {
    EnhancedGuideSyntaxImpl() {
    }

    @Override
    public String getEqualityMatchingRule() {
        return "2.5.13.17";
    }

    @Override
    public String getName() {
        return "EnhancedGuide";
    }

    @Override
    public String getOrderingMatchingRule() {
        return "2.5.13.18";
    }

    @Override
    public boolean isHumanReadable() {
        return true;
    }

    @Override
    public boolean valueIsAcceptable(Schema schema, ByteSequence value, LocalizableMessageBuilder invalidReason) {
        String valueStr = StaticUtils.toLowerCase(value.toString());
        int sharpPos = valueStr.indexOf(35);
        if (sharpPos < 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SHARP1.get((Object)valueStr));
            return false;
        }
        String ocName = valueStr.substring(0, sharpPos).trim();
        int ocLength = ocName.length();
        if (ocLength == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_OC1.get((Object)valueStr));
            return false;
        }
        try {
            SchemaUtils.readOID(new SubstringReader(ocName.substring(ocLength)), schema.allowMalformedNamesAndOptions());
        }
        catch (DecodeException de) {
            invalidReason.append(de.getMessageObject());
            return false;
        }
        int lastSharpPos = valueStr.lastIndexOf(35);
        if (lastSharpPos == sharpPos) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_FINAL_SHARP.get((Object)valueStr));
            return false;
        }
        String scopeStr = valueStr.substring(lastSharpPos + 1).trim();
        if (!(scopeStr.equals("baseobject") || scopeStr.equals("onelevel") || scopeStr.equals("wholesubtree") || scopeStr.equals("subordinatesubtree"))) {
            if (scopeStr.length() == 0) {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_SCOPE.get((Object)valueStr));
            } else {
                invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_INVALID_SCOPE.get((Object)valueStr, (Object)scopeStr));
            }
            return false;
        }
        String criteria = valueStr.substring(sharpPos + 1, lastSharpPos).trim();
        int criteriaLength = criteria.length();
        if (criteriaLength == 0) {
            invalidReason.append(CoreMessages.ERR_ATTR_SYNTAX_ENHANCEDGUIDE_NO_CRITERIA.get((Object)valueStr));
            return false;
        }
        return GuideSyntaxImpl.criteriaIsValid(schema, criteria, valueStr, invalidReason);
    }
}

