/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StringPrepProfile;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractSubstringMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaConstants;

final class CaseExactSubstringMatchingRuleImpl
extends AbstractSubstringMatchingRuleImpl {
    CaseExactSubstringMatchingRuleImpl() {
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) {
        return this.normalize(true, value);
    }

    @Override
    ByteString normalizeSubString(Schema schema, ByteSequence value) throws DecodeException {
        return this.normalize(false, value);
    }

    private ByteString normalize(boolean trim, ByteSequence value) {
        StringBuilder buffer = new StringBuilder();
        StringPrepProfile.prepareUnicode(buffer, value, trim, false);
        int bufferLength = buffer.length();
        if (bufferLength == 0) {
            if (value.length() > 0) {
                return SchemaConstants.SINGLE_SPACE_VALUE;
            }
            return ByteString.empty();
        }
        for (int pos = bufferLength - 1; pos > 0; --pos) {
            if (buffer.charAt(pos) != ' ' || buffer.charAt(pos - 1) != ' ') continue;
            buffer.delete(pos, pos + 1);
        }
        return ByteString.valueOf(buffer.toString());
    }
}

