/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.schema.AbstractMatchingRuleImpl;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaConstants;

final class BooleanEqualityMatchingRuleImpl
extends AbstractMatchingRuleImpl {
    BooleanEqualityMatchingRuleImpl() {
    }

    @Override
    public ByteString normalizeAttributeValue(Schema schema, ByteSequence value) throws DecodeException {
        String valueString = value.toString().toUpperCase();
        if (valueString.equals("TRUE") || valueString.equals("YES") || valueString.equals("ON") || valueString.equals("1")) {
            return SchemaConstants.TRUE_VALUE;
        }
        if (valueString.equals("FALSE") || valueString.equals("NO") || valueString.equals("OFF") || valueString.equals("0")) {
            return SchemaConstants.FALSE_VALUE;
        }
        throw DecodeException.error(CoreMessages.WARN_ATTR_SYNTAX_ILLEGAL_BOOLEAN.get((Object)value.toString()));
    }
}

