/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.schema;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.schema.AttributeUsage;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.SchemaElement;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class AttributeType
extends SchemaElement
implements Comparable<AttributeType> {
    private final String approximateMatchingRuleOID;
    private final AttributeUsage attributeUsage;
    private final String definition;
    private final String equalityMatchingRuleOID;
    private final boolean isCollective;
    private final boolean isNoUserModification;
    private final boolean isObsolete;
    private final boolean isPlaceHolder;
    private final boolean isSingleValue;
    private final List<String> names;
    private final String oid;
    private final String orderingMatchingRuleOID;
    private final String substringMatchingRuleOID;
    private final String superiorTypeOID;
    private final String syntaxOID;
    private final boolean isObjectClassType;
    private final String normalizedName;
    private AttributeType superiorType;
    private MatchingRule equalityMatchingRule;
    private MatchingRule orderingMatchingRule;
    private MatchingRule substringMatchingRule;
    private MatchingRule approximateMatchingRule;
    private Syntax syntax;
    private boolean needsValidating = true;
    private boolean isValid = false;

    AttributeType(String oid, List<String> names, String description, boolean obsolete, String superiorType, String equalityMatchingRule, String orderingMatchingRule, String substringMatchingRule, String approximateMatchingRule, String syntax, boolean singleValue, boolean collective, boolean noUserModification, AttributeUsage attributeUsage, Map<String, List<String>> extraProperties, String definition) {
        super(description, extraProperties);
        Validator.ensureNotNull((Object)oid, names, (Object)description, (Object)attributeUsage);
        Validator.ensureTrue(superiorType != null || syntax != null, "superiorType and/or syntax must not be null");
        Validator.ensureNotNull(extraProperties);
        this.oid = oid;
        this.names = names;
        this.isObsolete = obsolete;
        this.superiorTypeOID = superiorType;
        this.equalityMatchingRuleOID = equalityMatchingRule;
        this.orderingMatchingRuleOID = orderingMatchingRule;
        this.substringMatchingRuleOID = substringMatchingRule;
        this.approximateMatchingRuleOID = approximateMatchingRule;
        this.syntaxOID = syntax;
        this.isSingleValue = singleValue;
        this.isCollective = collective;
        this.isNoUserModification = noUserModification;
        this.attributeUsage = attributeUsage;
        this.definition = definition != null ? definition : this.buildDefinition();
        this.isObjectClassType = oid.equals("2.5.4.0");
        this.isPlaceHolder = false;
        this.normalizedName = StaticUtils.toLowerCase(this.getNameOrOID());
    }

    AttributeType(Schema schema, String name) {
        super("", Collections.<String, List<String>>emptyMap());
        StringBuilder builder = new StringBuilder(name.length() + 4);
        StaticUtils.toLowerCase(name, builder);
        builder.append("-oid");
        this.oid = builder.toString();
        this.names = Collections.singletonList(name);
        this.isObsolete = false;
        this.superiorTypeOID = null;
        this.superiorType = null;
        this.equalityMatchingRule = schema.getDefaultMatchingRule();
        this.equalityMatchingRuleOID = this.equalityMatchingRule.getOID();
        this.orderingMatchingRuleOID = null;
        this.substringMatchingRuleOID = null;
        this.approximateMatchingRuleOID = null;
        this.syntax = schema.getDefaultSyntax();
        this.syntaxOID = this.syntax.getOID();
        this.isSingleValue = false;
        this.isCollective = false;
        this.isNoUserModification = false;
        this.attributeUsage = AttributeUsage.USER_APPLICATIONS;
        this.definition = this.buildDefinition();
        this.isObjectClassType = false;
        this.isPlaceHolder = true;
        this.normalizedName = StaticUtils.toLowerCase(this.getNameOrOID());
    }

    @Override
    public int compareTo(AttributeType type) {
        boolean typeIsOperational;
        if (this.isObjectClassType) {
            return type.isObjectClassType ? 0 : -1;
        }
        if (type.isObjectClassType) {
            return 1;
        }
        boolean isOperational = this.getUsage().isOperational();
        if (isOperational == (typeIsOperational = type.getUsage().isOperational())) {
            int tmp = this.normalizedName.compareTo(type.normalizedName);
            if (tmp == 0) {
                return this.oid.compareTo(type.oid);
            }
            return tmp;
        }
        return isOperational ? 1 : -1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AttributeType) {
            AttributeType other = (AttributeType)o;
            return this.oid.equals(other.oid);
        }
        return false;
    }

    public MatchingRule getApproximateMatchingRule() {
        return this.approximateMatchingRule;
    }

    public MatchingRule getEqualityMatchingRule() {
        return this.equalityMatchingRule;
    }

    public String getNameOrOID() {
        if (this.names.isEmpty()) {
            return this.oid;
        }
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getOID() {
        return this.oid;
    }

    public MatchingRule getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public MatchingRule getSubstringMatchingRule() {
        return this.substringMatchingRule;
    }

    public AttributeType getSuperiorType() {
        return this.superiorType;
    }

    public Syntax getSyntax() {
        return this.syntax;
    }

    public AttributeUsage getUsage() {
        return this.attributeUsage;
    }

    @Override
    public int hashCode() {
        return this.oid.hashCode();
    }

    public boolean hasName(String name) {
        for (String n : this.names) {
            if (!n.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public boolean hasNameOrOID(String value) {
        return this.hasName(value) || this.getOID().equals(value);
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public boolean isNoUserModification() {
        return this.isNoUserModification;
    }

    public boolean isObjectClass() {
        return this.isObjectClassType;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public boolean isOperational() {
        return this.attributeUsage.isOperational();
    }

    public boolean isPlaceHolder() {
        return this.isPlaceHolder;
    }

    public boolean isSingleValue() {
        return this.isSingleValue;
    }

    public boolean isSubTypeOf(AttributeType type) {
        AttributeType tmp = this;
        do {
            if (!tmp.matches(type)) continue;
            return true;
        } while ((tmp = tmp.getSuperiorType()) != null);
        return false;
    }

    public boolean isSuperTypeOf(AttributeType type) {
        return type.isSubTypeOf(this);
    }

    public boolean matches(AttributeType type) {
        if (this == type) {
            return true;
        }
        if (this.oid.equals(type.oid)) {
            return true;
        }
        if (this.isPlaceHolder != type.isPlaceHolder) {
            return this.isPlaceHolder ? type.hasName(this.normalizedName) : this.hasName(type.normalizedName);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.definition;
    }

    AttributeType duplicate() {
        return new AttributeType(this.oid, this.names, this.description, this.isObsolete, this.superiorTypeOID, this.equalityMatchingRuleOID, this.orderingMatchingRuleOID, this.substringMatchingRuleOID, this.approximateMatchingRuleOID, this.syntaxOID, this.isSingleValue, this.isCollective, this.isNoUserModification, this.attributeUsage, this.extraProperties, this.definition);
    }

    @Override
    void toStringContent(StringBuilder buffer) {
        buffer.append(this.oid);
        if (!this.names.isEmpty()) {
            Iterator<String> iterator = this.names.iterator();
            String firstName = iterator.next();
            if (iterator.hasNext()) {
                buffer.append(" NAME ( '");
                buffer.append(firstName);
                while (iterator.hasNext()) {
                    buffer.append("' '");
                    buffer.append(iterator.next());
                }
                buffer.append("' )");
            } else {
                buffer.append(" NAME '");
                buffer.append(firstName);
                buffer.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            buffer.append(" DESC '");
            buffer.append(this.description);
            buffer.append("'");
        }
        if (this.isObsolete) {
            buffer.append(" OBSOLETE");
        }
        if (this.superiorTypeOID != null) {
            buffer.append(" SUP ");
            buffer.append(this.superiorTypeOID);
        }
        if (this.equalityMatchingRuleOID != null) {
            buffer.append(" EQUALITY ");
            buffer.append(this.equalityMatchingRuleOID);
        }
        if (this.orderingMatchingRuleOID != null) {
            buffer.append(" ORDERING ");
            buffer.append(this.orderingMatchingRuleOID);
        }
        if (this.substringMatchingRuleOID != null) {
            buffer.append(" SUBSTR ");
            buffer.append(this.substringMatchingRuleOID);
        }
        if (this.syntaxOID != null) {
            buffer.append(" SYNTAX ");
            buffer.append(this.syntaxOID);
        }
        if (this.isSingleValue()) {
            buffer.append(" SINGLE-VALUE");
        }
        if (this.isCollective()) {
            buffer.append(" COLLECTIVE");
        }
        if (this.isNoUserModification()) {
            buffer.append(" NO-USER-MODIFICATION");
        }
        if (this.attributeUsage != null) {
            buffer.append(" USAGE ");
            buffer.append(this.attributeUsage.toString());
        }
        if (this.approximateMatchingRuleOID != null) {
            buffer.append(" ");
            buffer.append("X-APPROX");
            buffer.append(" '");
            buffer.append(this.approximateMatchingRuleOID);
            buffer.append("'");
        }
    }

    boolean validate(Schema schema, List<AttributeType> invalidSchemaElements, List<LocalizableMessage> warnings) {
        LocalizableMessage message;
        if (!this.needsValidating) {
            return this.isValid;
        }
        this.needsValidating = false;
        if (this.superiorTypeOID != null) {
            try {
                this.superiorType = schema.getAttributeType(this.superiorTypeOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message2 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUPERIOR_TYPE1.get((Object)this.getNameOrOID(), (Object)this.superiorTypeOID);
                this.failValidation(invalidSchemaElements, warnings, message2);
                return false;
            }
            if (!this.superiorType.validate(schema, invalidSchemaElements, warnings)) {
                LocalizableMessage message3 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_TYPE.get((Object)this.getNameOrOID(), (Object)this.superiorTypeOID);
                this.failValidation(invalidSchemaElements, warnings, message3);
                return false;
            }
            if (this.superiorType.getUsage() != this.getUsage()) {
                LocalizableMessage message4 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_INVALID_SUPERIOR_USAGE.get((Object)this.getNameOrOID(), (Object)this.getUsage().toString(), (Object)this.superiorType.getNameOrOID());
                this.failValidation(invalidSchemaElements, warnings, message4);
                return false;
            }
            if (this.superiorType.isCollective() != this.isCollective() && !this.isCollective()) {
                LocalizableMessage message5 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_NONCOLLECTIVE_FROM_COLLECTIVE.get((Object)this.getNameOrOID(), (Object)this.superiorType.getNameOrOID());
                this.failValidation(invalidSchemaElements, warnings, message5);
                return false;
            }
        }
        if (this.syntaxOID != null) {
            if (!schema.hasSyntax(this.syntaxOID)) {
                this.syntax = Schema.getCoreSchema().getSyntax(this.syntaxOID);
                message = CoreMessages.WARN_ATTR_TYPE_NOT_DEFINED1.get((Object)this.getNameOrOID(), (Object)this.syntaxOID, (Object)this.syntax.getOID());
                warnings.add(message);
            } else {
                this.syntax = schema.getSyntax(this.syntaxOID);
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getSyntax() != null) {
            this.syntax = this.getSuperiorType().getSyntax();
        }
        if (this.equalityMatchingRuleOID != null) {
            try {
                this.equalityMatchingRule = schema.getMatchingRule(this.equalityMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message6 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_EQUALITY_MR1.get((Object)this.getNameOrOID(), (Object)this.equalityMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message6);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getEqualityMatchingRule() != null) {
            this.equalityMatchingRule = this.getSuperiorType().getEqualityMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getEqualityMatchingRule() != null) {
            this.equalityMatchingRule = this.getSyntax().getEqualityMatchingRule();
        }
        if (this.orderingMatchingRuleOID != null) {
            try {
                this.orderingMatchingRule = schema.getMatchingRule(this.orderingMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message7 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_ORDERING_MR1.get((Object)this.getNameOrOID(), (Object)this.orderingMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message7);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getOrderingMatchingRule() != null) {
            this.orderingMatchingRule = this.getSuperiorType().getOrderingMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getOrderingMatchingRule() != null) {
            this.orderingMatchingRule = this.getSyntax().getOrderingMatchingRule();
        }
        if (this.substringMatchingRuleOID != null) {
            try {
                this.substringMatchingRule = schema.getMatchingRule(this.substringMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message8 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_SUBSTRING_MR1.get((Object)this.getNameOrOID(), (Object)this.substringMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message8);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getSubstringMatchingRule() != null) {
            this.substringMatchingRule = this.getSuperiorType().getSubstringMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getSubstringMatchingRule() != null) {
            this.substringMatchingRule = this.getSyntax().getSubstringMatchingRule();
        }
        if (this.approximateMatchingRuleOID != null) {
            try {
                this.approximateMatchingRule = schema.getMatchingRule(this.approximateMatchingRuleOID);
            }
            catch (UnknownSchemaElementException e) {
                LocalizableMessage message9 = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_UNKNOWN_APPROXIMATE_MR1.get((Object)this.getNameOrOID(), (Object)this.approximateMatchingRuleOID);
                this.failValidation(invalidSchemaElements, warnings, message9);
                return false;
            }
        } else if (this.getSuperiorType() != null && this.getSuperiorType().getApproximateMatchingRule() != null) {
            this.approximateMatchingRule = this.getSuperiorType().getApproximateMatchingRule();
        } else if (this.getSyntax() != null && this.getSyntax().getApproximateMatchingRule() != null) {
            this.approximateMatchingRule = this.getSyntax().getApproximateMatchingRule();
        }
        if (this.isCollective() && this.getUsage() != AttributeUsage.USER_APPLICATIONS) {
            message = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_COLLECTIVE_IS_OPERATIONAL.get((Object)this.getNameOrOID());
            warnings.add(message);
        }
        if (this.isNoUserModification() && this.getUsage() == AttributeUsage.USER_APPLICATIONS) {
            message = CoreMessages.WARN_ATTR_SYNTAX_ATTRTYPE_NO_USER_MOD_NOT_OPERATIONAL.get((Object)this.getNameOrOID());
            warnings.add(message);
        }
        this.isValid = true;
        return true;
    }

    private void failValidation(List<AttributeType> invalidSchemaElements, List<LocalizableMessage> warnings, LocalizableMessage message) {
        invalidSchemaElements.add(this);
        warnings.add(CoreMessages.ERR_ATTR_TYPE_VALIDATION_FAIL.get((Object)this.toString(), (Object)message));
    }
}

