/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import com.forgerock.opendj.util.Validator;
import java.util.LinkedList;
import java.util.List;
import org.forgerock.opendj.ldap.responses.AbstractResponseImpl;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

final class SearchResultReferenceImpl
extends AbstractResponseImpl<SearchResultReference>
implements SearchResultReference {
    private final List<String> uris = new LinkedList<String>();

    SearchResultReferenceImpl(SearchResultReference searchResultReference) {
        super(searchResultReference);
        this.uris.addAll(searchResultReference.getURIs());
    }

    SearchResultReferenceImpl(String uri) {
        this.addURI(uri);
    }

    @Override
    public SearchResultReference addURI(String uri) {
        Validator.ensureNotNull(uri);
        this.uris.add(uri);
        return this;
    }

    @Override
    public List<String> getURIs() {
        return this.uris;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("SearchResultReference(uris=");
        builder.append(this.getURIs());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    SearchResultReference getThis() {
        return this;
    }
}

