/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.responses;

import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.responses.AbstractResultImpl;
import org.forgerock.opendj.ldap.responses.BindResult;

final class BindResultImpl
extends AbstractResultImpl<BindResult>
implements BindResult {
    private ByteString credentials = null;

    BindResultImpl(BindResult bindResult) {
        super(bindResult);
        this.credentials = bindResult.getServerSASLCredentials();
    }

    BindResultImpl(ResultCode resultCode) {
        super(resultCode);
    }

    @Override
    public ByteString getServerSASLCredentials() {
        return this.credentials;
    }

    @Override
    public boolean isSASLBindInProgress() {
        ResultCode code = this.getResultCode();
        return code.equals(ResultCode.SASL_BIND_IN_PROGRESS);
    }

    @Override
    public BindResult setServerSASLCredentials(ByteString credentials) {
        this.credentials = credentials;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BindResult(resultCode=");
        builder.append(this.getResultCode());
        builder.append(", matchedDN=");
        builder.append(this.getMatchedDN());
        builder.append(", diagnosticMessage=");
        builder.append(this.getDiagnosticMessage());
        builder.append(", referrals=");
        builder.append(this.getReferralURIs());
        builder.append(", serverSASLCreds=");
        builder.append(this.getServerSASLCredentials() == null ? ByteString.empty() : this.getServerSASLCredentials());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    @Override
    BindResult getThis() {
        return this;
    }
}

