/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Collections2;
import java.util.Collections;
import java.util.List;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.Attributes;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Function;
import org.forgerock.opendj.ldap.Functions;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.ModificationType;
import org.forgerock.opendj.ldap.requests.AbstractUnmodifiableRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldif.ChangeRecordVisitor;

final class UnmodifiableModifyRequestImpl
extends AbstractUnmodifiableRequest<ModifyRequest>
implements ModifyRequest {
    UnmodifiableModifyRequestImpl(ModifyRequest impl) {
        super(impl);
    }

    @Override
    public <R, P> R accept(ChangeRecordVisitor<R, P> v, P p) {
        return v.visitChangeRecord(p, this);
    }

    @Override
    public ModifyRequest addModification(Modification modification) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModifyRequest addModification(ModificationType type, String attributeDescription, Object ... values) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Modification> getModifications() {
        Function<Modification, Modification, Void> function = new Function<Modification, Modification, Void>(){

            @Override
            public Modification apply(Modification value, Void p) {
                ModificationType type = value.getModificationType();
                Attribute attribute = Attributes.unmodifiableAttribute(value.getAttribute());
                return new Modification(type, attribute);
            }
        };
        List<Modification> unmodifiableModifications = Collections2.transformedList(((ModifyRequest)this.impl).getModifications(), function, Functions.identityFunction());
        return Collections.unmodifiableList(unmodifiableModifications);
    }

    @Override
    public DN getName() {
        return ((ModifyRequest)this.impl).getName();
    }

    @Override
    public ModifyRequest setName(DN dn) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ModifyRequest setName(String dn) {
        throw new UnsupportedOperationException();
    }
}

