/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.Validator;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.requests.StartTLSExtendedRequest;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Responses;

final class StartTLSExtendedRequestImpl
extends AbstractExtendedRequest<StartTLSExtendedRequest, ExtendedResult>
implements StartTLSExtendedRequest {
    private static final ExtendedResultDecoder<ExtendedResult> RESULT_DECODER = new ResultDecoder();
    private final List<String> enabledCipherSuites = new LinkedList<String>();
    private final List<String> enabledProtocols = new LinkedList<String>();
    private SSLContext sslContext;

    StartTLSExtendedRequestImpl(SSLContext sslContext) {
        Validator.ensureNotNull(sslContext);
        this.sslContext = sslContext;
    }

    StartTLSExtendedRequestImpl(StartTLSExtendedRequest startTLSExtendedRequest) {
        super(startTLSExtendedRequest);
        this.sslContext = startTLSExtendedRequest.getSSLContext();
        this.enabledCipherSuites.addAll(startTLSExtendedRequest.getEnabledCipherSuites());
        this.enabledProtocols.addAll(startTLSExtendedRequest.getEnabledProtocols());
    }

    private StartTLSExtendedRequestImpl() {
    }

    @Override
    public StartTLSExtendedRequest addEnabledCipherSuite(String ... suites) {
        for (String suite : suites) {
            this.enabledCipherSuites.add(Validator.ensureNotNull(suite));
        }
        return this;
    }

    @Override
    public StartTLSExtendedRequest addEnabledProtocol(String ... protocols) {
        for (String protocol : protocols) {
            this.enabledProtocols.add(Validator.ensureNotNull(protocol));
        }
        return this;
    }

    @Override
    public List<String> getEnabledCipherSuites() {
        return this.enabledCipherSuites;
    }

    @Override
    public List<String> getEnabledProtocols() {
        return this.enabledProtocols;
    }

    @Override
    public String getOID() {
        return "1.3.6.1.4.1.1466.20037";
    }

    @Override
    public ExtendedResultDecoder<ExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public StartTLSExtendedRequest setSSLContext(SSLContext sslContext) {
        Validator.ensureNotNull(sslContext);
        this.sslContext = sslContext;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StartTLSExtendedRequest(requestName=");
        builder.append(this.getOID());
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<ExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public ExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            return result;
        }

        @Override
        public GenericExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<StartTLSExtendedRequest, ExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public StartTLSExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            StartTLSExtendedRequestImpl newRequest = new StartTLSExtendedRequestImpl();
            for (Control control : request.getControls()) {
                newRequest.addControl(control);
            }
            return newRequest;
        }
    }
}

