/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.requests;

import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbstractExtendedRequest;
import org.forgerock.opendj.ldap.requests.CancelExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequestDecoder;
import org.forgerock.opendj.ldap.responses.AbstractExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.ExtendedResultDecoder;
import org.forgerock.opendj.ldap.responses.Responses;

final class CancelExtendedRequestImpl
extends AbstractExtendedRequest<CancelExtendedRequest, ExtendedResult>
implements CancelExtendedRequest {
    private static final ExtendedResultDecoder<ExtendedResult> RESULT_DECODER = new ResultDecoder();
    private int requestID;

    CancelExtendedRequestImpl(CancelExtendedRequest cancelExtendedRequest) {
        super(cancelExtendedRequest);
        this.requestID = cancelExtendedRequest.getRequestID();
    }

    CancelExtendedRequestImpl(int requestID) {
        this.requestID = requestID;
    }

    @Override
    public String getOID() {
        return "1.3.6.1.1.8";
    }

    @Override
    public int getRequestID() {
        return this.requestID;
    }

    @Override
    public ExtendedResultDecoder<ExtendedResult> getResultDecoder() {
        return RESULT_DECODER;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder(6);
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.requestID);
            writer.writeEndSequence();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return buffer.toByteString();
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public CancelExtendedRequest setRequestID(int id) {
        this.requestID = id;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("CancelExtendedRequest(requestName=");
        builder.append(this.getOID());
        builder.append(", requestID=");
        builder.append(this.requestID);
        builder.append(", controls=");
        builder.append(this.getControls());
        builder.append(")");
        return builder.toString();
    }

    private static final class ResultDecoder
    extends AbstractExtendedResultDecoder<ExtendedResult> {
        private ResultDecoder() {
        }

        @Override
        public ExtendedResult decodeExtendedResult(ExtendedResult result, DecodeOptions options) throws DecodeException {
            return result;
        }

        @Override
        public ExtendedResult newExtendedErrorResult(ResultCode resultCode, String matchedDN, String diagnosticMessage) {
            return Responses.newGenericExtendedResult(resultCode).setMatchedDN(matchedDN).setDiagnosticMessage(diagnosticMessage);
        }
    }

    static final class RequestDecoder
    implements ExtendedRequestDecoder<CancelExtendedRequest, ExtendedResult> {
        RequestDecoder() {
        }

        @Override
        public CancelExtendedRequest decodeExtendedRequest(ExtendedRequest<?> request, DecodeOptions options) throws DecodeException {
            ByteString requestValue = request.getValue();
            if (requestValue == null || requestValue.length() <= 0) {
                throw DecodeException.error(CoreMessages.ERR_EXTOP_CANCEL_NO_REQUEST_VALUE.get());
            }
            try {
                ASN1Reader reader = ASN1.getReader(requestValue);
                reader.readStartSequence();
                int idToCancel = (int)reader.readInteger();
                reader.readEndSequence();
                CancelExtendedRequestImpl newRequest = new CancelExtendedRequestImpl(idToCancel);
                for (Control control : request.getControls()) {
                    newRequest.addControl(control);
                }
                return newRequest;
            }
            catch (IOException e) {
                LocalizableMessage message = CoreMessages.ERR_EXTOP_CANCEL_CANNOT_DECODE_REQUEST_VALUE.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }
    }
}

