/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class VirtualListViewRequestControl
implements Control {
    public static final String OID = "2.16.840.1.113730.3.4.9";
    public static final ControlDecoder<VirtualListViewRequestControl> DECODER = new ControlDecoder<VirtualListViewRequestControl>(){

        @Override
        public VirtualListViewRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Validator.ensureNotNull(control);
            if (control instanceof VirtualListViewRequestControl) {
                return (VirtualListViewRequestControl)control;
            }
            if (!control.getOID().equals(VirtualListViewRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_VLVREQ_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)VirtualListViewRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.INFO_VLVREQ_CONTROL_NO_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                reader.readStartSequence();
                int beforeCount = (int)reader.readInteger();
                int afterCount = (int)reader.readInteger();
                int offset = -1;
                int contentCount = -1;
                ByteString assertionValue = null;
                byte targetType = reader.peekType();
                switch (targetType) {
                    case -96: {
                        reader.readStartSequence();
                        offset = (int)reader.readInteger();
                        contentCount = (int)reader.readInteger();
                        reader.readEndSequence();
                        break;
                    }
                    case -127: {
                        assertionValue = reader.readOctetString();
                        break;
                    }
                    default: {
                        LocalizableMessage message = CoreMessages.INFO_VLVREQ_CONTROL_INVALID_TARGET_TYPE.get((Object)StaticUtils.byteToHex(targetType));
                        throw DecodeException.error(message);
                    }
                }
                ByteString contextID = null;
                if (reader.hasNextElement()) {
                    contextID = reader.readOctetString();
                }
                return new VirtualListViewRequestControl(control.isCritical(), beforeCount, afterCount, contentCount, offset, assertionValue, contextID);
            }
            catch (IOException e) {
                LocalizableMessage message = CoreMessages.INFO_VLVREQ_CONTROL_CANNOT_DECODE_VALUE.get((Object)StaticUtils.getExceptionMessage(e));
                throw DecodeException.error(message, e);
            }
        }

        @Override
        public String getOID() {
            return VirtualListViewRequestControl.OID;
        }
    };
    private static final byte TYPE_TARGET_BYOFFSET = -96;
    private static final byte TYPE_TARGET_GREATERTHANOREQUAL = -127;
    private final int beforeCount;
    private final int afterCount;
    private final ByteString contextID;
    private final boolean isCritical;
    private final int contentCount;
    private final int offset;
    private final ByteString assertionValue;

    public static VirtualListViewRequestControl newAssertionControl(boolean isCritical, ByteString assertionValue, int beforeCount, int afterCount, ByteString contextID) {
        Validator.ensureNotNull(assertionValue);
        Validator.ensureTrue(beforeCount >= 0, "beforeCount is less than 0");
        Validator.ensureTrue(afterCount >= 0, "afterCount is less than 0");
        return new VirtualListViewRequestControl(isCritical, beforeCount, afterCount, -1, -1, assertionValue, contextID);
    }

    public static VirtualListViewRequestControl newOffsetControl(boolean isCritical, int offset, int contentCount, int beforeCount, int afterCount, ByteString contextID) {
        Validator.ensureTrue(beforeCount >= 0, "beforeCount is less than 0");
        Validator.ensureTrue(afterCount >= 0, "afterCount is less than 0");
        Validator.ensureTrue(offset > 0, "offset is less than 1");
        Validator.ensureTrue(contentCount >= 0, "contentCount is less than 0");
        return new VirtualListViewRequestControl(isCritical, beforeCount, afterCount, contentCount, offset, null, contextID);
    }

    private VirtualListViewRequestControl(boolean isCritical, int beforeCount, int afterCount, int contentCount, int offset, ByteString assertionValue, ByteString contextID) {
        this.isCritical = isCritical;
        this.beforeCount = beforeCount;
        this.afterCount = afterCount;
        this.contentCount = contentCount;
        this.offset = offset;
        this.assertionValue = assertionValue;
        this.contextID = contextID;
    }

    public int getAfterCount() {
        return this.afterCount;
    }

    public ByteString getAssertionValue() {
        return this.assertionValue;
    }

    public String getAssertionValueAsString() {
        return this.assertionValue != null ? this.assertionValue.toString() : null;
    }

    public int getBeforeCount() {
        return this.beforeCount;
    }

    public int getContentCount() {
        return this.contentCount;
    }

    public ByteString getContextID() {
        return this.contextID;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            writer.writeStartSequence();
            writer.writeInteger(this.beforeCount);
            writer.writeInteger(this.afterCount);
            if (this.hasTargetOffset()) {
                writer.writeStartSequence((byte)-96);
                writer.writeInteger(this.offset);
                writer.writeInteger(this.contentCount);
                writer.writeEndSequence();
            } else {
                writer.writeOctetString((byte)-127, this.assertionValue);
            }
            if (this.contextID != null) {
                writer.writeOctetString(this.contextID);
            }
            writer.writeEndSequence();
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public boolean hasTargetOffset() {
        return this.assertionValue == null;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("VirtualListViewRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", beforeCount=");
        builder.append(this.beforeCount);
        builder.append(", afterCount=");
        builder.append(this.afterCount);
        if (this.hasTargetOffset()) {
            builder.append(", offset=");
            builder.append(this.offset);
            builder.append(", contentCount=");
            builder.append(this.contentCount);
        } else {
            builder.append(", greaterThanOrEqual=");
            builder.append(this.assertionValue);
        }
        if (this.contextID != null) {
            builder.append(", contextID=");
            builder.append(this.contextID);
        }
        builder.append(")");
        return builder.toString();
    }
}

