/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.ldap.LDAPUtils;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.asn1.ASN1;
import org.forgerock.opendj.asn1.ASN1Reader;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ByteStringBuilder;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.Entries;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;

public final class PreReadResponseControl
implements Control {
    public static final String OID = "1.3.6.1.1.13.1";
    public static final ControlDecoder<PreReadResponseControl> DECODER = new ControlDecoder<PreReadResponseControl>(){

        @Override
        public PreReadResponseControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            SearchResultEntry searchEntry;
            Validator.ensureNotNull(control);
            if (control instanceof PreReadResponseControl) {
                return (PreReadResponseControl)control;
            }
            if (!control.getOID().equals(PreReadResponseControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_PREREAD_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)PreReadResponseControl.OID);
                throw DecodeException.error(message);
            }
            if (!control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_PREREADRESP_NO_CONTROL_VALUE.get();
                throw DecodeException.error(message);
            }
            ASN1Reader reader = ASN1.getReader(control.getValue());
            try {
                searchEntry = LDAPUtils.decodeSearchResultEntry(reader, options);
            }
            catch (IOException le) {
                StaticUtils.DEBUG_LOG.throwing("PreReadResponseControl", "decodeControl", le);
                LocalizableMessage message = CoreMessages.ERR_PREREADRESP_CANNOT_DECODE_VALUE.get((Object)le.getMessage());
                throw DecodeException.error(message, le);
            }
            return new PreReadResponseControl(control.isCritical(), Entries.unmodifiableEntry(searchEntry));
        }

        @Override
        public String getOID() {
            return PreReadResponseControl.OID;
        }
    };
    private final Entry entry;
    private final boolean isCritical;

    public static PreReadResponseControl newControl(Entry entry) {
        return new PreReadResponseControl(false, Entries.unmodifiableEntry(entry));
    }

    private PreReadResponseControl(boolean isCritical, Entry entry) {
        this.isCritical = isCritical;
        this.entry = entry;
    }

    public Entry getEntry() {
        return this.entry;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        ByteStringBuilder buffer = new ByteStringBuilder();
        ASN1Writer writer = ASN1.getWriter(buffer);
        try {
            LDAPUtils.encodeSearchResultEntry(writer, Responses.newSearchResultEntry(this.entry));
            return buffer.toByteString();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PreReadResponseControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(", entry=");
        builder.append(this.entry);
        builder.append(")");
        return builder.toString();
    }
}

