/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.AttributeDescription;
import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;

public final class SortKey {
    private final String attributeDescription;
    private final String orderingMatchingRule;
    private final boolean isReverseOrder;

    public static Comparator<Entry> comparator(Collection<SortKey> keys) {
        return SortKey.comparator(Schema.getDefaultSchema(), keys);
    }

    public static Comparator<Entry> comparator(Schema schema, Collection<SortKey> keys) {
        Validator.ensureNotNull((Object)schema, keys);
        Validator.ensureTrue(!keys.isEmpty(), "keys must not be empty");
        ArrayList<Comparator<Entry>> comparators = new ArrayList<Comparator<Entry>>(keys.size());
        for (SortKey key : keys) {
            comparators.add(key.comparator(schema));
        }
        return new CompositeEntryComparator(comparators);
    }

    public static Comparator<Entry> comparator(Schema schema, SortKey ... keys) {
        return SortKey.comparator(schema, Arrays.asList(keys));
    }

    public static Comparator<Entry> comparator(SortKey ... keys) {
        return SortKey.comparator(Schema.getDefaultSchema(), keys);
    }

    public static Comparator<Entry> comparator(String sortKeys) {
        Validator.ensureNotNull(sortKeys);
        LinkedList<Comparator<Entry>> comparators = new LinkedList<Comparator<Entry>>();
        StringTokenizer tokenizer = new StringTokenizer(sortKeys, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            comparators.add(SortKey.valueOf(token).comparator());
        }
        if (comparators.isEmpty()) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_SORT_KEYS.get((Object)sortKeys);
            throw new LocalizedIllegalArgumentException(message);
        }
        return new CompositeEntryComparator(comparators);
    }

    public static final SortKey valueOf(String sortKey) {
        Validator.ensureNotNull(sortKey);
        boolean reverseOrder = false;
        if (sortKey.startsWith("-")) {
            reverseOrder = true;
            sortKey = sortKey.substring(1);
        } else if (sortKey.startsWith("+")) {
            sortKey = sortKey.substring(1);
        }
        int colonPos = sortKey.indexOf(58);
        if (colonPos < 0) {
            if (sortKey.length() == 0) {
                LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_ATTR_NAME.get((Object)sortKey);
                throw new LocalizedIllegalArgumentException(message);
            }
            return new SortKey(sortKey, reverseOrder, null);
        }
        if (colonPos == 0) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_ATTR_NAME.get((Object)sortKey);
            throw new LocalizedIllegalArgumentException(message);
        }
        if (colonPos == sortKey.length() - 1) {
            LocalizableMessage message = CoreMessages.ERR_SORT_KEY_NO_MATCHING_RULE.get((Object)sortKey);
            throw new LocalizedIllegalArgumentException(message);
        }
        String attrName = sortKey.substring(0, colonPos);
        String ruleID = sortKey.substring(colonPos + 1);
        return new SortKey(attrName, reverseOrder, ruleID);
    }

    public SortKey(AttributeDescription attributeDescription, boolean isReverseOrder, MatchingRule orderingMatchingRule) {
        Validator.ensureNotNull(attributeDescription);
        this.attributeDescription = attributeDescription.toString();
        this.orderingMatchingRule = orderingMatchingRule != null ? orderingMatchingRule.getNameOrOID() : null;
        this.isReverseOrder = isReverseOrder;
    }

    public SortKey(String attributeDescription) {
        this(attributeDescription, false, null);
    }

    public SortKey(String attributeDescription, boolean isReverseOrder) {
        this(attributeDescription, isReverseOrder, null);
    }

    public SortKey(String attributeDescription, boolean isReverseOrder, String orderingMatchingRule) {
        Validator.ensureNotNull(attributeDescription);
        this.attributeDescription = attributeDescription;
        this.orderingMatchingRule = orderingMatchingRule;
        this.isReverseOrder = isReverseOrder;
    }

    public Comparator<Entry> comparator() {
        return this.comparator(Schema.getDefaultSchema());
    }

    public Comparator<Entry> comparator(Schema schema) {
        MatchingRule mrule;
        Validator.ensureNotNull(schema);
        AttributeDescription ad = AttributeDescription.valueOf(this.attributeDescription, schema);
        if (this.orderingMatchingRule != null) {
            mrule = schema.getMatchingRule(this.orderingMatchingRule);
            if (mrule == null) {
                LocalizableMessage message = CoreMessages.ERR_SORT_KEY_MRULE_NOT_FOUND.get((Object)this.toString(), (Object)this.orderingMatchingRule);
                throw new LocalizedIllegalArgumentException(message);
            }
        } else {
            mrule = ad.getAttributeType().getOrderingMatchingRule();
            if (mrule == null) {
                LocalizableMessage message = CoreMessages.ERR_SORT_KEY_DEFAULT_MRULE_NOT_FOUND.get((Object)this.toString(), (Object)this.attributeDescription);
                throw new LocalizedIllegalArgumentException(message);
            }
        }
        return new EntryComparator(ad, mrule, this.isReverseOrder);
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public String getOrderingMatchingRule() {
        return this.orderingMatchingRule;
    }

    public boolean isReverseOrder() {
        return this.isReverseOrder;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isReverseOrder) {
            builder.append('-');
        }
        builder.append(this.attributeDescription);
        if (this.orderingMatchingRule != null) {
            builder.append(':');
            builder.append(this.orderingMatchingRule);
        }
        return builder.toString();
    }

    private static final class EntryComparator
    implements Comparator<Entry> {
        private final AttributeDescription attributeDescription;
        private final MatchingRule matchingRule;
        private final Comparator<ByteSequence> valueComparator;
        private final boolean isReverseOrder;

        private EntryComparator(AttributeDescription attributeDescription, MatchingRule matchingRule, boolean isReverseOrder) {
            this.attributeDescription = attributeDescription;
            this.matchingRule = matchingRule;
            this.valueComparator = matchingRule.comparator();
            this.isReverseOrder = isReverseOrder;
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            ByteString lowestNormalizedValue1 = null;
            for (Attribute attribute : entry1.getAllAttributes(this.attributeDescription)) {
                for (ByteString value : attribute) {
                    try {
                        ByteString tmp = this.matchingRule.normalizeAttributeValue(value);
                        if (lowestNormalizedValue1 == null) {
                            lowestNormalizedValue1 = tmp;
                            continue;
                        }
                        if (this.valueComparator.compare(tmp, lowestNormalizedValue1) >= 0) continue;
                        lowestNormalizedValue1 = tmp;
                    }
                    catch (DecodeException tmp) {}
                }
            }
            ByteString lowestNormalizedValue2 = null;
            for (Attribute attribute : entry2.getAllAttributes(this.attributeDescription)) {
                for (ByteString value : attribute) {
                    try {
                        ByteString tmp = this.matchingRule.normalizeAttributeValue(value);
                        if (lowestNormalizedValue2 == null) {
                            lowestNormalizedValue2 = tmp;
                            continue;
                        }
                        if (this.valueComparator.compare(tmp, lowestNormalizedValue2) >= 0) continue;
                        lowestNormalizedValue2 = tmp;
                    }
                    catch (DecodeException decodeException) {}
                }
            }
            if (lowestNormalizedValue1 == null) {
                return lowestNormalizedValue2 != null ? 1 : 0;
            }
            if (lowestNormalizedValue2 == null) {
                return -1;
            }
            if (this.isReverseOrder) {
                return this.valueComparator.compare(lowestNormalizedValue2, lowestNormalizedValue1);
            }
            return this.valueComparator.compare(lowestNormalizedValue1, lowestNormalizedValue2);
        }
    }

    private static final class CompositeEntryComparator
    implements Comparator<Entry> {
        private final List<Comparator<Entry>> comparators;

        private CompositeEntryComparator(List<Comparator<Entry>> comparators) {
            this.comparators = comparators;
        }

        @Override
        public int compare(Entry entry1, Entry entry2) {
            for (Comparator<Entry> comparator : this.comparators) {
                int result = comparator.compare(entry1, entry2);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }
    }
}

