/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ModificationType;

public final class Modification {
    private final ModificationType modificationType;
    private final Attribute attribute;

    public Modification(ModificationType modificationType, Attribute attribute) {
        Validator.ensureNotNull((Object)modificationType, (Object)attribute);
        this.modificationType = modificationType;
        this.attribute = attribute;
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public ModificationType getModificationType() {
        return this.modificationType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Modification(modificationType=");
        builder.append(this.modificationType);
        builder.append(", attributeDescription=");
        builder.append(this.attribute.getAttributeDescriptionAsString());
        builder.append(", attributeValues={");
        boolean firstValue = true;
        for (ByteString value : this.attribute) {
            if (!firstValue) {
                builder.append(", ");
            }
            builder.append(value);
            firstValue = false;
        }
        builder.append("})");
        return builder.toString();
    }
}

