/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPListenerImpl;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListenerOptions;
import org.forgerock.opendj.ldap.ServerConnectionFactory;

public final class LDAPListener
implements Closeable {
    private final LDAPListenerImpl impl;

    public LDAPListener(int port, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(port, factory, new LDAPListenerOptions());
    }

    public LDAPListener(int port, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        Validator.ensureNotNull(factory, (Object)options);
        InetSocketAddress address = new InetSocketAddress(port);
        this.impl = new LDAPListenerImpl(address, factory, options);
    }

    @Deprecated
    public LDAPListener(SocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this((InetSocketAddress)address, factory, new LDAPListenerOptions());
    }

    public LDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(address, factory, new LDAPListenerOptions());
    }

    @Deprecated
    public LDAPListener(SocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        this((InetSocketAddress)address, factory, options);
    }

    public LDAPListener(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        Validator.ensureNotNull((Object)address, factory, (Object)options);
        this.impl = new LDAPListenerImpl(address, factory, options);
    }

    public LDAPListener(String host, int port, ServerConnectionFactory<LDAPClientContext, Integer> factory) throws IOException {
        this(host, port, factory, new LDAPListenerOptions());
    }

    public LDAPListener(String host, int port, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        Validator.ensureNotNull((Object)host, factory, (Object)options);
        InetSocketAddress address = new InetSocketAddress(host, port);
        this.impl = new LDAPListenerImpl(address, factory, options);
    }

    @Override
    public void close() {
        this.impl.close();
    }

    public InetAddress getAddress() {
        return this.getInetSocketAddress().getAddress();
    }

    @Deprecated
    public String getHostname() {
        return this.getHostName();
    }

    public String getHostName() {
        return StaticUtils.getHostName(this.getInetSocketAddress());
    }

    public int getPort() {
        return this.getInetSocketAddress().getPort();
    }

    public SocketAddress getSocketAddress() {
        return this.getInetSocketAddress();
    }

    private InetSocketAddress getInetSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public String toString() {
        return this.impl.toString();
    }
}

