/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPConnectionFactoryImpl;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.LDAPOptions;
import org.forgerock.opendj.ldap.ResultHandler;

public final class LDAPConnectionFactory
implements ConnectionFactory {
    private final LDAPConnectionFactoryImpl impl;

    @Deprecated
    public LDAPConnectionFactory(SocketAddress address) {
        this((InetSocketAddress)address, new LDAPOptions());
    }

    @Deprecated
    public LDAPConnectionFactory(SocketAddress address, LDAPOptions options) {
        this((InetSocketAddress)address, options);
    }

    @Deprecated
    public LDAPConnectionFactory(InetSocketAddress address) {
        this(address, new LDAPOptions());
    }

    @Deprecated
    public LDAPConnectionFactory(InetSocketAddress address, LDAPOptions options) {
        Validator.ensureNotNull((Object)address, (Object)options);
        this.impl = new LDAPConnectionFactoryImpl(address, options);
    }

    public LDAPConnectionFactory(String host, int port) {
        this(host, port, new LDAPOptions());
    }

    public LDAPConnectionFactory(String host, int port, LDAPOptions options) {
        Validator.ensureNotNull((Object)host, (Object)options);
        this.impl = new LDAPConnectionFactoryImpl(host, port, options);
    }

    public InetAddress getAddress() {
        return this.getInetSocketAddress().getAddress();
    }

    @Override
    public void close() {
        this.impl.close();
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        return this.impl.getConnectionAsync(handler);
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        return this.impl.getConnection();
    }

    @Deprecated
    public String getHostname() {
        return this.getHostName();
    }

    public String getHostName() {
        return StaticUtils.getHostName(this.getInetSocketAddress());
    }

    public int getPort() {
        return this.getInetSocketAddress().getPort();
    }

    public SocketAddress getSocketAddress() {
        return this.getInetSocketAddress();
    }

    private InetSocketAddress getInetSocketAddress() {
        return this.impl.getSocketAddress();
    }

    public String toString() {
        return this.impl.toString();
    }
}

