/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.InternalConnection;
import com.forgerock.opendj.util.CompletedFutureResult;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.ServerConnectionFactory;

final class InternalConnectionFactory<C>
implements ConnectionFactory {
    private final ServerConnectionFactory<C, Integer> factory;
    private final C clientContext;

    InternalConnectionFactory(ServerConnectionFactory<C, Integer> factory, C clientContext) {
        this.factory = factory;
        this.clientContext = clientContext;
    }

    @Override
    public void close() {
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        ServerConnection<Integer> serverConnection = this.factory.handleAccept(this.clientContext);
        return new InternalConnection(serverConnection);
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        ServerConnection<Integer> serverConnection;
        try {
            serverConnection = this.factory.handleAccept(this.clientContext);
        }
        catch (ErrorResultException e) {
            if (handler != null) {
                handler.handleErrorResult(e);
            }
            return new CompletedFutureResult<ErrorResultException>(e);
        }
        InternalConnection connection = new InternalConnection(serverConnection);
        if (handler != null) {
            handler.handleResult(connection);
        }
        return new CompletedFutureResult<Connection>(connection);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("InternalConnectionFactory(");
        builder.append(String.valueOf(this.clientContext));
        builder.append(',');
        builder.append(String.valueOf(this.factory));
        builder.append(')');
        return builder.toString();
    }
}

