/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.ConnectionState;
import com.forgerock.opendj.util.AsynchronousFutureResult;
import com.forgerock.opendj.util.CompletedFutureResult;
import com.forgerock.opendj.util.FutureResultTransformer;
import com.forgerock.opendj.util.RecursiveFutureResult;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.TimeSource;
import com.forgerock.opendj.util.Validator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.AbstractAsynchronousConnection;
import org.forgerock.opendj.ldap.CancelledResultException;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionException;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.TimeoutResultException;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Requests;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

final class HeartBeatConnectionFactory
implements ConnectionFactory {
    private static final SearchRequest DEFAULT_SEARCH = Requests.newSearchRequest("", SearchScope.BASE_OBJECT, "(objectClass=*)", "1.1");
    TimeSource timeSource = TimeSource.DEFAULT;
    private final Runnable checkHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            for (ConnectionImpl connection : HeartBeatConnectionFactory.this.getValidConnections()) {
                connection.checkForHeartBeat();
            }
        }
    };
    private final ConnectionFactory factory;
    private ScheduledFuture<?> heartBeatFuture;
    private final SearchRequest heartBeatRequest;
    private final long interval;
    private final TimeUnit intervalUnit;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final long minDelayMS;
    private final AtomicInteger referenceCount = new AtomicInteger(1);
    private final ReferenceCountedObject.Reference scheduler;
    private final Runnable sendHeartBeatRunnable = new Runnable(){

        @Override
        public void run() {
            boolean heartBeatSent = false;
            for (ConnectionImpl connection : HeartBeatConnectionFactory.this.getValidConnections()) {
                heartBeatSent |= connection.sendHeartBeat();
            }
            if (heartBeatSent) {
                ((ScheduledExecutorService)HeartBeatConnectionFactory.this.scheduler.get()).schedule(HeartBeatConnectionFactory.this.checkHeartBeatRunnable, HeartBeatConnectionFactory.this.timeoutMS, TimeUnit.MILLISECONDS);
            }
        }
    };
    private final long timeoutMS;
    private final List<ConnectionImpl> validConnections = new LinkedList<ConnectionImpl>();

    HeartBeatConnectionFactory(ConnectionFactory factory, long interval, long timeout, TimeUnit unit, SearchRequest heartBeat, ScheduledExecutorService scheduler) {
        Validator.ensureNotNull((Object)factory, (Object)unit);
        Validator.ensureTrue(interval >= 0L, "negative interval");
        Validator.ensureTrue(timeout >= 0L, "negative timeout");
        this.heartBeatRequest = heartBeat != null ? heartBeat : DEFAULT_SEARCH;
        this.interval = interval;
        this.intervalUnit = unit;
        this.factory = factory;
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(scheduler);
        this.timeoutMS = unit.toMillis(timeout);
        this.minDelayMS = unit.toMillis(interval) / 2L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            List<ConnectionImpl> list = this.validConnections;
            synchronized (list) {
                if (!this.validConnections.isEmpty() && StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("HeartbeatConnectionFactory '%s' is closing while %d active connections remain", this.toString(), this.validConnections.size()));
                }
            }
            this.releaseScheduler();
            this.factory.close();
        }
    }

    private void releaseScheduler() {
        if (this.referenceCount.decrementAndGet() == 0) {
            this.scheduler.release();
        }
    }

    private void acquireScheduler() {
        this.referenceCount.incrementAndGet();
        if (this.isClosed.get()) {
            this.releaseScheduler();
            throw new IllegalStateException("Attempted to get a connection after factory close");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public Connection getConnection() throws ErrorResultException {
        this.acquireScheduler();
        boolean succeeded = false;
        try {
            Connection connection = this.factory.getConnection();
            try {
                connection.searchAsync(this.heartBeatRequest, null, null).get(this.timeoutMS, TimeUnit.MILLISECONDS);
                succeeded = true;
                Connection connection2 = this.adaptConnection(connection);
                return connection2;
            }
            catch (Exception e) {
                throw this.adaptHeartBeatError(e);
            }
            finally {
                if (!succeeded) {
                    connection.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (!succeeded) {
                this.releaseScheduler();
            }
        }
    }

    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        this.acquireScheduler();
        ConnectionFutureResultImpl compositeFuture = new ConnectionFutureResultImpl(handler);
        FutureResult<Connection> connectionFuture = this.factory.getConnectionAsync(compositeFuture.futureConnectionResult);
        compositeFuture.futureConnectionResult.setFutureResult(connectionFuture);
        return compositeFuture.futureSearchResult;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HeartBeatConnectionFactory(");
        builder.append(String.valueOf(this.factory));
        builder.append(')');
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Connection adaptConnection(Connection connection) {
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            ConnectionImpl heartBeatConnection = new ConnectionImpl(connection);
            if (this.validConnections.isEmpty()) {
                this.heartBeatFuture = ((ScheduledExecutorService)this.scheduler.get()).scheduleWithFixedDelay(this.sendHeartBeatRunnable, 0L, this.interval, this.intervalUnit);
            }
            this.validConnections.add(heartBeatConnection);
            return heartBeatConnection;
        }
    }

    private ErrorResultException adaptHeartBeatError(Exception error) {
        if (error instanceof ConnectionException) {
            return (ErrorResultException)error;
        }
        if (error instanceof TimeoutResultException || error instanceof TimeoutException) {
            return this.newHeartBeatTimeoutError();
        }
        if (error instanceof InterruptedException) {
            return ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, error);
        }
        return ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_SERVER_DOWN, (CharSequence)CoreMessages.HBCF_HEARTBEAT_FAILED.get(), (Throwable)error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionImpl[] getValidConnections() {
        ConnectionImpl[] tmp;
        List<ConnectionImpl> list = this.validConnections;
        synchronized (list) {
            tmp = this.validConnections.toArray(new ConnectionImpl[0]);
        }
        return tmp;
    }

    private ErrorResultException newHeartBeatTimeoutError() {
        return ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_SERVER_DOWN, (CharSequence)CoreMessages.HBCF_HEARTBEAT_TIMEOUT.get((Object)this.timeoutMS));
    }

    private static final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int LOCKED_EXCLUSIVELY = -1;
        private static final long serialVersionUID = -3590428415442668336L;
        private static final int UNLOCKED = 0;

        private Sync() {
        }

        @Override
        protected boolean isHeldExclusively() {
            return this.getState() == -1;
        }

        boolean isHeld() {
            return this.getState() != 0;
        }

        @Override
        protected boolean tryAcquire(int ignored) {
            if (this.compareAndSetState(0, -1)) {
                this.setExclusiveOwnerThread(Thread.currentThread());
                return true;
            }
            return false;
        }

        @Override
        protected int tryAcquireShared(int readers) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != -1) continue;
                return -1;
            } while (!this.compareAndSetState(state, newState = state + readers));
            return newState;
        }

        @Override
        protected boolean tryRelease(int ignored) {
            if (this.getState() != -1) {
                throw new IllegalMonitorStateException();
            }
            this.setExclusiveOwnerThread(null);
            this.setState(0);
            return true;
        }

        @Override
        protected boolean tryReleaseShared(int ignored) {
            int newState;
            int state;
            do {
                if ((state = this.getState()) != 0 && state != -1) continue;
                throw new IllegalMonitorStateException();
            } while (!this.compareAndSetState(state, newState = state - 1));
            return newState == 0;
        }

        void lockShared() {
            this.acquireShared(1);
        }

        boolean tryLockExclusively() {
            return this.tryAcquire(0);
        }

        boolean tryLockShared() {
            return this.tryAcquireShared(1) > 0;
        }

        void unlockExclusively() {
            this.release(0);
        }

        void unlockShared() {
            this.releaseShared(0);
        }
    }

    private final class ConnectionImpl
    extends AbstractAsynchronousConnection
    implements ConnectionEventListener {
        private final Connection connection;
        private final SearchResultHandler heartBeatHandler = new SearchResultHandler(){

            @Override
            public boolean handleEntry(SearchResultEntry entry) {
                ConnectionImpl.this.timestamp(entry);
                return true;
            }

            @Override
            public void handleErrorResult(ErrorResultException error) {
                if (!(error instanceof CancelledResultException)) {
                    if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                        StaticUtils.DEBUG_LOG.fine(String.format("Heartbeat failed for connection factory '%s': %s", HeartBeatConnectionFactory.this.factory, error.getMessage()));
                    }
                    ConnectionImpl.this.timestamp(error);
                }
                ConnectionImpl.this.releaseHeartBeatLock();
            }

            @Override
            public boolean handleReference(SearchResultReference reference) {
                ConnectionImpl.this.timestamp(reference);
                return true;
            }

            @Override
            public void handleResult(Result result) {
                ConnectionImpl.this.timestamp(result);
                ConnectionImpl.this.releaseHeartBeatLock();
            }
        };
        private final Queue<Runnable> pendingBindOrStartTLSRequests = new ConcurrentLinkedQueue<Runnable>();
        private final Queue<AbstractWrappedResultHandler<?, ?>> pendingResults = new ConcurrentLinkedQueue();
        private final ConnectionState state = new ConnectionState();
        private final Sync sync = new Sync();
        private volatile long lastResponseTimestamp;

        private ConnectionImpl(Connection connection) {
            this.lastResponseTimestamp = HeartBeatConnectionFactory.this.timeSource.currentTimeMillis();
            this.connection = connection;
            connection.addConnectionEventListener(this);
        }

        @Override
        public FutureResult<Void> abandonAsync(AbandonRequest request) {
            return this.connection.abandonAsync(request);
        }

        @Override
        public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            if (this.checkState(resultHandler)) {
                WrappedResultHandler<? super Result> h = this.wrap(resultHandler);
                return this.checkState(this.connection.addAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            this.state.addConnectionEventListener(listener);
        }

        @Override
        public FutureResult<BindResult> bindAsync(final BindRequest request, final IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
            if (this.checkState(resultHandler)) {
                if (this.sync.tryLockShared()) {
                    WrappedBindOrStartTLSResultHandler<? super BindResult> h = this.wrapForBindOrStartTLS(resultHandler);
                    return this.checkState(this.connection.bindAsync(request, intermediateResponseHandler, h), h);
                }
                DelayedFuture<BindResult> future = new DelayedFuture<BindResult>(resultHandler){

                    @Override
                    public FutureResult<BindResult> dispatch() {
                        WrappedBindOrStartTLSResultHandler h = ConnectionImpl.this.wrapForBindOrStartTLS(this);
                        return ConnectionImpl.this.checkState(ConnectionImpl.this.connection.bindAsync(request, intermediateResponseHandler, h), h);
                    }
                };
                this.pendingBindOrStartTLSRequests.offer(future);
                this.flushPendingBindOrStartTLSRequests();
                return future;
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public void close() {
            this.handleConnectionClosed();
            this.connection.close();
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.handleConnectionClosed();
            this.connection.close(request, reason);
        }

        @Override
        public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
            if (this.checkState(resultHandler)) {
                WrappedResultHandler<? super CompareResult> h = this.wrap(resultHandler);
                return this.checkState(this.connection.compareAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            if (this.checkState(resultHandler)) {
                WrappedResultHandler<? super Result> h = this.wrap(resultHandler);
                return this.checkState(this.connection.deleteAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(final ExtendedRequest<R> request, final IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
            if (this.checkState(resultHandler)) {
                if (this.isStartTLSRequest(request)) {
                    if (this.sync.tryLockShared()) {
                        WrappedBindOrStartTLSResultHandler<? super R> h = this.wrapForBindOrStartTLS(resultHandler);
                        return this.checkState(this.connection.extendedRequestAsync(request, intermediateResponseHandler, h), h);
                    }
                    DelayedFuture future = new DelayedFuture<R>(resultHandler){

                        @Override
                        public FutureResult<R> dispatch() {
                            WrappedBindOrStartTLSResultHandler h = ConnectionImpl.this.wrapForBindOrStartTLS(this);
                            return ConnectionImpl.this.checkState(ConnectionImpl.this.connection.extendedRequestAsync(request, intermediateResponseHandler, h), h);
                        }
                    };
                    this.pendingBindOrStartTLSRequests.offer(future);
                    this.flushPendingBindOrStartTLSRequests();
                    return future;
                }
                WrappedResultHandler<? super R> h = this.wrap(resultHandler);
                return this.checkState(this.connection.extendedRequestAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionClosed() {
            if (this.state.notifyConnectionClosed()) {
                this.failPendingResults(ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, (CharSequence)CoreMessages.HBCF_CONNECTION_CLOSED_BY_CLIENT.get()));
                List list = HeartBeatConnectionFactory.this.validConnections;
                synchronized (list) {
                    this.connection.removeConnectionEventListener(this);
                    HeartBeatConnectionFactory.this.validConnections.remove(this);
                    if (HeartBeatConnectionFactory.this.validConnections.isEmpty()) {
                        HeartBeatConnectionFactory.this.heartBeatFuture.cancel(false);
                    }
                }
                HeartBeatConnectionFactory.this.releaseScheduler();
            }
        }

        @Override
        public void handleConnectionError(boolean isDisconnectNotification, ErrorResultException error) {
            if (this.state.notifyConnectionError(isDisconnectNotification, error)) {
                this.failPendingResults(error);
            }
        }

        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            this.timestamp(notification);
            this.state.notifyUnsolicitedNotification(notification);
        }

        @Override
        public boolean isClosed() {
            return this.state.isClosed();
        }

        @Override
        public boolean isValid() {
            return this.state.isValid() && this.connection.isValid();
        }

        @Override
        public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            if (this.checkState(resultHandler)) {
                WrappedResultHandler<? super Result> h = this.wrap(resultHandler);
                return this.checkState(this.connection.modifyAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            if (this.checkState(resultHandler)) {
                WrappedResultHandler<? super Result> h = this.wrap(resultHandler);
                return this.checkState(this.connection.modifyDNAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            this.state.removeConnectionEventListener(listener);
        }

        @Override
        public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
            if (this.checkState(resultHandler)) {
                WrappedSearchResultHandler h = this.wrap(resultHandler);
                return this.checkState(this.connection.searchAsync(request, intermediateResponseHandler, h), h);
            }
            return this.newConnectionErrorFuture();
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("HeartBeatConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }

        private void checkForHeartBeat() {
            long currentTimeMillis;
            if (this.sync.isHeld() && this.lastResponseTimestamp < (currentTimeMillis = HeartBeatConnectionFactory.this.timeSource.currentTimeMillis()) - HeartBeatConnectionFactory.this.timeoutMS) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                    StaticUtils.DEBUG_LOG.warning(String.format("No heartbeat detected for connection '%s'", this.connection));
                }
                this.handleConnectionError(false, HeartBeatConnectionFactory.this.newHeartBeatTimeoutError());
            }
        }

        private <R> FutureResult<R> checkState(FutureResult<R> future, AbstractWrappedResultHandler<R, ? extends ResultHandler<? super R>> h) {
            h.setInnerFuture(future);
            this.checkState(h);
            return h;
        }

        private boolean checkState(ResultHandler<?> h) {
            ErrorResultException error = this.state.getConnectionError();
            if (error != null) {
                if (h != null) {
                    h.handleErrorResult(error);
                }
                return false;
            }
            return true;
        }

        private void failPendingResults(ErrorResultException error) {
            AbstractWrappedResultHandler<?, ?> pendingResult;
            while ((pendingResult = this.pendingResults.peek()) != null) {
                pendingResult.handleErrorResult(error);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void flushPendingBindOrStartTLSRequests() {
            if (!this.pendingBindOrStartTLSRequests.isEmpty() && this.sync.tryLockShared()) {
                try {
                    Runnable pendingRequest;
                    while ((pendingRequest = this.pendingBindOrStartTLSRequests.poll()) != null) {
                        pendingRequest.run();
                    }
                }
                finally {
                    this.sync.unlockShared();
                }
            }
        }

        private boolean isStartTLSRequest(ExtendedRequest<?> request) {
            return request.getOID().equals("1.3.6.1.4.1.1466.20037");
        }

        private <R> CompletedFutureResult<R> newConnectionErrorFuture() {
            return new CompletedFutureResult<ErrorResultException>(this.state.getConnectionError());
        }

        private void releaseBindOrStartTLSLock() {
            this.sync.unlockShared();
        }

        private void releaseHeartBeatLock() {
            this.sync.unlockExclusively();
            this.flushPendingBindOrStartTLSRequests();
        }

        private boolean sendHeartBeat() {
            if (!this.state.isValid()) {
                return false;
            }
            long currentTimeMillis = HeartBeatConnectionFactory.this.timeSource.currentTimeMillis();
            if (currentTimeMillis < this.lastResponseTimestamp + HeartBeatConnectionFactory.this.minDelayMS) {
                return false;
            }
            if (this.sync.tryLockExclusively()) {
                try {
                    this.connection.searchAsync(HeartBeatConnectionFactory.this.heartBeatRequest, null, this.heartBeatHandler);
                }
                catch (IllegalStateException e) {
                    this.releaseHeartBeatLock();
                }
            }
            return true;
        }

        private <R> R timestamp(R response) {
            if (!(response instanceof ConnectionException)) {
                this.lastResponseTimestamp = HeartBeatConnectionFactory.this.timeSource.currentTimeMillis();
            }
            return response;
        }

        private <R> WrappedResultHandler<R> wrap(ResultHandler<? super R> handler) {
            WrappedResultHandler<? super R> h = new WrappedResultHandler<R>(handler);
            this.pendingResults.add(h);
            return h;
        }

        private WrappedSearchResultHandler wrap(SearchResultHandler handler) {
            WrappedSearchResultHandler h = new WrappedSearchResultHandler(handler);
            this.pendingResults.add(h);
            return h;
        }

        private <R> WrappedBindOrStartTLSResultHandler<R> wrapForBindOrStartTLS(ResultHandler<? super R> handler) {
            WrappedBindOrStartTLSResultHandler<? super R> h = new WrappedBindOrStartTLSResultHandler<R>(handler);
            this.pendingResults.add(h);
            return h;
        }

        private final class WrappedSearchResultHandler
        extends AbstractWrappedResultHandler<Result, SearchResultHandler>
        implements SearchResultHandler {
            WrappedSearchResultHandler(SearchResultHandler handler) {
                super(ConnectionImpl.this, (ResultHandler)handler);
            }

            @Override
            public synchronized boolean handleEntry(SearchResultEntry entry) {
                if (!this.isDone()) {
                    if (this.handler != null) {
                        ((SearchResultHandler)this.handler).handleEntry((SearchResultEntry)ConnectionImpl.this.timestamp(entry));
                    } else {
                        ConnectionImpl.this.timestamp(entry);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public synchronized boolean handleReference(SearchResultReference reference) {
                if (!this.isDone()) {
                    if (this.handler != null) {
                        ((SearchResultHandler)this.handler).handleReference((SearchResultReference)ConnectionImpl.this.timestamp(reference));
                    } else {
                        ConnectionImpl.this.timestamp(reference);
                    }
                    return true;
                }
                return false;
            }

            @Override
            void releaseBindOrStartTLSLockIfNeeded() {
            }
        }

        private final class WrappedResultHandler<R>
        extends AbstractWrappedResultHandler<R, ResultHandler<? super R>> {
            WrappedResultHandler(ResultHandler<? super R> handler) {
                super(ConnectionImpl.this, handler);
            }

            @Override
            void releaseBindOrStartTLSLockIfNeeded() {
            }
        }

        private final class WrappedBindOrStartTLSResultHandler<R>
        extends AbstractWrappedResultHandler<R, ResultHandler<? super R>> {
            WrappedBindOrStartTLSResultHandler(ResultHandler<? super R> handler) {
                super(ConnectionImpl.this, handler);
            }

            @Override
            void releaseBindOrStartTLSLockIfNeeded() {
                ConnectionImpl.this.releaseBindOrStartTLSLock();
            }
        }

        private abstract class DelayedFuture<R extends Result>
        extends AsynchronousFutureResult<R, ResultHandler<? super R>>
        implements Runnable {
            private volatile FutureResult<R> innerFuture;

            protected DelayedFuture(ResultHandler<? super R> handler) {
                super(handler);
                this.innerFuture = null;
            }

            @Override
            public final int getRequestID() {
                return this.innerFuture != null ? this.innerFuture.getRequestID() : -1;
            }

            @Override
            public final void run() {
                if (!this.isCancelled()) {
                    ConnectionImpl.this.sync.lockShared();
                    this.innerFuture = this.dispatch();
                    if (this.isCancelled() && !this.innerFuture.isCancelled()) {
                        this.innerFuture.cancel(false);
                    }
                }
            }

            protected abstract FutureResult<R> dispatch();

            @Override
            protected final ErrorResultException handleCancelRequest(boolean mayInterruptIfRunning) {
                if (this.innerFuture != null) {
                    this.innerFuture.cancel(mayInterruptIfRunning);
                }
                return null;
            }
        }

        private static abstract class AbstractWrappedResultHandler<R, H extends ResultHandler<? super R>>
        implements ResultHandler<R>,
        FutureResult<R> {
            protected final H handler;
            private final CountDownLatch completed = new CountDownLatch(1);
            private ErrorResultException error;
            private FutureResult<R> innerFuture;
            private R result;
            final /* synthetic */ ConnectionImpl this$1;

            AbstractWrappedResultHandler(H handler) {
                this.this$1 = var1_1;
                this.handler = handler;
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return this.innerFuture.cancel(mayInterruptIfRunning);
            }

            @Override
            public R get() throws ErrorResultException, InterruptedException {
                this.completed.await();
                return this.get0();
            }

            @Override
            public R get(long timeout, TimeUnit unit) throws ErrorResultException, TimeoutException, InterruptedException {
                if (this.completed.await(timeout, unit)) {
                    return this.get0();
                }
                throw new TimeoutException();
            }

            @Override
            public int getRequestID() {
                return this.innerFuture.getRequestID();
            }

            @Override
            public void handleErrorResult(ErrorResultException error) {
                if (this.tryComplete(null, error)) {
                    if (this.handler != null) {
                        this.handler.handleErrorResult((ErrorResultException)this.this$1.timestamp(error));
                    } else {
                        this.this$1.timestamp(error);
                    }
                }
            }

            @Override
            public void handleResult(R result) {
                if (this.tryComplete(result, null)) {
                    if (this.handler != null) {
                        this.handler.handleResult((Object)this.this$1.timestamp(result));
                    } else {
                        this.this$1.timestamp(result);
                    }
                }
            }

            @Override
            public boolean isCancelled() {
                return this.innerFuture.isCancelled();
            }

            @Override
            public boolean isDone() {
                return this.completed.getCount() == 0L;
            }

            abstract void releaseBindOrStartTLSLockIfNeeded();

            FutureResult<R> setInnerFuture(FutureResult<R> innerFuture) {
                this.innerFuture = innerFuture;
                return this;
            }

            private R get0() throws ErrorResultException {
                if (this.result != null) {
                    return this.result;
                }
                throw this.error;
            }

            private synchronized boolean tryComplete(R result, ErrorResultException error) {
                if (this.this$1.pendingResults.remove(this)) {
                    this.result = result;
                    this.error = error;
                    this.completed.countDown();
                    this.releaseBindOrStartTLSLockIfNeeded();
                    return true;
                }
                return false;
            }
        }
    }

    private final class ConnectionFutureResultImpl {
        private Connection connection;
        private final RecursiveFutureResult<Connection, Result> futureConnectionResult;
        private final FutureResultTransformer<Result, Connection> futureSearchResult;

        private ConnectionFutureResultImpl(ResultHandler<? super Connection> handler) {
            this.futureSearchResult = new FutureResultTransformer<Result, Connection>(handler){

                @Override
                protected ErrorResultException transformErrorResult(ErrorResultException errorResult) {
                    if (ConnectionFutureResultImpl.this.connection != null) {
                        ConnectionFutureResultImpl.this.connection.close();
                        ConnectionFutureResultImpl.this.connection = null;
                    }
                    HeartBeatConnectionFactory.this.releaseScheduler();
                    return HeartBeatConnectionFactory.this.adaptHeartBeatError(errorResult);
                }

                @Override
                protected Connection transformResult(Result result) throws ErrorResultException {
                    return HeartBeatConnectionFactory.this.adaptConnection(ConnectionFutureResultImpl.this.connection);
                }
            };
            this.futureConnectionResult = new RecursiveFutureResult<Connection, Result>(this.futureSearchResult){

                @Override
                protected FutureResult<? extends Result> chainResult(Connection innerResult, ResultHandler<? super Result> handler) throws ErrorResultException {
                    ConnectionFutureResultImpl.this.connection = innerResult;
                    InitialHeartBeatResultHandler wrappedHandler = new InitialHeartBeatResultHandler(handler);
                    ((ScheduledExecutorService)HeartBeatConnectionFactory.this.scheduler.get()).schedule(wrappedHandler, HeartBeatConnectionFactory.this.timeoutMS, TimeUnit.MILLISECONDS);
                    return ConnectionFutureResultImpl.this.connection.searchAsync(HeartBeatConnectionFactory.this.heartBeatRequest, null, wrappedHandler);
                }
            };
            this.futureSearchResult.setFutureResult(this.futureConnectionResult);
        }

        private final class InitialHeartBeatResultHandler
        implements SearchResultHandler,
        Runnable {
            private final ResultHandler<? super Result> handler;
            private final AtomicBoolean isComplete = new AtomicBoolean();

            private InitialHeartBeatResultHandler(ResultHandler<? super Result> handler) {
                this.handler = handler;
            }

            @Override
            public boolean handleEntry(SearchResultEntry entry) {
                return true;
            }

            @Override
            public void handleErrorResult(ErrorResultException error) {
                if (this.isComplete.compareAndSet(false, true)) {
                    this.handler.handleErrorResult(error);
                }
            }

            @Override
            public boolean handleReference(SearchResultReference reference) {
                return true;
            }

            @Override
            public void handleResult(Result result) {
                if (this.isComplete.compareAndSet(false, true)) {
                    this.handler.handleResult(result);
                }
            }

            @Override
            public void run() {
                this.handleErrorResult(HeartBeatConnectionFactory.this.newHeartBeatTimeoutError());
            }
        }
    }
}

