/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.SubstringReader;
import com.forgerock.opendj.util.Validator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import java.util.WeakHashMap;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.i18n.LocalizedIllegalArgumentException;
import org.forgerock.opendj.ldap.AVA;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.RDN;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.schema.MatchingRule;
import org.forgerock.opendj.ldap.schema.Schema;
import org.forgerock.opendj.ldap.schema.Syntax;
import org.forgerock.opendj.ldap.schema.UnknownSchemaElementException;

public final class DN
implements Iterable<RDN>,
Comparable<DN> {
    private static final DN ROOT_DN = new DN(null, null, "");
    private static final int DN_CACHE_SIZE = 32;
    private static final ThreadLocal<WeakHashMap<Schema, Map<String, DN>>> CACHE = new ThreadLocal<WeakHashMap<Schema, Map<String, DN>>>(){

        @Override
        protected WeakHashMap<Schema, Map<String, DN>> initialValue() {
            return new WeakHashMap<Schema, Map<String, DN>>();
        }
    };
    private final RDN rdn;
    private DN parent;
    private final int size;
    private String stringValue;

    public static String escapeAttributeValue(Object attributeValue) {
        Validator.ensureNotNull(attributeValue);
        String s = String.valueOf(attributeValue);
        StringBuilder builder = new StringBuilder(s.length());
        AVA.escapeAttributeValue(s, builder);
        return builder.toString();
    }

    public static DN format(String template, Object ... attributeValues) {
        return DN.format(template, Schema.getDefaultSchema(), attributeValues);
    }

    public static DN format(String template, Schema schema, Object ... attributeValues) {
        String[] attributeValueStrings = new String[attributeValues.length];
        for (int i = 0; i < attributeValues.length; ++i) {
            attributeValueStrings[i] = DN.escapeAttributeValue(attributeValues[i]);
        }
        String dnString = String.format(template, attributeValueStrings);
        return DN.valueOf(dnString, schema);
    }

    public static DN rootDN() {
        return ROOT_DN;
    }

    public static DN valueOf(String dn) {
        return DN.valueOf(dn, Schema.getDefaultSchema());
    }

    public static DN valueOf(String dn, Schema schema) {
        Validator.ensureNotNull((Object)dn, (Object)schema);
        if (dn.length() == 0) {
            return ROOT_DN;
        }
        Map<String, DN> cache = DN.getCache(schema);
        DN cachedDN = cache.get(dn);
        if (cachedDN != null) {
            return cachedDN;
        }
        SubstringReader reader = new SubstringReader(dn);
        return DN.decode(dn, reader, schema, cache);
    }

    private static int compareTo(DN dn1, DN dn2) {
        if (dn1.isRootDN()) {
            if (dn2.isRootDN()) {
                return 0;
            }
            return -1;
        }
        if (dn2.isRootDN()) {
            return 1;
        }
        int dn1Size = dn1.size - 1;
        int dn2Size = dn2.size - 1;
        while (dn1Size >= 0 && dn2Size >= 0) {
            DN dn1Parent = dn1.parent(dn1Size--);
            DN dn2Parent = dn2.parent(dn2Size--);
            int result = dn1Parent.rdn.compareTo(dn2Parent.rdn);
            if (result > 0) {
                return 1;
            }
            if (result >= 0) continue;
            return -1;
        }
        if (dn1Size > dn2Size) {
            return 1;
        }
        if (dn1Size < dn2Size) {
            return -1;
        }
        return 0;
    }

    private static DN decode(String dnString, SubstringReader reader, Schema schema, Map<String, DN> cache) {
        DN parent;
        RDN rdn;
        reader.skipWhitespaces();
        if (reader.remaining() == 0) {
            return ROOT_DN;
        }
        try {
            rdn = RDN.decode(null, reader, schema);
        }
        catch (UnknownSchemaElementException e) {
            LocalizableMessage message = CoreMessages.ERR_DN_TYPE_NOT_FOUND.get((Object)reader.getString(), (Object)e.getMessageObject());
            throw new LocalizedIllegalArgumentException(message);
        }
        if (reader.remaining() > 0 && reader.read() == ',') {
            reader.mark();
            String parentString = reader.read(reader.remaining());
            parent = cache.get(parentString);
            if (parent == null) {
                reader.reset();
                parent = DN.decode(parentString, reader, schema, cache);
                cache.put(parentString, parent);
            }
        } else {
            parent = ROOT_DN;
        }
        return new DN(parent, rdn, dnString);
    }

    private static Map<String, DN> getCache(Schema schema) {
        WeakHashMap<Schema, Map<String, DN>> threadLocalMap = CACHE.get();
        LinkedHashMap<String, DN> schemaLocalMap = threadLocalMap.get(schema);
        if (schemaLocalMap == null) {
            schemaLocalMap = new LinkedHashMap<String, DN>(32, 0.75f, true){

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, DN> e) {
                    return this.size() > 32;
                }
            };
            threadLocalMap.put(schema, (Map<String, DN>)schemaLocalMap);
        }
        return schemaLocalMap;
    }

    private DN(DN parent, RDN rdn, String stringValue) {
        this(parent, rdn, stringValue, parent != null ? parent.size + 1 : 0);
    }

    private DN(DN parent, RDN rdn, String stringValue, int size) {
        this.parent = parent;
        this.rdn = rdn;
        this.stringValue = stringValue;
        this.size = size;
    }

    public DN child(DN dn) {
        Validator.ensureNotNull(dn);
        if (dn.isRootDN()) {
            return this;
        }
        if (this.isRootDN()) {
            return dn;
        }
        RDN[] rdns = new RDN[dn.size()];
        int i = rdns.length;
        DN next = dn;
        while (next.rdn != null) {
            rdns[--i] = next.rdn;
            next = next.parent;
        }
        DN newDN = this;
        for (i = 0; i < rdns.length; ++i) {
            newDN = new DN(newDN, rdns[i], null);
        }
        return newDN;
    }

    public DN child(RDN rdn) {
        Validator.ensureNotNull(rdn);
        return new DN(this, rdn, null);
    }

    public DN child(String dn) {
        Validator.ensureNotNull(dn);
        return this.child(DN.valueOf(dn));
    }

    public DN child(String attributeType, Object attributeValue) {
        return this.child(new RDN(attributeType, attributeValue));
    }

    @Override
    public int compareTo(DN dn) {
        return DN.compareTo(this, dn);
    }

    public boolean equals(Object obj) {
        DN other;
        if (this == obj) {
            return true;
        }
        if (obj instanceof DN && this.size == (other = (DN)obj).size()) {
            if (this.size == 0) {
                return true;
            }
            if (this.rdn.equals(other.rdn)) {
                return this.parent.equals(other.parent);
            }
        }
        return false;
    }

    public int hashCode() {
        if (this.size == 0) {
            return 0;
        }
        return 31 * this.parent.hashCode() + this.rdn.hashCode();
    }

    public boolean isChildOf(DN dn) {
        return dn.equals(this.parent);
    }

    public boolean isChildOf(String dn) {
        return this.isChildOf(DN.valueOf(dn));
    }

    public boolean isInScopeOf(DN dn, SearchScope scope) {
        if (scope == SearchScope.BASE_OBJECT) {
            return this.equals(dn);
        }
        if (scope == SearchScope.SINGLE_LEVEL) {
            return this.isChildOf(dn);
        }
        if (scope == SearchScope.SUBORDINATES) {
            return this.isSubordinateOrEqualTo(dn) && !this.equals(dn);
        }
        if (scope == SearchScope.WHOLE_SUBTREE) {
            return this.isSubordinateOrEqualTo(dn);
        }
        return false;
    }

    public boolean isInScopeOf(String dn, SearchScope scope) {
        return this.isInScopeOf(DN.valueOf(dn), scope);
    }

    public boolean isParentOf(DN dn) {
        return this.equals(dn.parent);
    }

    public boolean isParentOf(String dn) {
        return this.isParentOf(DN.valueOf(dn));
    }

    public boolean isRootDN() {
        return this.size == 0;
    }

    public boolean isSubordinateOrEqualTo(DN dn) {
        if (this.size < dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return this.parent(this.size - dn.size).equals(dn);
    }

    public boolean isSubordinateOrEqualTo(String dn) {
        return this.isSubordinateOrEqualTo(DN.valueOf(dn));
    }

    public boolean isSuperiorOrEqualTo(DN dn) {
        if (this.size > dn.size) {
            return false;
        }
        if (this.size == dn.size) {
            return this.equals(dn);
        }
        return dn.parent(dn.size - this.size).equals(this);
    }

    public boolean isSuperiorOrEqualTo(String dn) {
        return this.isSuperiorOrEqualTo(DN.valueOf(dn));
    }

    @Override
    public Iterator<RDN> iterator() {
        return new Iterator<RDN>(){
            private DN dn;
            {
                this.dn = DN.this;
            }

            @Override
            public boolean hasNext() {
                return this.dn.rdn != null;
            }

            @Override
            public RDN next() {
                if (this.dn.rdn == null) {
                    throw new NoSuchElementException();
                }
                RDN rdn = this.dn.rdn;
                this.dn = this.dn.parent;
                return rdn;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public DN localName(int index) {
        DN localName;
        Validator.ensureTrue(index >= 0, "index less than zero");
        if (index == 0) {
            return ROOT_DN;
        }
        if (index >= this.size) {
            return this;
        }
        DN nextLocalName = localName = new DN(null, this.rdn, null, index);
        DN lastDN = this.parent;
        for (int i = index - 1; i > 0; --i) {
            nextLocalName = nextLocalName.parent = new DN(null, lastDN.rdn, null, i);
            lastDN = lastDN.parent;
        }
        nextLocalName.parent = ROOT_DN;
        return localName;
    }

    public DN parent() {
        return this.parent;
    }

    public DN parent(int index) {
        Validator.ensureTrue(index >= 0, "index less than zero");
        DN parentDN = this;
        for (int i = 0; parentDN != null && i < index; ++i) {
            parentDN = parentDN.parent;
        }
        return parentDN;
    }

    public RDN rdn() {
        return this.rdn;
    }

    public DN rename(DN fromDN, DN toDN) {
        Validator.ensureNotNull((Object)fromDN, (Object)toDN);
        if (!this.isSubordinateOrEqualTo(fromDN)) {
            return this;
        }
        if (this.equals(fromDN)) {
            return toDN;
        }
        return toDN.child(this.localName(this.size - fromDN.size));
    }

    public int size() {
        return this.size;
    }

    public String toString() {
        if (this.stringValue == null) {
            StringBuilder builder = new StringBuilder();
            this.rdn.toString(builder);
            if (!this.parent.isRootDN()) {
                builder.append(',');
                builder.append(this.parent.toString());
            }
            this.stringValue = builder.toString();
        }
        return this.stringValue;
    }

    public String toNormalizedString() {
        StringBuilder builder = new StringBuilder(this.size());
        if (this.rdn() == null) {
            return builder.toString();
        }
        int i = this.size() - 1;
        DN.normalizeRDN(builder, this.parent(i).rdn());
        --i;
        while (i >= 0) {
            RDN rdn = this.parent(i).rdn();
            if (rdn.size() != 0) {
                builder.append('\u0000');
            }
            DN.normalizeRDN(builder, rdn);
            --i;
        }
        return builder.toString();
    }

    private static StringBuilder normalizeRDN(StringBuilder builder, RDN rdn) {
        int sz = rdn.size();
        switch (sz) {
            case 0: {
                builder.append('\u0001');
                break;
            }
            case 1: {
                DN.normalizeAVA(builder, rdn.getFirstAVA());
                break;
            }
            default: {
                TreeSet<AVA> a = new TreeSet<AVA>();
                for (AVA ava : rdn) {
                    a.add(ava);
                }
                Iterator i = a.iterator();
                DN.normalizeAVA(builder, (AVA)i.next());
                while (i.hasNext()) {
                    builder.append('\u0001');
                    DN.normalizeAVA(builder, (AVA)i.next());
                }
                break block0;
            }
        }
        return builder;
    }

    private static StringBuilder normalizeAVA(StringBuilder builder, AVA ava) {
        ByteString value = ava.getAttributeValue();
        MatchingRule matchingRule = ava.getAttributeType().getEqualityMatchingRule();
        if (matchingRule != null) {
            try {
                value = matchingRule.normalizeAttributeValue(ava.getAttributeValue());
            }
            catch (DecodeException decodeException) {
                // empty catch block
            }
        }
        if (!ava.getAttributeType().getNames().iterator().hasNext()) {
            builder.append(ava.getAttributeType().getOID());
            builder.append("=#");
            StaticUtils.toHex(value, builder);
        } else {
            String name = ava.getAttributeType().getNameOrOID();
            StaticUtils.toLowerCase(name, builder);
            builder.append("=");
            Syntax syntax = ava.getAttributeType().getSyntax();
            if (!syntax.isHumanReadable()) {
                builder.append("#");
                StaticUtils.toHex(value, builder);
            } else {
                String str = value.toString();
                if (str.length() == 0) {
                    return builder;
                }
                char c = str.charAt(0);
                int startPos = 0;
                if (c == ' ' || c == '#') {
                    builder.append('\\');
                    builder.append(c);
                    startPos = 1;
                }
                int length = str.length();
                for (int si = startPos; si < length; ++si) {
                    c = str.charAt(si);
                    if (c < ' ') {
                        for (byte b : StaticUtils.getBytes(String.valueOf(c))) {
                            builder.append('\\');
                            builder.append(StaticUtils.byteToLowerHex(b));
                        }
                        continue;
                    }
                    if (c == ' ' && si == length - 1 || c == '\"' || c == '+' || c == ',' || c == ';' || c == '<' || c == '=' || c == '>' || c == '\\' || c == '\u0000') {
                        builder.append('\\');
                    }
                    builder.append(c);
                }
            }
        }
        return builder;
    }
}

