/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.Validator;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

abstract class CommonLDAPOptions<T extends CommonLDAPOptions<T>> {
    private static final boolean DEFAULT_TCP_NO_DELAY;
    private static final boolean DEFAULT_REUSE_ADDRESS;
    private static final boolean DEFAULT_KEEPALIVE;
    private static final int DEFAULT_LINGER;
    private DecodeOptions decodeOptions;
    private boolean tcpNoDelay = DEFAULT_TCP_NO_DELAY;
    private boolean keepAlive = DEFAULT_KEEPALIVE;
    private boolean reuseAddress = DEFAULT_REUSE_ADDRESS;
    private int linger = DEFAULT_LINGER;
    private TCPNIOTransport transport;

    static boolean getBooleanProperty(String name, boolean defaultValue) {
        String value = System.getProperty(name);
        return value != null ? Boolean.parseBoolean(value) : defaultValue;
    }

    static int getIntProperty(String name, int defaultValue) {
        String value = System.getProperty(name);
        try {
            return value != null ? Integer.parseInt(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    CommonLDAPOptions() {
        this.decodeOptions = new DecodeOptions();
    }

    CommonLDAPOptions(CommonLDAPOptions<?> options) {
        this.decodeOptions = new DecodeOptions(options.decodeOptions);
        this.linger = options.linger;
        this.keepAlive = options.keepAlive;
        this.reuseAddress = options.reuseAddress;
        this.tcpNoDelay = options.tcpNoDelay;
    }

    public DecodeOptions getDecodeOptions() {
        return this.decodeOptions;
    }

    public int getLinger() {
        return this.linger;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public boolean isReuseAddress() {
        return this.reuseAddress;
    }

    public boolean isTCPNoDelay() {
        return this.tcpNoDelay;
    }

    public T setDecodeOptions(DecodeOptions decodeOptions) {
        Validator.ensureNotNull(decodeOptions);
        this.decodeOptions = decodeOptions;
        return this.getThis();
    }

    public T setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this.getThis();
    }

    public T setLinger(int linger) {
        this.linger = linger;
        return this.getThis();
    }

    public T setReuseAddress(boolean reuseAddress) {
        this.reuseAddress = reuseAddress;
        return this.getThis();
    }

    public T setTCPNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
        return this.getThis();
    }

    public TCPNIOTransport getTCPNIOTransport() {
        return this.transport;
    }

    public T setTCPNIOTransport(TCPNIOTransport transport) {
        this.transport = transport;
        return this.getThis();
    }

    abstract T getThis();

    static {
        DEFAULT_LINGER = CommonLDAPOptions.getIntProperty("org.forgerock.opendj.io.linger", -1);
        DEFAULT_TCP_NO_DELAY = CommonLDAPOptions.getBooleanProperty("org.forgerock.opendj.io.tcpNoDelay", true);
        DEFAULT_REUSE_ADDRESS = CommonLDAPOptions.getBooleanProperty("org.forgerock.opendj.io.reuseAddress", true);
        DEFAULT_KEEPALIVE = CommonLDAPOptions.getBooleanProperty("org.forgerock.opendj.io.keepAlive", true);
    }
}

