/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import com.forgerock.opendj.util.CompletedFutureResult;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.TimeSource;
import com.forgerock.opendj.util.Validator;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionEventListener;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ConnectionPool;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Entry;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.SearchScope;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.BindRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.forgerock.opendj.ldif.ChangeRecord;
import org.forgerock.opendj.ldif.ConnectionEntryReader;

final class CachedConnectionPool
implements ConnectionPool {
    TimeSource timeSource = TimeSource.DEFAULT;
    private final Semaphore availableConnections;
    private final ResultHandler<Connection> connectionResultHandler = new ConnectionResultHandler();
    private final int corePoolSize;
    private final ConnectionFactory factory;
    private boolean isClosed = false;
    private final ScheduledFuture<?> idleTimeoutFuture;
    private final long idleTimeoutMillis;
    private final int maxPoolSize;
    private final LinkedList<QueueElement> queue = new LinkedList();
    private final ReferenceCountedObject.Reference scheduler;
    private final AtomicInteger pendingConnectionAttempts = new AtomicInteger();

    CachedConnectionPool(ConnectionFactory factory, int corePoolSize, int maximumPoolSize, long idleTimeout, TimeUnit unit, ScheduledExecutorService scheduler) {
        Validator.ensureNotNull(factory);
        Validator.ensureTrue(corePoolSize >= 0, "corePoolSize < 0");
        Validator.ensureTrue(maximumPoolSize > 0, "maxPoolSize <= 0");
        Validator.ensureTrue(corePoolSize <= maximumPoolSize, "corePoolSize > maxPoolSize");
        Validator.ensureTrue(idleTimeout >= 0L, "idleTimeout < 0");
        Validator.ensureTrue(idleTimeout == 0L || unit != null, "time unit is null");
        this.factory = factory;
        this.corePoolSize = corePoolSize;
        this.maxPoolSize = maximumPoolSize;
        this.availableConnections = new Semaphore(maximumPoolSize);
        if (corePoolSize < maximumPoolSize && idleTimeout > 0L) {
            this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(scheduler);
            this.idleTimeoutMillis = unit.toMillis(idleTimeout);
            this.idleTimeoutFuture = ((ScheduledExecutorService)this.scheduler.get()).scheduleWithFixedDelay(new PurgeIdleConnectionsTask(), idleTimeout, idleTimeout, unit);
        } else {
            this.scheduler = null;
            this.idleTimeoutMillis = 0L;
            this.idleTimeoutFuture = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        LinkedList<Connection> idleConnections;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            idleConnections = new LinkedList<Connection>();
            while (this.hasWaitingConnections()) {
                QueueElement holder = this.queue.removeFirst();
                idleConnections.add(holder.getWaitingConnection());
                this.availableConnections.release();
            }
        }
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
            StaticUtils.DEBUG_LOG.fine(String.format("Connection pool is closing: availableConnections=%d, maxPoolSize=%d", this.currentPoolSize(), this.maxPoolSize));
        }
        if (this.idleTimeoutFuture != null) {
            this.idleTimeoutFuture.cancel(false);
            this.scheduler.release();
        }
        for (Connection connection : idleConnections) {
            connection.close();
        }
        this.factory.close();
    }

    @Override
    public Connection getConnection() throws ErrorResultException {
        try {
            return this.getConnectionAsync(null).get();
        }
        catch (InterruptedException e) {
            throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> handler) {
        while (true) {
            QueueElement holder;
            LinkedList<QueueElement> linkedList = this.queue;
            synchronized (linkedList) {
                if (this.isClosed) {
                    throw new IllegalStateException("CachedConnectionPool is already closed");
                }
                if (this.hasWaitingConnections()) {
                    holder = this.queue.removeFirst();
                } else {
                    holder = new QueueElement(handler, this.timeSource.currentTimeMillis(), StaticUtils.getStackTraceIfDebugEnabled());
                    this.queue.add(holder);
                }
            }
            if (holder.isWaitingFuture()) {
                AsynchronousFutureResult<Connection, ResultHandler<? super Connection>> future = holder.getWaitingFuture();
                if (!future.isDone() && this.availableConnections.tryAcquire()) {
                    this.pendingConnectionAttempts.incrementAndGet();
                    this.factory.getConnectionAsync(this.connectionResultHandler);
                }
                return future;
            }
            Connection connection = holder.getWaitingConnection();
            if (connection.isValid()) {
                PooledConnection pooledConnection = this.newPooledConnection(connection, StaticUtils.getStackTraceIfDebugEnabled());
                if (handler != null) {
                    handler.handleResult(pooledConnection);
                }
                return new CompletedFutureResult<Connection>(pooledConnection);
            }
            connection.close();
            this.availableConnections.release();
            if (!StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) continue;
            StaticUtils.DEBUG_LOG.fine(String.format("Connection no longer valid: availableConnections=%d, poolSize=%d", this.currentPoolSize(), this.maxPoolSize));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        int size = this.currentPoolSize();
        int pending = this.pendingConnectionAttempts.get();
        int in = 0;
        int blocked = 0;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            for (QueueElement qe : this.queue) {
                if (qe.isWaitingFuture()) {
                    ++blocked;
                    continue;
                }
                ++in;
            }
        }
        int out = size - in - pending;
        return String.format("CachedConnectionPool(size=%d[in:%d + out:%d + pending:%d], maxSize=%d, blocked=%d, factory=%s)", size, in, out, pending, this.maxPoolSize, blocked, String.valueOf(this.factory));
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    int currentPoolSize() {
        return this.maxPoolSize - this.availableConnections.availablePermits();
    }

    private boolean hasWaitingConnections() {
        return !this.queue.isEmpty() && !this.queue.getFirst().isWaitingFuture();
    }

    private boolean hasWaitingFutures() {
        return !this.queue.isEmpty() && this.queue.getFirst().isWaitingFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishConnection(Connection connection) {
        QueueElement holder;
        boolean connectionPoolIsClosing = false;
        LinkedList<QueueElement> linkedList = this.queue;
        synchronized (linkedList) {
            if (this.hasWaitingFutures()) {
                connectionPoolIsClosing = this.isClosed;
                holder = this.queue.removeFirst();
            } else if (this.isClosed) {
                connectionPoolIsClosing = true;
                holder = null;
            } else {
                QueueElement holder2 = new QueueElement(connection, this.timeSource.currentTimeMillis());
                this.queue.add(holder2);
                return;
            }
        }
        if (connectionPoolIsClosing) {
            this.availableConnections.release();
            connection.close();
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Closing connection because connection pool is closing: availableConnections=%d, maxPoolSize=%d", this.currentPoolSize(), this.maxPoolSize));
            }
            if (holder != null) {
                ErrorResultException e = ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED, CoreMessages.ERR_CONNECTION_POOL_CLOSING.get((Object)this.toString()).toString());
                holder.getWaitingFuture().handleErrorResult(e);
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("Connection attempt failed: %s, availableConnections=%d, poolSize=%d", e.getMessage(), this.currentPoolSize(), this.maxPoolSize));
                }
            }
        } else {
            holder.getWaitingFuture().handleResult(this.newPooledConnection(connection, holder.getStackTrace()));
        }
    }

    private PooledConnection newPooledConnection(Connection connection, StackTraceElement[] stack) {
        if (!StaticUtils.DEBUG_ENABLED) {
            return new PooledConnection(connection);
        }
        return new DebugEnabledPooledConnection(connection, stack);
    }

    private static final class QueueElement {
        private final long timestampMillis;
        private final Object value;
        private final StackTraceElement[] stack;

        QueueElement(Connection connection, long timestampMillis) {
            this.value = connection;
            this.timestampMillis = timestampMillis;
            this.stack = null;
        }

        QueueElement(ResultHandler<? super Connection> handler, long timestampMillis, StackTraceElement[] stack) {
            this.value = new AsynchronousFutureResult(handler);
            this.timestampMillis = timestampMillis;
            this.stack = stack;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        StackTraceElement[] getStackTrace() {
            return this.stack;
        }

        Connection getWaitingConnection() {
            if (this.value instanceof Connection) {
                return (Connection)this.value;
            }
            throw new IllegalStateException();
        }

        AsynchronousFutureResult<Connection, ResultHandler<? super Connection>> getWaitingFuture() {
            return (AsynchronousFutureResult)this.value;
        }

        boolean hasTimedOut(long timeLimitMillis) {
            return this.timestampMillis < timeLimitMillis;
        }

        boolean isWaitingFuture() {
            return this.value instanceof AsynchronousFutureResult;
        }
    }

    private final class DebugEnabledPooledConnection
    extends PooledConnection {
        private final StackTraceElement[] stackTrace;

        private DebugEnabledPooledConnection(Connection connection, StackTraceElement[] stackTrace) {
            super(connection);
            this.stackTrace = stackTrace;
        }

        protected void finalize() throws Throwable {
            if (!this.isClosed()) {
                StaticUtils.logIfDebugEnabled("CONNECTION POOL: connection leaked! It was allocated here: ", this.stackTrace);
            }
        }
    }

    private final class PurgeIdleConnectionsTask
    implements Runnable {
        private PurgeIdleConnectionsTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LinkedList<Connection> idleConnections;
            LinkedList linkedList = CachedConnectionPool.this.queue;
            synchronized (linkedList) {
                if (CachedConnectionPool.this.isClosed) {
                    return;
                }
                idleConnections = new LinkedList<Connection>();
                long timeoutMillis = CachedConnectionPool.this.timeSource.currentTimeMillis() - CachedConnectionPool.this.idleTimeoutMillis;
                QueueElement holder = (QueueElement)CachedConnectionPool.this.queue.peek();
                for (int nonCoreConnectionCount = CachedConnectionPool.this.currentPoolSize() - CachedConnectionPool.this.corePoolSize; nonCoreConnectionCount > 0 && this.isTimedOutQueuedConnection(holder, timeoutMillis); --nonCoreConnectionCount) {
                    idleConnections.add(holder.getWaitingConnection());
                    CachedConnectionPool.this.queue.poll();
                    CachedConnectionPool.this.availableConnections.release();
                    holder = (QueueElement)CachedConnectionPool.this.queue.peek();
                }
            }
            if (!idleConnections.isEmpty()) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("Closing %d idle pooled connections: availableConnections=%d, maxPoolSize=%d", idleConnections.size(), CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize));
                }
                for (Connection connection : idleConnections) {
                    connection.close();
                }
            }
        }

        private boolean isTimedOutQueuedConnection(QueueElement holder, long timeoutMillis) {
            return holder != null && !holder.isWaitingFuture() && holder.hasTimedOut(timeoutMillis);
        }
    }

    class PooledConnection
    implements Connection,
    ConnectionEventListener {
        private final Connection connection;
        private ErrorResultException error = null;
        private final AtomicBoolean isClosed = new AtomicBoolean(false);
        private boolean isDisconnectNotification = false;
        private List<ConnectionEventListener> listeners = null;
        private final Object stateLock = new Object();

        PooledConnection(Connection connection) {
            this.connection = connection;
        }

        @Override
        public FutureResult<Void> abandonAsync(AbandonRequest request) {
            return this.checkState().abandonAsync(request);
        }

        @Override
        public Result add(AddRequest request) throws ErrorResultException {
            return this.checkState().add(request);
        }

        @Override
        public Result add(Entry entry) throws ErrorResultException {
            return this.checkState().add(entry);
        }

        @Override
        public Result add(String ... ldifLines) throws ErrorResultException {
            return this.checkState().add(ldifLines);
        }

        @Override
        public FutureResult<Result> addAsync(AddRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().addAsync(request, intermediateResponseHandler, resultHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addConnectionEventListener(ConnectionEventListener listener) {
            boolean notifyErrorOccurred;
            boolean notifyClose;
            Validator.ensureNotNull(listener);
            Object object = this.stateLock;
            synchronized (object) {
                notifyClose = this.isClosed.get();
                boolean bl = notifyErrorOccurred = this.error != null;
                if (!notifyClose) {
                    if (this.listeners == null) {
                        this.listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
                        this.listeners.add(listener);
                        this.connection.addConnectionEventListener(this);
                    } else {
                        this.listeners.add(listener);
                    }
                }
            }
            if (notifyErrorOccurred) {
                listener.handleConnectionError(this.isDisconnectNotification, this.error);
            }
            if (notifyClose) {
                listener.handleConnectionClosed();
            }
        }

        @Override
        public Result applyChange(ChangeRecord request) throws ErrorResultException {
            return this.checkState().applyChange(request);
        }

        @Override
        public FutureResult<Result> applyChangeAsync(ChangeRecord request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().applyChangeAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public BindResult bind(BindRequest request) throws ErrorResultException {
            return this.checkState().bind(request);
        }

        @Override
        public BindResult bind(String name, char[] password) throws ErrorResultException {
            return this.checkState().bind(name, password);
        }

        @Override
        public FutureResult<BindResult> bindAsync(BindRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super BindResult> resultHandler) {
            return this.checkState().bindAsync(request, intermediateResponseHandler, resultHandler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            List<ConnectionEventListener> tmpListeners;
            Object object = this.stateLock;
            synchronized (object) {
                if (!this.isClosed.compareAndSet(false, true)) {
                    return;
                }
                tmpListeners = this.listeners;
            }
            if (tmpListeners != null) {
                this.connection.removeConnectionEventListener(this);
            }
            if (this.connection.isValid()) {
                CachedConnectionPool.this.publishConnection(this.connection);
            } else {
                this.connection.close();
                CachedConnectionPool.this.pendingConnectionAttempts.incrementAndGet();
                CachedConnectionPool.this.factory.getConnectionAsync(CachedConnectionPool.this.connectionResultHandler);
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("Connection no longer valid: availableConnections=%d, maxPoolSize=%d", CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize));
                }
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionClosed();
                }
            }
        }

        @Override
        public void close(UnbindRequest request, String reason) {
            this.close();
        }

        @Override
        public CompareResult compare(CompareRequest request) throws ErrorResultException {
            return this.checkState().compare(request);
        }

        @Override
        public CompareResult compare(String name, String attributeDescription, String assertionValue) throws ErrorResultException {
            return this.checkState().compare(name, attributeDescription, assertionValue);
        }

        @Override
        public FutureResult<CompareResult> compareAsync(CompareRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super CompareResult> resultHandler) {
            return this.checkState().compareAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public Result delete(DeleteRequest request) throws ErrorResultException {
            return this.checkState().delete(request);
        }

        @Override
        public Result delete(String name) throws ErrorResultException {
            return this.checkState().delete(name);
        }

        @Override
        public FutureResult<Result> deleteAsync(DeleteRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().deleteAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public Result deleteSubtree(String name) throws ErrorResultException {
            return this.checkState().deleteSubtree(name);
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request) throws ErrorResultException {
            return this.checkState().extendedRequest(request);
        }

        @Override
        public <R extends ExtendedResult> R extendedRequest(ExtendedRequest<R> request, IntermediateResponseHandler handler) throws ErrorResultException {
            return this.checkState().extendedRequest(request, handler);
        }

        @Override
        public GenericExtendedResult extendedRequest(String requestName, ByteString requestValue) throws ErrorResultException {
            return this.checkState().extendedRequest(requestName, requestValue);
        }

        @Override
        public <R extends ExtendedResult> FutureResult<R> extendedRequestAsync(ExtendedRequest<R> request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super R> resultHandler) {
            return this.checkState().extendedRequestAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public void handleConnectionClosed() {
            throw new IllegalStateException("Pooled connection received unexpected close notification");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleConnectionError(boolean isDisconnectNotification, ErrorResultException error) {
            List<ConnectionEventListener> tmpListeners;
            Object object = this.stateLock;
            synchronized (object) {
                tmpListeners = this.listeners;
                this.isDisconnectNotification = isDisconnectNotification;
                this.error = error;
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleConnectionError(isDisconnectNotification, error);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleUnsolicitedNotification(ExtendedResult notification) {
            List<ConnectionEventListener> tmpListeners;
            Object object = this.stateLock;
            synchronized (object) {
                tmpListeners = this.listeners;
            }
            if (tmpListeners != null) {
                for (ConnectionEventListener listener : tmpListeners) {
                    listener.handleUnsolicitedNotification(notification);
                }
            }
        }

        @Override
        public boolean isClosed() {
            return this.isClosed.get();
        }

        @Override
        public boolean isValid() {
            return this.connection.isValid() && !this.isClosed();
        }

        @Override
        public Result modify(ModifyRequest request) throws ErrorResultException {
            return this.checkState().modify(request);
        }

        @Override
        public Result modify(String ... ldifLines) throws ErrorResultException {
            return this.checkState().modify(ldifLines);
        }

        @Override
        public FutureResult<Result> modifyAsync(ModifyRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().modifyAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public Result modifyDN(ModifyDNRequest request) throws ErrorResultException {
            return this.checkState().modifyDN(request);
        }

        @Override
        public Result modifyDN(String name, String newRDN) throws ErrorResultException {
            return this.checkState().modifyDN(name, newRDN);
        }

        @Override
        public FutureResult<Result> modifyDNAsync(ModifyDNRequest request, IntermediateResponseHandler intermediateResponseHandler, ResultHandler<? super Result> resultHandler) {
            return this.checkState().modifyDNAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public SearchResultEntry readEntry(DN name, String ... attributeDescriptions) throws ErrorResultException {
            return this.checkState().readEntry(name, attributeDescriptions);
        }

        @Override
        public SearchResultEntry readEntry(String name, String ... attributeDescriptions) throws ErrorResultException {
            return this.checkState().readEntry(name, attributeDescriptions);
        }

        @Override
        public FutureResult<SearchResultEntry> readEntryAsync(DN name, Collection<String> attributeDescriptions, ResultHandler<? super SearchResultEntry> handler) {
            return this.checkState().readEntryAsync(name, attributeDescriptions, handler);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeConnectionEventListener(ConnectionEventListener listener) {
            Validator.ensureNotNull(listener);
            Object object = this.stateLock;
            synchronized (object) {
                if (this.listeners != null) {
                    this.listeners.remove(listener);
                }
            }
        }

        @Override
        public ConnectionEntryReader search(SearchRequest request) {
            return this.checkState().search(request);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries) throws ErrorResultException {
            return this.checkState().search(request, entries);
        }

        @Override
        public Result search(SearchRequest request, Collection<? super SearchResultEntry> entries, Collection<? super SearchResultReference> references) throws ErrorResultException {
            return this.checkState().search(request, entries, references);
        }

        @Override
        public Result search(SearchRequest request, SearchResultHandler handler) throws ErrorResultException {
            return this.checkState().search(request, handler);
        }

        @Override
        public ConnectionEntryReader search(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) {
            return this.checkState().search(baseObject, scope, filter, attributeDescriptions);
        }

        @Override
        public FutureResult<Result> searchAsync(SearchRequest request, IntermediateResponseHandler intermediateResponseHandler, SearchResultHandler resultHandler) {
            return this.checkState().searchAsync(request, intermediateResponseHandler, resultHandler);
        }

        @Override
        public SearchResultEntry searchSingleEntry(SearchRequest request) throws ErrorResultException {
            return this.checkState().searchSingleEntry(request);
        }

        @Override
        public SearchResultEntry searchSingleEntry(String baseObject, SearchScope scope, String filter, String ... attributeDescriptions) throws ErrorResultException {
            return this.checkState().searchSingleEntry(baseObject, scope, filter, attributeDescriptions);
        }

        @Override
        public FutureResult<SearchResultEntry> searchSingleEntryAsync(SearchRequest request, ResultHandler<? super SearchResultEntry> handler) {
            return this.checkState().searchSingleEntryAsync(request, handler);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("PooledConnection(");
            builder.append(this.connection);
            builder.append(')');
            return builder.toString();
        }

        private Connection checkState() {
            if (this.isClosed()) {
                throw new IllegalStateException();
            }
            return this.connection;
        }
    }

    private final class ConnectionResultHandler
    implements ResultHandler<Connection> {
        private ConnectionResultHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleErrorResult(ErrorResultException error) {
            CachedConnectionPool.this.pendingConnectionAttempts.decrementAndGet();
            CachedConnectionPool.this.availableConnections.release();
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Connection attempt failed: %s, availableConnections=%d, maxPoolSize=%d", error.getMessage(), CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize));
            }
            LinkedList waitingFutures = new LinkedList();
            LinkedList linkedList = CachedConnectionPool.this.queue;
            synchronized (linkedList) {
                while (CachedConnectionPool.this.hasWaitingFutures()) {
                    waitingFutures.add(CachedConnectionPool.this.queue.removeFirst());
                }
            }
            for (QueueElement waitingFuture : waitingFutures) {
                waitingFuture.getWaitingFuture().handleErrorResult(error);
            }
        }

        @Override
        public void handleResult(Connection connection) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                StaticUtils.DEBUG_LOG.fine(String.format("Connection attempt succeeded:  availableConnections=%d, maxPoolSize=%d", CachedConnectionPool.this.currentPoolSize(), CachedConnectionPool.this.maxPoolSize));
            }
            CachedConnectionPool.this.pendingConnectionAttempts.decrementAndGet();
            CachedConnectionPool.this.publishConnection(connection);
        }
    }
}

