/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import org.forgerock.opendj.ldap.ByteSequence;
import org.forgerock.opendj.ldap.ByteString;

public final class ByteSequenceReader {
    private int pos = 0;
    private final ByteSequence sequence;

    ByteSequenceReader(ByteSequence sequence) {
        this.sequence = sequence;
    }

    public byte get() {
        byte b = this.sequence.byteAt(this.pos);
        ++this.pos;
        return b;
    }

    public void get(byte[] b) {
        this.get(b, 0, b.length);
    }

    public void get(byte[] b, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > b.length || length > this.remaining()) {
            throw new IndexOutOfBoundsException();
        }
        this.sequence.subSequence(this.pos, this.pos + length).copyTo(b, offset);
        this.pos += length;
    }

    public int getBERLength() {
        int newPos = this.pos + 1;
        if (newPos > this.sequence.length()) {
            throw new IndexOutOfBoundsException();
        }
        int length = this.sequence.byteAt(this.pos) & 0x7F;
        if (length != this.sequence.byteAt(this.pos)) {
            int numLengthBytes = length;
            newPos = this.pos + 1 + numLengthBytes;
            if (numLengthBytes > 4 || newPos > this.sequence.length()) {
                throw new IndexOutOfBoundsException();
            }
            length = 0;
            for (int i = this.pos + 1; i < newPos; ++i) {
                length = length << 8 | this.sequence.byteAt(i) & 0xFF;
            }
        }
        this.pos = newPos;
        return length;
    }

    public ByteSequence getByteSequence(int length) {
        int newPos = this.pos + length;
        ByteSequence subSequence = this.sequence.subSequence(this.pos, newPos);
        this.pos = newPos;
        return subSequence;
    }

    public ByteString getByteString(int length) {
        return this.getByteSequence(length).toByteString();
    }

    public int getInt() {
        if (this.remaining() < 4) {
            throw new IndexOutOfBoundsException();
        }
        int v = 0;
        for (int i = 0; i < 4; ++i) {
            v <<= 8;
            v |= this.sequence.byteAt(this.pos++) & 0xFF;
        }
        return v;
    }

    public long getLong() {
        if (this.remaining() < 8) {
            throw new IndexOutOfBoundsException();
        }
        long v = 0L;
        for (int i = 0; i < 8; ++i) {
            v <<= 8;
            v |= (long)(this.sequence.byteAt(this.pos++) & 0xFF);
        }
        return v;
    }

    public short getShort() {
        if (this.remaining() < 2) {
            throw new IndexOutOfBoundsException();
        }
        short v = 0;
        for (int i = 0; i < 2; ++i) {
            v = (short)(v << 8);
            v = (short)(v | this.sequence.byteAt(this.pos++) & 0xFF);
        }
        return v;
    }

    public String getString(int length) {
        if (this.remaining() < length) {
            throw new IndexOutOfBoundsException();
        }
        int newPos = this.pos + length;
        String str = this.sequence.subSequence(this.pos, this.pos + length).toString();
        this.pos = newPos;
        return str;
    }

    public int position() {
        return this.pos;
    }

    public void position(int pos) {
        if (pos > this.sequence.length() || pos < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.pos = pos;
    }

    public int remaining() {
        return this.sequence.length() - this.pos;
    }

    public void rewind() {
        this.position(0);
    }

    public void skip(int length) {
        this.position(this.pos + length);
    }

    public String toString() {
        return this.sequence.toString();
    }
}

