/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.opendj.ldap;

import com.forgerock.opendj.util.AsynchronousFutureResult;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import com.forgerock.opendj.util.Validator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.ConnectionFactory;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.LoadBalancerEventListener;
import org.forgerock.opendj.ldap.LoadBalancingAlgorithm;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;

abstract class AbstractLoadBalancingAlgorithm
implements LoadBalancingAlgorithm {
    private static final LoadBalancerEventListener DEFAULT_LISTENER = new LoadBalancerEventListener(){

        @Override
        public void handleConnectionFactoryOnline(ConnectionFactory factory) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.INFO)) {
                StaticUtils.DEBUG_LOG.info(String.format("Connection factory'%s' is now operational", factory));
            }
        }

        @Override
        public void handleConnectionFactoryOffline(ConnectionFactory factory, ErrorResultException error) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.WARNING)) {
                StaticUtils.DEBUG_LOG.warning(String.format("Connection factory '%s' is no longer operational: %s", factory, error.getMessage()));
            }
        }
    };
    private final List<MonitoredConnectionFactory> monitoredFactories;
    private final ReferenceCountedObject.Reference scheduler;
    private final Object stateLock = new Object();
    private volatile ErrorResultException lastFailure = null;
    private final LoadBalancerEventListener listener;
    private final Object listenerLock = new Object();
    private int offlineFactoriesCount = 0;
    private final long monitoringInterval;
    private final TimeUnit monitoringIntervalTimeUnit;
    private ScheduledFuture<?> monitoringFuture;
    private AtomicBoolean isClosed = new AtomicBoolean();

    AbstractLoadBalancingAlgorithm(Collection<? extends ConnectionFactory> factories, LoadBalancerEventListener listener, long interval, TimeUnit unit, ScheduledExecutorService scheduler) {
        Validator.ensureNotNull(factories, (Object)unit);
        this.monitoredFactories = new ArrayList<MonitoredConnectionFactory>(factories.size());
        int i = 0;
        for (ConnectionFactory connectionFactory : factories) {
            this.monitoredFactories.add(new MonitoredConnectionFactory(connectionFactory, i++));
        }
        this.scheduler = StaticUtils.DEFAULT_SCHEDULER.acquireIfNull(scheduler);
        this.monitoringInterval = interval;
        this.monitoringIntervalTimeUnit = unit;
        this.listener = listener != null ? listener : DEFAULT_LISTENER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            Object object = this.stateLock;
            synchronized (object) {
                if (this.monitoringFuture != null) {
                    this.monitoringFuture.cancel(false);
                    this.monitoringFuture = null;
                }
            }
            for (ConnectionFactory connectionFactory : this.monitoredFactories) {
                connectionFactory.close();
            }
            this.scheduler.release();
        }
    }

    @Override
    public final ConnectionFactory getConnectionFactory() throws ErrorResultException {
        int index = this.getInitialConnectionFactoryIndex();
        return this.getMonitoredConnectionFactory(index);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getAlgorithmName());
        builder.append('(');
        boolean isFirst = true;
        for (ConnectionFactory connectionFactory : this.monitoredFactories) {
            if (!isFirst) {
                builder.append(',');
            } else {
                isFirst = false;
            }
            builder.append(connectionFactory);
        }
        builder.append(')');
        return builder.toString();
    }

    abstract String getAlgorithmName();

    abstract int getInitialConnectionFactoryIndex();

    private MonitoredConnectionFactory getMonitoredConnectionFactory(int initialIndex) throws ErrorResultException {
        int index = initialIndex;
        int maxIndex = this.monitoredFactories.size();
        do {
            MonitoredConnectionFactory factory;
            if (!(factory = this.monitoredFactories.get(index)).isOperational.get()) continue;
            return factory;
        } while ((index = (index + 1) % maxIndex) != initialIndex);
        throw ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_CONNECT_ERROR, "No operational connection factories available", (Throwable)this.lastFailure);
    }

    private final class MonitorRunnable
    implements Runnable {
        private MonitorRunnable() {
        }

        @Override
        public void run() {
            for (MonitoredConnectionFactory factory : AbstractLoadBalancingAlgorithm.this.monitoredFactories) {
                factory.checkIfAvailable();
            }
        }
    }

    private final class MonitoredConnectionFactory
    implements ConnectionFactory,
    ResultHandler<Connection> {
        private final ConnectionFactory factory;
        private final AtomicBoolean isOperational = new AtomicBoolean(true);
        private volatile FutureResult<?> pendingConnectFuture = null;
        private final int index;

        private MonitoredConnectionFactory(ConnectionFactory factory, int index) {
            this.factory = factory;
            this.index = index;
        }

        @Override
        public void close() {
            this.factory.close();
        }

        @Override
        public Connection getConnection() throws ErrorResultException {
            Connection connection;
            try {
                connection = this.factory.getConnection();
            }
            catch (ErrorResultException e) {
                this.notifyOffline(e);
                int nextIndex = (this.index + 1) % AbstractLoadBalancingAlgorithm.this.monitoredFactories.size();
                MonitoredConnectionFactory nextFactory = AbstractLoadBalancingAlgorithm.this.getMonitoredConnectionFactory(nextIndex);
                return nextFactory.getConnection();
            }
            this.notifyOnline();
            return connection;
        }

        @Override
        public FutureResult<Connection> getConnectionAsync(ResultHandler<? super Connection> resultHandler) {
            final AsynchronousFutureResult future = new AsynchronousFutureResult(resultHandler);
            ResultHandler<Connection> failoverHandler = new ResultHandler<Connection>(){

                @Override
                public void handleErrorResult(ErrorResultException error) {
                    MonitoredConnectionFactory.this.notifyOffline(error);
                    int nextIndex = (MonitoredConnectionFactory.this.index + 1) % AbstractLoadBalancingAlgorithm.this.monitoredFactories.size();
                    try {
                        MonitoredConnectionFactory nextFactory = AbstractLoadBalancingAlgorithm.this.getMonitoredConnectionFactory(nextIndex);
                        nextFactory.getConnectionAsync(future);
                    }
                    catch (ErrorResultException e) {
                        future.handleErrorResult(e);
                    }
                }

                @Override
                public void handleResult(Connection result) {
                    MonitoredConnectionFactory.this.notifyOnline();
                    future.handleResult(result);
                }
            };
            this.factory.getConnectionAsync((ResultHandler<? super Connection>)failoverHandler);
            return future;
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            this.notifyOffline(error);
        }

        @Override
        public void handleResult(Connection connection) {
            connection.close();
            this.notifyOnline();
        }

        public String toString() {
            return this.factory.toString();
        }

        private synchronized void checkIfAvailable() {
            if (!this.isOperational.get() && (this.pendingConnectFuture == null || this.pendingConnectFuture.isDone())) {
                if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                    StaticUtils.DEBUG_LOG.fine(String.format("Attempting reconnect to offline factory '%s'", this));
                }
                this.pendingConnectFuture = this.factory.getConnectionAsync(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyOffline(ErrorResultException error) {
            AbstractLoadBalancingAlgorithm.this.lastFailure = error;
            if (this.isOperational.getAndSet(false)) {
                Object object = AbstractLoadBalancingAlgorithm.this.listenerLock;
                synchronized (object) {
                    try {
                        AbstractLoadBalancingAlgorithm.this.listener.handleConnectionFactoryOffline(this.factory, error);
                    }
                    catch (RuntimeException e) {
                        this.handleListenerException(e);
                    }
                }
                object = AbstractLoadBalancingAlgorithm.this.stateLock;
                synchronized (object) {
                    AbstractLoadBalancingAlgorithm.this.offlineFactoriesCount++;
                    if (AbstractLoadBalancingAlgorithm.this.offlineFactoriesCount == 1) {
                        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                            StaticUtils.DEBUG_LOG.fine(String.format("Starting monitoring thread", new Object[0]));
                        }
                        AbstractLoadBalancingAlgorithm.this.monitoringFuture = ((ScheduledExecutorService)AbstractLoadBalancingAlgorithm.this.scheduler.get()).scheduleWithFixedDelay(new MonitorRunnable(), 0L, AbstractLoadBalancingAlgorithm.this.monitoringInterval, AbstractLoadBalancingAlgorithm.this.monitoringIntervalTimeUnit);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyOnline() {
            if (!this.isOperational.getAndSet(true)) {
                Object object = AbstractLoadBalancingAlgorithm.this.listenerLock;
                synchronized (object) {
                    try {
                        AbstractLoadBalancingAlgorithm.this.listener.handleConnectionFactoryOnline(this.factory);
                    }
                    catch (RuntimeException e) {
                        this.handleListenerException(e);
                    }
                }
                object = AbstractLoadBalancingAlgorithm.this.stateLock;
                synchronized (object) {
                    AbstractLoadBalancingAlgorithm.this.offlineFactoriesCount--;
                    if (AbstractLoadBalancingAlgorithm.this.offlineFactoriesCount == 0) {
                        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINE)) {
                            StaticUtils.DEBUG_LOG.fine(String.format("Stopping monitoring thread", new Object[0]));
                        }
                        AbstractLoadBalancingAlgorithm.this.monitoringFuture.cancel(false);
                        AbstractLoadBalancingAlgorithm.this.monitoringFuture = null;
                    }
                }
            }
        }

        private void handleListenerException(RuntimeException e) {
            if (StaticUtils.DEBUG_LOG.isLoggable(Level.SEVERE)) {
                StaticUtils.DEBUG_LOG.log(Level.SEVERE, "A run-time error occurred while processing a load-balancer event", e);
            }
        }
    }
}

