/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.util.Comparator;

public final class Pair<F, S> {
    public static final Pair<?, ?> EMPTY = Pair.of(null, null);
    public static final Comparator COMPARATOR = new ComparablePairComparator();
    private final F first;
    private final S second;

    private Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public static <F, S> Pair<F, S> of(F first, S second) {
        return new Pair<F, S>(first, second);
    }

    public static <F, S> Pair<F, S> empty() {
        return EMPTY;
    }

    public static <F extends Comparable<F>, S extends Comparable<S>> Comparator<Pair<F, S>> getPairComparator() {
        return COMPARATOR;
    }

    public F getFirst() {
        return this.first;
    }

    public S getSecond() {
        return this.second;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.first == null ? 0 : this.first.hashCode());
        result = 31 * result + (this.second == null ? 0 : this.second.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Pair)) {
            return false;
        }
        Pair other = (Pair)obj;
        if (this.first == null ? other.first != null : !this.first.equals(other.first)) {
            return false;
        }
        return !(this.second == null ? other.second != null : !this.second.equals(other.second));
    }

    public String toString() {
        return "Pair [" + this.first + ", " + this.second + "]";
    }

    private static final class ComparablePairComparator<F extends Comparable<F>, S extends Comparable<S>>
    implements Comparator<Pair<F, S>> {
        private ComparablePairComparator() {
        }

        @Override
        public int compare(Pair<F, S> o1, Pair<F, S> o2) {
            int compareResult = ((Comparable)o1.getFirst()).compareTo(o2.getFirst());
            if (compareResult == 0) {
                return ((Comparable)o1.getSecond()).compareTo(o2.getSecond());
            }
            return compareResult;
        }
    }
}

