/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import com.forgerock.opendj.util.Predicate;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.forgerock.opendj.ldap.Function;

public final class Iterators {
    private static final Iterator<Object> EMPTY_ITERATOR = new EmptyIterator<Object>();

    public static <M> Iterator<M> arrayIterator(M[] a) {
        return new ArrayIterator(a);
    }

    public static <M> Iterator<M> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static <M, P> Iterator<M> filteredIterator(Iterator<M> iterator, Predicate<? super M, P> predicate, P p) {
        return new FilteredIterator(iterator, predicate, p);
    }

    public static <M> Iterator<M> filteredIterator(Iterator<M> iterator, Predicate<? super M, Void> predicate) {
        return new FilteredIterator(iterator, predicate, null);
    }

    public static <M> Iterator<M> singletonIterator(M value) {
        return new SingletonIterator(value);
    }

    public static <M, N, P> Iterator<N> transformedIterator(Iterator<M> iterator, Function<? super M, ? extends N, P> function, P p) {
        return new TransformedIterator(iterator, function, p);
    }

    public static <M, N> Iterator<N> transformedIterator(Iterator<M> iterator, Function<? super M, ? extends N, Void> function) {
        return new TransformedIterator(iterator, function, null);
    }

    public static <M> Iterator<M> unmodifiableIterator(Iterator<M> iterator) {
        return new UnmodifiableIterator(iterator);
    }

    private Iterators() {
    }

    private static final class UnmodifiableIterator<M>
    implements Iterator<M> {
        private final Iterator<M> iterator;

        private UnmodifiableIterator(Iterator<M> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public M next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class TransformedIterator<M, N, P>
    implements Iterator<N> {
        private final Function<? super M, ? extends N, P> function;
        private final Iterator<M> iterator;
        private final P parameter;

        private TransformedIterator(Iterator<M> iterator, Function<? super M, ? extends N, P> function, P p) {
            this.iterator = iterator;
            this.function = function;
            this.parameter = p;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public N next() {
            return this.function.apply(this.iterator.next(), this.parameter);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static final class SingletonIterator<M>
    implements Iterator<M> {
        private M value;

        private SingletonIterator(M value) {
            this.value = value;
        }

        @Override
        public boolean hasNext() {
            return this.value != null;
        }

        @Override
        public M next() {
            if (this.value != null) {
                M tmp = this.value;
                this.value = null;
                return tmp;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class FilteredIterator<M, P>
    implements Iterator<M> {
        private boolean hasNextMustIterate = true;
        private final Iterator<M> iterator;
        private M next = null;
        private final P parameter;
        private final Predicate<? super M, P> predicate;

        private FilteredIterator(Iterator<M> iterator, Predicate<? super M, P> predicate, P p) {
            this.iterator = iterator;
            this.predicate = predicate;
            this.parameter = p;
        }

        @Override
        public boolean hasNext() {
            if (this.hasNextMustIterate) {
                this.hasNextMustIterate = false;
                while (this.iterator.hasNext()) {
                    this.next = this.iterator.next();
                    if (!this.predicate.matches(this.next, this.parameter)) continue;
                    return true;
                }
                this.next = null;
                return false;
            }
            return this.next != null;
        }

        @Override
        public M next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNextMustIterate = true;
            return this.next;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static final class EmptyIterator<M>
    implements Iterator<M> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public M next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ArrayIterator<M>
    implements Iterator<M> {
        private int i = 0;
        private final M[] a;

        private ArrayIterator(M[] a) {
            this.a = a;
        }

        @Override
        public boolean hasNext() {
            return this.i < this.a.length;
        }

        @Override
        public M next() {
            if (this.hasNext()) {
                return this.a[this.i++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

