/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.FutureResult;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;

public class AsynchronousFutureResult<M, H extends ResultHandler<? super M>>
implements FutureResult<M>,
ResultHandler<M> {
    private final Sync sync = new Sync();
    private final H handler;
    private final int requestID;

    public AsynchronousFutureResult(H handler) {
        this(handler, -1);
    }

    public AsynchronousFutureResult(H handler, int requestID) {
        this.handler = handler;
        this.requestID = requestID;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        return this.sync.innerCancel(mayInterruptIfRunning);
    }

    @Override
    public final M get() throws ErrorResultException, InterruptedException {
        return this.sync.innerGet();
    }

    @Override
    public final M get(long timeout, TimeUnit unit) throws ErrorResultException, TimeoutException, InterruptedException {
        return this.sync.innerGet(unit.toNanos(timeout));
    }

    public H getResultHandler() {
        return this.handler;
    }

    @Override
    public int getRequestID() {
        return this.requestID;
    }

    @Override
    public final void handleErrorResult(ErrorResultException errorResult) {
        this.sync.innerSetErrorResult(errorResult);
    }

    @Override
    public final void handleResult(M result) {
        this.sync.innerSetResult(result);
    }

    public final boolean tryHandleErrorResult(ErrorResultException errorResult) {
        return this.sync.innerSetErrorResult(errorResult);
    }

    public final boolean tryHandleResult(M result) {
        return this.sync.innerSetResult(result);
    }

    @Override
    public final boolean isCancelled() {
        return this.sync.innerIsCancelled();
    }

    @Override
    public final boolean isDone() {
        return this.sync.innerIsDone();
    }

    protected ErrorResultException handleCancelRequest(boolean mayInterruptIfRunning) {
        return null;
    }

    protected boolean isCancelable() {
        return true;
    }

    protected void toString(StringBuilder sb) {
        sb.append(" state = ");
        sb.append(this.sync);
    }

    private final class Sync
    extends AbstractQueuedSynchronizer {
        private static final int WAITING = 0;
        private static final int PENDING = 1;
        private static final int CANCELLED = 2;
        private static final int FAIL = 3;
        private static final int SUCCESS = 4;
        private ErrorResultException errorResult = null;
        private M result = null;

        private Sync() {
        }

        @Override
        protected int tryAcquireShared(int ignore) {
            return this.innerIsDone() ? 1 : -1;
        }

        @Override
        protected boolean tryReleaseShared(int finalState) {
            this.setState(finalState);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean innerCancel(boolean mayInterruptIfRunning) {
            if (!AsynchronousFutureResult.this.isCancelable() || !this.setStatePending()) {
                return false;
            }
            ErrorResultException errorResult = AsynchronousFutureResult.this.handleCancelRequest(mayInterruptIfRunning);
            if (errorResult == null) {
                errorResult = ErrorResultException.newErrorResult(ResultCode.CLIENT_SIDE_USER_CANCELLED);
            }
            this.errorResult = errorResult;
            try {
                if (AsynchronousFutureResult.this.handler != null) {
                    AsynchronousFutureResult.this.handler.handleErrorResult(errorResult);
                }
            }
            finally {
                this.releaseShared(2);
            }
            return true;
        }

        M innerGet() throws ErrorResultException, InterruptedException {
            this.acquireSharedInterruptibly(0);
            return this.get0();
        }

        M innerGet(long nanosTimeout) throws ErrorResultException, TimeoutException, InterruptedException {
            if (!this.tryAcquireSharedNanos(0, nanosTimeout)) {
                throw new TimeoutException();
            }
            return this.get0();
        }

        boolean innerIsCancelled() {
            return this.getState() == 2;
        }

        boolean innerIsDone() {
            return this.getState() > 1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean innerSetErrorResult(ErrorResultException errorResult) {
            if (!this.setStatePending()) {
                return false;
            }
            this.errorResult = errorResult;
            try {
                if (AsynchronousFutureResult.this.handler != null) {
                    AsynchronousFutureResult.this.handler.handleErrorResult(errorResult);
                }
            }
            finally {
                this.releaseShared(3);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean innerSetResult(M result) {
            if (!this.setStatePending()) {
                return false;
            }
            this.result = result;
            try {
                if (AsynchronousFutureResult.this.handler != null) {
                    AsynchronousFutureResult.this.handler.handleResult(result);
                }
            }
            finally {
                this.releaseShared(4);
            }
            return true;
        }

        private M get0() throws ErrorResultException {
            if (this.errorResult != null) {
                throw this.errorResult;
            }
            return this.result;
        }

        private boolean setStatePending() {
            int s;
            do {
                if ((s = this.getState()) == 0) continue;
                return false;
            } while (!this.compareAndSetState(s, 1));
            return true;
        }
    }
}

