/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap.controls;

import com.forgerock.opendj.util.Validator;
import org.forgerock.i18n.LocalizableMessage;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.CoreMessages;
import org.forgerock.opendj.ldap.DecodeException;
import org.forgerock.opendj.ldap.DecodeOptions;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.controls.ControlDecoder;

public final class AccountUsabilityRequestControl
implements Control {
    public static final String OID = "1.3.6.1.4.1.42.2.27.9.5.8";
    private final boolean isCritical;
    private static final AccountUsabilityRequestControl CRITICAL_INSTANCE = new AccountUsabilityRequestControl(true);
    private static final AccountUsabilityRequestControl NONCRITICAL_INSTANCE = new AccountUsabilityRequestControl(false);
    public static final ControlDecoder<AccountUsabilityRequestControl> DECODER = new ControlDecoder<AccountUsabilityRequestControl>(){

        @Override
        public AccountUsabilityRequestControl decodeControl(Control control, DecodeOptions options) throws DecodeException {
            Validator.ensureNotNull(control);
            if (control instanceof AccountUsabilityRequestControl) {
                return (AccountUsabilityRequestControl)control;
            }
            if (!control.getOID().equals(AccountUsabilityRequestControl.OID)) {
                LocalizableMessage message = CoreMessages.ERR_ACCTUSABLEREQ_CONTROL_BAD_OID.get((Object)control.getOID(), (Object)AccountUsabilityRequestControl.OID);
                throw DecodeException.error(message);
            }
            if (control.hasValue()) {
                LocalizableMessage message = CoreMessages.ERR_ACCTUSABLEREQ_CONTROL_HAS_VALUE.get();
                throw DecodeException.error(message);
            }
            return control.isCritical() ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
        }

        @Override
        public String getOID() {
            return AccountUsabilityRequestControl.OID;
        }
    };

    public static AccountUsabilityRequestControl newControl(boolean isCritical) {
        return isCritical ? CRITICAL_INSTANCE : NONCRITICAL_INSTANCE;
    }

    private AccountUsabilityRequestControl(boolean isCritical) {
        this.isCritical = isCritical;
    }

    @Override
    public String getOID() {
        return OID;
    }

    @Override
    public ByteString getValue() {
        return null;
    }

    @Override
    public boolean hasValue() {
        return false;
    }

    @Override
    public boolean isCritical() {
        return this.isCritical;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AccountUsableRequestControl(oid=");
        builder.append(this.getOID());
        builder.append(", criticality=");
        builder.append(this.isCritical());
        builder.append(")");
        return builder.toString();
    }
}

