/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.TimeoutEventListener;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;

public final class TimeoutChecker {
    public static final ReferenceCountedObject<TimeoutChecker> TIMEOUT_CHECKER = new ReferenceCountedObject<TimeoutChecker>(){

        @Override
        protected void destroyInstance(TimeoutChecker instance) {
            instance.shutdown();
        }

        @Override
        protected TimeoutChecker newInstance() {
            return new TimeoutChecker();
        }
    };
    private final Object stateLock = new Object();
    private final Set<TimeoutEventListener> listeners = Collections.newSetFromMap(new ConcurrentHashMap());
    private volatile boolean shutdownRequested = false;
    private volatile long pendingListenerMinDelay = Long.MAX_VALUE;

    private TimeoutChecker() {
        Thread checkerThread = new Thread("OpenDJ LDAP SDK Timeout Checker"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StaticUtils.DEBUG_LOG.fine("Timeout Checker Starting");
                while (!TimeoutChecker.this.shutdownRequested) {
                    long currentTime = System.currentTimeMillis();
                    long delay = Long.MAX_VALUE;
                    TimeoutChecker.this.pendingListenerMinDelay = Long.MAX_VALUE;
                    for (TimeoutEventListener listener : TimeoutChecker.this.listeners) {
                        long newDelay;
                        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
                            StaticUtils.DEBUG_LOG.finer("Checking listener " + listener + " delay = " + delay);
                        }
                        if ((newDelay = listener.handleTimeout(currentTime)) <= 0L) continue;
                        delay = Math.min(newDelay, delay);
                    }
                    try {
                        Object i$ = TimeoutChecker.this.stateLock;
                        synchronized (i$) {
                            delay = Math.min(TimeoutChecker.this.pendingListenerMinDelay, delay);
                            if (TimeoutChecker.this.shutdownRequested) {
                                break;
                            }
                            if (delay <= 0L) {
                                TimeoutChecker.this.stateLock.wait();
                            } else {
                                TimeoutChecker.this.stateLock.wait(delay);
                            }
                        }
                    }
                    catch (InterruptedException e) {
                        TimeoutChecker.this.shutdownRequested = true;
                    }
                }
            }
        };
        checkerThread.setDaemon(true);
        checkerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TimeoutEventListener listener) {
        long timeout = listener.getTimeout();
        if (timeout > 0L) {
            this.listeners.add(listener);
            Object object = this.stateLock;
            synchronized (object) {
                this.pendingListenerMinDelay = Math.min(this.pendingListenerMinDelay, timeout);
                this.stateLock.notifyAll();
            }
        }
    }

    public void removeListener(TimeoutEventListener listener) {
        this.listeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutdown() {
        Object object = this.stateLock;
        synchronized (object) {
            this.shutdownRequested = true;
            this.stateLock.notifyAll();
        }
    }
}

