/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.LDAPMessageHandler;
import com.forgerock.opendj.ldap.LDAPUtils;
import com.forgerock.opendj.util.StaticUtils;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.forgerock.opendj.asn1.ASN1Writer;
import org.forgerock.opendj.ldap.Attribute;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.DN;
import org.forgerock.opendj.ldap.Modification;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.Request;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Response;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

final class LDAPWriter
implements LDAPMessageHandler<ASN1Writer> {
    LDAPWriter() {
    }

    public static void encodeControl(ASN1Writer writer, Control control) throws IOException {
        writer.writeStartSequence();
        writer.writeOctetString(control.getOID());
        if (control.isCritical()) {
            writer.writeBoolean(control.isCritical());
        }
        if (control.getValue() != null) {
            writer.writeOctetString(control.getValue());
        }
        writer.writeEndSequence();
    }

    public static void encodeEntry(ASN1Writer writer, SearchResultEntry searchResultEntry) throws IOException {
        writer.writeStartSequence((byte)100);
        writer.writeOctetString(searchResultEntry.getName().toString());
        writer.writeStartSequence();
        for (Attribute attr : searchResultEntry.getAllAttributes()) {
            LDAPWriter.encodeAttribute(writer, attr);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    private static void encodeAttribute(ASN1Writer writer, Attribute attribute) throws IOException {
        writer.writeStartSequence();
        writer.writeOctetString(attribute.getAttributeDescriptionAsString());
        writer.writeStartSet();
        for (ByteString value : attribute) {
            writer.writeOctetString(value);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
    }

    private static void encodeChange(ASN1Writer writer, Modification change) throws IOException {
        writer.writeStartSequence();
        writer.writeEnumerated(change.getModificationType().intValue());
        LDAPWriter.encodeAttribute(writer, change.getAttribute());
        writer.writeEndSequence();
    }

    private static void encodeMessageFooter(ASN1Writer writer, Request request) throws IOException {
        List<Control> controls = request.getControls();
        if (!controls.isEmpty()) {
            writer.writeStartSequence((byte)-96);
            for (Control control : controls) {
                LDAPWriter.encodeControl(writer, control);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
    }

    private static void encodeMessageFooter(ASN1Writer writer, Response response) throws IOException {
        List<Control> controls = response.getControls();
        if (!controls.isEmpty()) {
            writer.writeStartSequence((byte)-96);
            for (Control control : controls) {
                LDAPWriter.encodeControl(writer, control);
            }
            writer.writeEndSequence();
        }
        writer.writeEndSequence();
    }

    private static void encodeMessageHeader(ASN1Writer writer, int messageID) throws IOException {
        writer.writeStartSequence();
        writer.writeInteger(messageID);
    }

    private static void encodeResultFooter(ASN1Writer writer) throws IOException {
        writer.writeEndSequence();
    }

    private static void encodeResultHeader(ASN1Writer writer, byte typeTag, Result rawMessage) throws IOException {
        writer.writeStartSequence(typeTag);
        writer.writeEnumerated(rawMessage.getResultCode().intValue());
        writer.writeOctetString(rawMessage.getMatchedDN());
        writer.writeOctetString(rawMessage.getDiagnosticMessage());
        List<String> referralURIs = rawMessage.getReferralURIs();
        if (!referralURIs.isEmpty()) {
            writer.writeStartSequence((byte)-93);
            for (String s : referralURIs) {
                writer.writeOctetString(s);
            }
            writer.writeEndSequence();
        }
    }

    @Override
    public void abandonRequest(ASN1Writer writer, int messageID, AbandonRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP ABANDON REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeInteger((byte)80, request.getRequestID());
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void addRequest(ASN1Writer writer, int messageID, AddRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP ADD REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)104);
        writer.writeOctetString(request.getName().toString());
        writer.writeStartSequence();
        for (Attribute attr : request.getAllAttributes()) {
            LDAPWriter.encodeAttribute(writer, attr);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void addResult(ASN1Writer writer, int messageID, Result result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP ADD RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)105, result);
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void bindRequest(ASN1Writer writer, int messageID, int version, GenericBindRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP BIND REQUEST(messageID=%d, auth=0x%x, request=%s)", messageID, request.getAuthenticationType(), request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)96);
        writer.writeInteger(version);
        writer.writeOctetString(request.getName());
        writer.writeOctetString(request.getAuthenticationType(), request.getAuthenticationValue());
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void bindResult(ASN1Writer writer, int messageID, BindResult result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP BIND RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)97, result);
        ByteString saslCredentials = result.getServerSASLCredentials();
        if (saslCredentials != null && saslCredentials.length() > 0) {
            writer.writeOctetString((byte)-121, result.getServerSASLCredentials());
        }
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void compareRequest(ASN1Writer writer, int messageID, CompareRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP COMPARE REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)110);
        writer.writeOctetString(request.getName().toString());
        writer.writeStartSequence();
        writer.writeOctetString(request.getAttributeDescription().toString());
        writer.writeOctetString(request.getAssertionValue());
        writer.writeEndSequence();
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void compareResult(ASN1Writer writer, int messageID, CompareResult result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP COMPARE RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)111, result);
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void deleteRequest(ASN1Writer writer, int messageID, DeleteRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP DELETE REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeOctetString((byte)74, request.getName().toString());
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void deleteResult(ASN1Writer writer, int messageID, Result result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP DELETE RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)107, result);
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public <R extends ExtendedResult> void extendedRequest(ASN1Writer writer, int messageID, ExtendedRequest<R> request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP EXTENDED REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)119);
        writer.writeOctetString((byte)-128, request.getOID());
        ByteString requestValue = request.getValue();
        if (requestValue != null) {
            writer.writeOctetString((byte)-127, requestValue);
        }
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void extendedResult(ASN1Writer writer, int messageID, ExtendedResult result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP EXTENDED RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)120, result);
        String responseName = result.getOID();
        ByteString responseValue = result.getValue();
        if (responseName != null) {
            writer.writeOctetString((byte)-118, responseName);
        }
        if (responseValue != null) {
            writer.writeOctetString((byte)-117, responseValue);
        }
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void intermediateResponse(ASN1Writer writer, int messageID, IntermediateResponse response) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP INTERMEDIATE RESPONSE(messageID=%d, response=%s)", messageID, response));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)121);
        String responseName = response.getOID();
        ByteString responseValue = response.getValue();
        if (responseName != null) {
            writer.writeOctetString((byte)-128, response.getOID());
        }
        if (responseValue != null) {
            writer.writeOctetString((byte)-127, response.getValue());
        }
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, response);
    }

    @Override
    public void modifyDNRequest(ASN1Writer writer, int messageID, ModifyDNRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP MODIFY DN REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)108);
        writer.writeOctetString(request.getName().toString());
        writer.writeOctetString(request.getNewRDN().toString());
        writer.writeBoolean(request.isDeleteOldRDN());
        DN newSuperior = request.getNewSuperior();
        if (newSuperior != null) {
            writer.writeOctetString((byte)-128, newSuperior.toString());
        }
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void modifyDNResult(ASN1Writer writer, int messageID, Result result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP MODIFY DN RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)109, result);
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void modifyRequest(ASN1Writer writer, int messageID, ModifyRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP MODIFY REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)102);
        writer.writeOctetString(request.getName().toString());
        writer.writeStartSequence();
        for (Modification change : request.getModifications()) {
            LDAPWriter.encodeChange(writer, change);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void modifyResult(ASN1Writer writer, int messageID, Result result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP MODIFY RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)103, result);
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void searchRequest(ASN1Writer writer, int messageID, SearchRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP SEARCH REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)99);
        writer.writeOctetString(request.getName().toString());
        writer.writeEnumerated(request.getScope().intValue());
        writer.writeEnumerated(request.getDereferenceAliasesPolicy().intValue());
        writer.writeInteger(request.getSizeLimit());
        writer.writeInteger(request.getTimeLimit());
        writer.writeBoolean(request.isTypesOnly());
        LDAPUtils.encodeFilter(writer, request.getFilter());
        writer.writeStartSequence();
        for (String attribute : request.getAttributes()) {
            writer.writeOctetString(attribute);
        }
        writer.writeEndSequence();
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void searchResult(ASN1Writer writer, int messageID, Result result) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP SEARCH RESULT(messageID=%d, result=%s)", messageID, result));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeResultHeader(writer, (byte)101, result);
        LDAPWriter.encodeResultFooter(writer);
        LDAPWriter.encodeMessageFooter(writer, result);
    }

    @Override
    public void searchResultEntry(ASN1Writer writer, int messageID, SearchResultEntry entry) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP SEARCH RESULT ENTRY(messageID=%d, entry=%s)", messageID, entry));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        LDAPWriter.encodeEntry(writer, entry);
        LDAPWriter.encodeMessageFooter(writer, entry);
    }

    @Override
    public void searchResultReference(ASN1Writer writer, int messageID, SearchResultReference reference) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP SEARCH RESULT REFERENCE(messageID=%d, reference=%s)", messageID, reference));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeStartSequence((byte)115);
        for (String url : reference.getURIs()) {
            writer.writeOctetString(url);
        }
        writer.writeEndSequence();
        LDAPWriter.encodeMessageFooter(writer, reference);
    }

    @Override
    public void unbindRequest(ASN1Writer writer, int messageID, UnbindRequest request) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP UNBIND REQUEST(messageID=%d, request=%s)", messageID, request));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeNull((byte)66);
        LDAPWriter.encodeMessageFooter(writer, request);
    }

    @Override
    public void unrecognizedMessage(ASN1Writer writer, int messageID, byte messageTag, ByteString messageBytes) throws IOException {
        if (StaticUtils.DEBUG_LOG.isLoggable(Level.FINER)) {
            StaticUtils.DEBUG_LOG.finer(String.format("ENCODE LDAP UNKNOWN MESSAGE(messageID=%d, messageTag=%s, messageBytes=%s)", messageID, StaticUtils.byteToHex(messageTag), messageBytes.toString()));
        }
        LDAPWriter.encodeMessageHeader(writer, messageID);
        writer.writeOctetString(messageTag, messageBytes);
        writer.writeEndSequence();
    }
}

