/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.ASN1BufferReader;
import com.forgerock.opendj.ldap.ASN1BufferWriter;
import com.forgerock.opendj.ldap.AbstractLDAPMessageHandler;
import com.forgerock.opendj.ldap.ConnectionSecurityLayerFilter;
import com.forgerock.opendj.ldap.GrizzlyUtils;
import com.forgerock.opendj.ldap.LDAPListenerImpl;
import com.forgerock.opendj.ldap.LDAPReader;
import com.forgerock.opendj.ldap.LDAPWriter;
import com.forgerock.opendj.ldap.UnexpectedRequestException;
import com.forgerock.opendj.ldap.UnsupportedMessageException;
import com.forgerock.opendj.util.Validator;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.forgerock.opendj.ldap.ByteString;
import org.forgerock.opendj.ldap.ConnectionSecurityLayer;
import org.forgerock.opendj.ldap.ErrorResultException;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListenerOptions;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.ResultHandler;
import org.forgerock.opendj.ldap.SSLContextBuilder;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.ServerConnection;
import org.forgerock.opendj.ldap.TrustManagers;
import org.forgerock.opendj.ldap.controls.Control;
import org.forgerock.opendj.ldap.requests.AbandonRequest;
import org.forgerock.opendj.ldap.requests.AddRequest;
import org.forgerock.opendj.ldap.requests.CompareRequest;
import org.forgerock.opendj.ldap.requests.DeleteRequest;
import org.forgerock.opendj.ldap.requests.ExtendedRequest;
import org.forgerock.opendj.ldap.requests.GenericBindRequest;
import org.forgerock.opendj.ldap.requests.ModifyDNRequest;
import org.forgerock.opendj.ldap.requests.ModifyRequest;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.requests.UnbindRequest;
import org.forgerock.opendj.ldap.responses.BindResult;
import org.forgerock.opendj.ldap.responses.CompareResult;
import org.forgerock.opendj.ldap.responses.ExtendedResult;
import org.forgerock.opendj.ldap.responses.GenericExtendedResult;
import org.forgerock.opendj.ldap.responses.IntermediateResponse;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;
import org.glassfish.grizzly.Buffer;
import org.glassfish.grizzly.Connection;
import org.glassfish.grizzly.Grizzly;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.attributes.Attribute;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.filterchain.BaseFilter;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.FilterChainContext;
import org.glassfish.grizzly.filterchain.NextAction;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.grizzly.ssl.SSLFilter;
import org.glassfish.grizzly.ssl.SSLUtils;

final class LDAPServerFilter
extends BaseFilter {
    private static final Object[][] CIPHER_KEY_SIZES = new Object[][]{{"_WITH_AES_256_CBC_", 256}, {"_WITH_CAMELLIA_256_CBC_", 256}, {"_WITH_AES_256_GCM_", 256}, {"_WITH_3DES_EDE_CBC_", 112}, {"_WITH_AES_128_GCM_", 128}, {"_WITH_SEED_CBC_", 128}, {"_WITH_CAMELLIA_128_CBC_", 128}, {"_WITH_AES_128_CBC_", 128}, {"_WITH_IDEA_CBC_", 128}, {"_WITH_RC4_128_", 128}, {"_WITH_FORTEZZA_CBC_", 96}, {"_WITH_DES_CBC_", 56}, {"_WITH_RC4_56_", 56}, {"_WITH_RC2_CBC_40_", 40}, {"_WITH_DES_CBC_40_", 40}, {"_WITH_RC4_40_", 40}, {"_WITH_DES40_CBC_", 40}, {"_WITH_NULL_", 0}};
    private static final int DEFAULT_MAX_REQUEST_SIZE = 0x500000;
    private static final Attribute<ASN1BufferReader> LDAP_ASN1_READER_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("LDAPASN1Reader");
    private static final Attribute<ClientContextImpl> LDAP_CONNECTION_ATTR = Grizzly.DEFAULT_ATTRIBUTE_BUILDER.createAttribute("LDAPServerConnection");
    private static final LDAPWriter LDAP_WRITER = new LDAPWriter();
    private static final SSLEngineConfigurator DUMMY_SSL_ENGINE_CONFIGURATOR;
    private final LDAPReader ldapReader;
    private final LDAPListenerImpl listener;
    private final int maxASN1ElementSize;
    private final AbstractLDAPMessageHandler<FilterChainContext> serverRequestHandler = new AbstractLDAPMessageHandler<FilterChainContext>(){

        @Override
        public void abandonRequest(FilterChainContext ctx, int messageID, AbandonRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                conn.handleAbandon(messageID, request);
            }
        }

        @Override
        public void addRequest(FilterChainContext ctx, int messageID, AddRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                AddHandler handler = new AddHandler(clientContext, messageID);
                conn.handleAdd(messageID, request, handler, handler);
            }
        }

        @Override
        public void bindRequest(FilterChainContext ctx, int messageID, int version, GenericBindRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                BindHandler handler = new BindHandler(clientContext, messageID);
                conn.handleBind(messageID, version, request, handler, handler);
            }
        }

        @Override
        public void compareRequest(FilterChainContext ctx, int messageID, CompareRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                CompareHandler handler = new CompareHandler(clientContext, messageID);
                conn.handleCompare(messageID, request, handler, handler);
            }
        }

        @Override
        public void deleteRequest(FilterChainContext ctx, int messageID, DeleteRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                DeleteHandler handler = new DeleteHandler(clientContext, messageID);
                conn.handleDelete(messageID, request, handler, handler);
            }
        }

        @Override
        public <R extends ExtendedResult> void extendedRequest(FilterChainContext ctx, int messageID, ExtendedRequest<R> request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                ExtendedHandler handler = new ExtendedHandler(clientContext, messageID);
                conn.handleExtendedRequest(messageID, request, handler, handler);
            }
        }

        @Override
        public void modifyDNRequest(FilterChainContext ctx, int messageID, ModifyDNRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                ModifyDNHandler handler = new ModifyDNHandler(clientContext, messageID);
                conn.handleModifyDN(messageID, request, handler, handler);
            }
        }

        @Override
        public void modifyRequest(FilterChainContext ctx, int messageID, ModifyRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                ModifyHandler handler = new ModifyHandler(clientContext, messageID);
                conn.handleModify(messageID, request, handler, handler);
            }
        }

        @Override
        public void searchRequest(FilterChainContext ctx, int messageID, SearchRequest request) throws UnexpectedRequestException {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.get((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                ServerConnection conn = clientContext.getServerConnection();
                SearchHandler handler = new SearchHandler(clientContext, messageID);
                conn.handleSearch(messageID, request, handler, handler);
            }
        }

        @Override
        public void unbindRequest(FilterChainContext ctx, int messageID, UnbindRequest request) {
            ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.remove((AttributeStorage)ctx.getConnection());
            if (clientContext != null) {
                clientContext.handleClose(messageID, request);
            }
        }

        @Override
        public void unrecognizedMessage(FilterChainContext ctx, int messageID, byte messageTag, ByteString messageBytes) {
            LDAPServerFilter.this.exceptionOccurred(ctx, new UnsupportedMessageException(messageID, messageTag, messageBytes));
        }
    };

    LDAPServerFilter(LDAPListenerImpl listener, LDAPReader ldapReader, int maxASN1ElementSize) {
        this.listener = listener;
        this.ldapReader = ldapReader;
        this.maxASN1ElementSize = maxASN1ElementSize <= 0 ? 0x500000 : maxASN1ElementSize;
    }

    public void exceptionOccurred(FilterChainContext ctx, Throwable error) {
        ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.remove((AttributeStorage)ctx.getConnection());
        if (clientContext != null) {
            clientContext.handleError(error);
        }
    }

    public NextAction handleAccept(FilterChainContext ctx) throws IOException {
        Connection connection = ctx.getConnection();
        LDAPListenerOptions options = this.listener.getLDAPListenerOptions();
        GrizzlyUtils.configureConnection(connection, options.isTCPNoDelay(), options.isKeepAlive(), options.isReuseAddress(), options.getLinger());
        try {
            ClientContextImpl clientContext = new ClientContextImpl(connection);
            ServerConnection<Integer> serverConn = this.listener.getConnectionFactory().handleAccept(clientContext);
            clientContext.setServerConnection(serverConn);
            LDAP_CONNECTION_ATTR.set((AttributeStorage)connection, (Object)clientContext);
        }
        catch (ErrorResultException e) {
            connection.close();
        }
        return ctx.getStopAction();
    }

    public NextAction handleClose(FilterChainContext ctx) throws IOException {
        ClientContextImpl clientContext = (ClientContextImpl)LDAP_CONNECTION_ATTR.remove((AttributeStorage)ctx.getConnection());
        if (clientContext != null) {
            clientContext.handleClose(-1, null);
        }
        return ctx.getStopAction();
    }

    public NextAction handleRead(FilterChainContext ctx) throws IOException {
        Buffer buffer = (Buffer)ctx.getMessage();
        ASN1BufferReader asn1Reader = (ASN1BufferReader)LDAP_ASN1_READER_ATTR.get((AttributeStorage)ctx.getConnection());
        if (asn1Reader == null) {
            asn1Reader = new ASN1BufferReader(this.maxASN1ElementSize, ctx.getConnection().getTransport().getMemoryManager());
            LDAP_ASN1_READER_ATTR.set((AttributeStorage)ctx.getConnection(), (Object)asn1Reader);
        }
        asn1Reader.appendBytesRead(buffer);
        try {
            while (asn1Reader.elementAvailable()) {
                this.ldapReader.decode(asn1Reader, this.serverRequestHandler, ctx);
            }
        }
        catch (IOException e) {
            this.exceptionOccurred(ctx, e);
            throw e;
        }
        finally {
            asn1Reader.disposeBytesRead();
        }
        return ctx.getStopAction();
    }

    static {
        try {
            DUMMY_SSL_ENGINE_CONFIGURATOR = new SSLEngineConfigurator(new SSLContextBuilder().setTrustManager(TrustManagers.distrustAll()).getSSLContext());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("Unable to create Dummy SSL Engine Configurator", e);
        }
    }

    private final class SearchHandler
    extends AbstractHandler<Result>
    implements SearchResultHandler {
        private SearchHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleEntry(SearchResultEntry entry) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.searchResultEntry(asn1Writer, this.messageID, entry);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
                boolean bl = false;
                return bl;
            }
            finally {
                asn1Writer.recycle();
            }
            return true;
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            this.handleResult(error.getResult());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handleReference(SearchResultReference reference) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.searchResultReference(asn1Writer, this.messageID, reference);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
                boolean bl = false;
                return bl;
            }
            finally {
                asn1Writer.recycle();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(Result result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.searchResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class ModifyHandler
    extends AbstractHandler<Result> {
        private ModifyHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            this.handleResult(error.getResult());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(Result result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.modifyResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class ModifyDNHandler
    extends AbstractHandler<Result> {
        private ModifyDNHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            this.handleResult(error.getResult());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(Result result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.modifyDNResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class ExtendedHandler<R extends ExtendedResult>
    extends AbstractHandler<R> {
        private ExtendedHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            Result result = error.getResult();
            if (result instanceof ExtendedResult) {
                this.handleResult((ExtendedResult)result);
            } else {
                GenericExtendedResult newResult = Responses.newGenericExtendedResult(result.getResultCode());
                newResult.setDiagnosticMessage(result.getDiagnosticMessage());
                newResult.setMatchedDN(result.getMatchedDN());
                newResult.setCause(result.getCause());
                for (Control control : result.getControls()) {
                    newResult.addControl(control);
                }
                this.handleResult(newResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(ExtendedResult result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.extendedResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class DeleteHandler
    extends AbstractHandler<Result> {
        private DeleteHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            this.handleResult(error.getResult());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(Result result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.deleteResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class CompareHandler
    extends AbstractHandler<CompareResult> {
        private CompareHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            Result result = error.getResult();
            if (result instanceof CompareResult) {
                this.handleResult((CompareResult)result);
            } else {
                CompareResult newResult = Responses.newCompareResult(result.getResultCode());
                newResult.setDiagnosticMessage(result.getDiagnosticMessage());
                newResult.setMatchedDN(result.getMatchedDN());
                newResult.setCause(result.getCause());
                for (Control control : result.getControls()) {
                    newResult.addControl(control);
                }
                this.handleResult(newResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(CompareResult result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.compareResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class ClientContextImpl
    implements LDAPClientContext {
        private final Connection<?> connection;
        private final AtomicBoolean isClosed = new AtomicBoolean();
        private ServerConnection<Integer> serverConnection = null;

        private ClientContextImpl(Connection<?> connection) {
            this.connection = connection;
        }

        @Override
        public void disconnect() {
            this.disconnect0(null, null);
        }

        @Override
        public void disconnect(ResultCode resultCode, String message) {
            Validator.ensureNotNull(resultCode);
            GenericExtendedResult notification = Responses.newGenericExtendedResult(resultCode).setOID("1.3.6.1.4.1.1466.20036").setDiagnosticMessage(message);
            this.sendUnsolicitedNotification(notification);
            this.disconnect0(resultCode, message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enableConnectionSecurityLayer(ConnectionSecurityLayer layer) {
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                this.installFilter((Filter)new ConnectionSecurityLayerFilter(layer, this.connection.getTransport().getMemoryManager()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void enableTLS(SSLContext sslContext, String[] protocols, String[] suites, boolean wantClientAuth, boolean needClientAuth) {
            Validator.ensureNotNull(sslContext);
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                if (this.isTLSEnabled()) {
                    throw new IllegalStateException("TLS already enabled");
                }
                SSLEngineConfigurator sslEngineConfigurator = new SSLEngineConfigurator(sslContext, false, false, false);
                sslEngineConfigurator.setEnabledCipherSuites(suites);
                sslEngineConfigurator.setEnabledProtocols(protocols);
                sslEngineConfigurator.setWantClientAuth(wantClientAuth);
                sslEngineConfigurator.setNeedClientAuth(needClientAuth);
                this.installFilter((Filter)new SSLFilter(sslEngineConfigurator, DUMMY_SSL_ENGINE_CONFIGURATOR));
            }
        }

        @Override
        public InetSocketAddress getLocalAddress() {
            return (InetSocketAddress)this.connection.getLocalAddress();
        }

        @Override
        public InetSocketAddress getPeerAddress() {
            return (InetSocketAddress)this.connection.getPeerAddress();
        }

        @Override
        public int getSecurityStrengthFactor() {
            SSLSession sslSession = this.getSSLSession();
            if (sslSession != null) {
                String cipherString = sslSession.getCipherSuite();
                for (Object[] cipher : CIPHER_KEY_SIZES) {
                    if (cipherString.indexOf((String)cipher[0]) < 0) continue;
                    return (Integer)cipher[1];
                }
            }
            return 0;
        }

        @Override
        public SSLSession getSSLSession() {
            SSLEngine sslEngine = SSLUtils.getSSLEngine(this.connection);
            return sslEngine != null ? sslEngine.getSession() : null;
        }

        @Override
        public boolean isClosed() {
            return this.isClosed.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sendUnsolicitedNotification(ExtendedResult notification) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.extendedResult(asn1Writer, 0, notification);
                this.connection.write((Object)asn1Writer.getBuffer(), null);
            }
            catch (IOException ioe) {
                this.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("LDAPClientContext(");
            builder.append(this.getLocalAddress());
            builder.append(',');
            builder.append(this.getPeerAddress());
            builder.append(')');
            return builder.toString();
        }

        public void write(ASN1BufferWriter asn1Writer) {
            this.connection.write((Object)asn1Writer.getBuffer(), null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void disconnect0(ResultCode resultCode, String message) {
            if (this.isClosed.compareAndSet(false, true)) {
                try {
                    if (this.serverConnection != null) {
                        this.serverConnection.handleConnectionDisconnected(resultCode, message);
                    }
                }
                finally {
                    this.connection.closeSilently();
                }
            }
        }

        private ServerConnection<Integer> getServerConnection() {
            return this.serverConnection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleClose(int messageID, UnbindRequest unbindRequest) {
            if (this.isClosed.compareAndSet(false, true)) {
                try {
                    if (this.serverConnection != null) {
                        this.serverConnection.handleConnectionClosed(messageID, unbindRequest);
                    }
                }
                finally {
                    if (unbindRequest != null) {
                        return;
                    }
                    this.connection.closeSilently();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleError(Throwable error) {
            if (this.isClosed.compareAndSet(false, true)) {
                try {
                    if (this.serverConnection != null) {
                        this.serverConnection.handleConnectionError(error);
                    }
                }
                finally {
                    this.connection.closeSilently();
                }
            }
        }

        private void installFilter(Filter filter) {
            FilterChain oldFilterChain = (FilterChain)this.connection.getProcessor();
            int filterIndex = oldFilterChain.size() - 1;
            if (filter instanceof SSLFilter) {
                for (int i = oldFilterChain.size() - 2; i >= 0; --i) {
                    if (oldFilterChain.get(i) instanceof ConnectionSecurityLayerFilter) continue;
                    filterIndex = i + 1;
                    break;
                }
            }
            FilterChain newFilterChain = FilterChainBuilder.stateless().addAll((List)oldFilterChain).add(filterIndex, filter).build();
            this.connection.setProcessor((Processor)newFilterChain);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isTLSEnabled() {
            ClientContextImpl clientContextImpl = this;
            synchronized (clientContextImpl) {
                FilterChain currentFilterChain = (FilterChain)this.connection.getProcessor();
                for (Filter filter : currentFilterChain) {
                    if (!(filter instanceof SSLFilter)) continue;
                    return true;
                }
                return false;
            }
        }

        private void setServerConnection(ServerConnection<Integer> serverConnection) {
            this.serverConnection = serverConnection;
        }
    }

    private final class BindHandler
    extends AbstractHandler<BindResult> {
        private BindHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            Result result = error.getResult();
            if (result instanceof BindResult) {
                this.handleResult((BindResult)result);
            } else {
                BindResult newResult = Responses.newBindResult(result.getResultCode());
                newResult.setDiagnosticMessage(result.getDiagnosticMessage());
                newResult.setMatchedDN(result.getMatchedDN());
                newResult.setCause(result.getCause());
                for (Control control : result.getControls()) {
                    newResult.addControl(control);
                }
                this.handleResult(newResult);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(BindResult result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.bindResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private final class AddHandler
    extends AbstractHandler<Result> {
        private AddHandler(ClientContextImpl context, int messageID) {
            super(context, messageID);
        }

        @Override
        public void handleErrorResult(ErrorResultException error) {
            this.handleResult(error.getResult());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleResult(Result result) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.addResult(asn1Writer, this.messageID, result);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
            }
            finally {
                asn1Writer.recycle();
            }
        }
    }

    private abstract class AbstractHandler<R extends Result>
    implements IntermediateResponseHandler,
    ResultHandler<R> {
        protected final ClientContextImpl context;
        protected final int messageID;

        protected AbstractHandler(ClientContextImpl context, int messageID) {
            this.messageID = messageID;
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final boolean handleIntermediateResponse(IntermediateResponse response) {
            ASN1BufferWriter asn1Writer = ASN1BufferWriter.getWriter();
            try {
                LDAP_WRITER.intermediateResponse(asn1Writer, this.messageID, response);
                this.context.write(asn1Writer);
            }
            catch (IOException ioe) {
                this.context.handleError(ioe);
                boolean bl = false;
                return bl;
            }
            finally {
                asn1Writer.recycle();
            }
            return true;
        }
    }
}

