/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.AbstractLDAPFutureResultImpl;
import org.forgerock.opendj.ldap.Connection;
import org.forgerock.opendj.ldap.IntermediateResponseHandler;
import org.forgerock.opendj.ldap.ResultCode;
import org.forgerock.opendj.ldap.SearchResultHandler;
import org.forgerock.opendj.ldap.requests.SearchRequest;
import org.forgerock.opendj.ldap.responses.Responses;
import org.forgerock.opendj.ldap.responses.Result;
import org.forgerock.opendj.ldap.responses.SearchResultEntry;
import org.forgerock.opendj.ldap.responses.SearchResultReference;

final class LDAPSearchFutureResultImpl
extends AbstractLDAPFutureResultImpl<Result>
implements SearchResultHandler {
    private SearchResultHandler searchResultHandler;
    private final SearchRequest request;
    private final boolean isPersistentSearch;

    LDAPSearchFutureResultImpl(int requestID, SearchRequest request, SearchResultHandler resultHandler, IntermediateResponseHandler intermediateResponseHandler, Connection connection) {
        super(requestID, resultHandler, intermediateResponseHandler, connection);
        this.request = request;
        this.searchResultHandler = resultHandler;
        this.isPersistentSearch = request.containsControl("2.16.840.1.113730.3.4.3") || request.containsControl("1.2.840.113556.1.4.528");
    }

    @Override
    public boolean handleEntry(SearchResultEntry entry) {
        if (!this.isDone()) {
            this.updateTimestamp();
            if (this.searchResultHandler != null && !this.searchResultHandler.handleEntry(entry)) {
                this.searchResultHandler = null;
            }
        }
        return true;
    }

    @Override
    public boolean handleReference(SearchResultReference reference) {
        if (!this.isDone()) {
            this.updateTimestamp();
            if (this.searchResultHandler != null && !this.searchResultHandler.handleReference(reference)) {
                this.searchResultHandler = null;
            }
        }
        return true;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LDAPSearchFutureResultImpl(");
        sb.append("request = ");
        sb.append(this.request);
        super.toString(sb);
        sb.append(")");
        return sb.toString();
    }

    SearchRequest getRequest() {
        return this.request;
    }

    @Override
    Result newErrorResult(ResultCode resultCode, String diagnosticMessage, Throwable cause) {
        return Responses.newResult(resultCode).setDiagnosticMessage(diagnosticMessage).setCause(cause);
    }

    @Override
    boolean checkForTimeout() {
        return !this.isPersistentSearch;
    }
}

