/*
 * Decompiled with CFR 0.152.
 */
package com.forgerock.opendj.ldap;

import com.forgerock.opendj.ldap.DefaultTCPNIOTransport;
import com.forgerock.opendj.ldap.LDAPReader;
import com.forgerock.opendj.ldap.LDAPServerFilter;
import com.forgerock.opendj.util.ReferenceCountedObject;
import com.forgerock.opendj.util.StaticUtils;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.forgerock.opendj.ldap.LDAPClientContext;
import org.forgerock.opendj.ldap.LDAPListenerOptions;
import org.forgerock.opendj.ldap.ServerConnectionFactory;
import org.glassfish.grizzly.Processor;
import org.glassfish.grizzly.filterchain.Filter;
import org.glassfish.grizzly.filterchain.FilterChain;
import org.glassfish.grizzly.filterchain.FilterChainBuilder;
import org.glassfish.grizzly.filterchain.TransportFilter;
import org.glassfish.grizzly.nio.transport.TCPNIOBindingHandler;
import org.glassfish.grizzly.nio.transport.TCPNIOServerConnection;
import org.glassfish.grizzly.nio.transport.TCPNIOTransport;

public final class LDAPListenerImpl
implements Closeable {
    private final ReferenceCountedObject.Reference transport;
    private final FilterChain defaultFilterChain;
    private final ServerConnectionFactory<LDAPClientContext, Integer> connectionFactory;
    private final TCPNIOServerConnection serverConnection;
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final InetSocketAddress socketAddress;
    private final LDAPListenerOptions options;

    public LDAPListenerImpl(InetSocketAddress address, ServerConnectionFactory<LDAPClientContext, Integer> factory, LDAPListenerOptions options) throws IOException {
        this.transport = DefaultTCPNIOTransport.DEFAULT_TRANSPORT.acquireIfNull(options.getTCPNIOTransport());
        this.connectionFactory = factory;
        this.options = new LDAPListenerOptions(options);
        LDAPServerFilter serverFilter = new LDAPServerFilter(this, new LDAPReader(this.options.getDecodeOptions()), this.options.getMaxRequestSize());
        this.defaultFilterChain = FilterChainBuilder.stateless().add((Filter)new TransportFilter()).add((Filter)serverFilter).build();
        TCPNIOBindingHandler bindingHandler = ((TCPNIOBindingHandler.Builder)TCPNIOBindingHandler.builder((TCPNIOTransport)((TCPNIOTransport)this.transport.get())).processor((Processor)this.defaultFilterChain)).build();
        this.serverConnection = bindingHandler.bind((SocketAddress)address, options.getBacklog());
        int port = ((InetSocketAddress)this.serverConnection.getLocalAddress()).getPort();
        this.socketAddress = new InetSocketAddress(StaticUtils.getHostName(address), port);
    }

    @Override
    public void close() {
        if (this.isClosed.compareAndSet(false, true)) {
            try {
                this.serverConnection.close().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                StaticUtils.DEBUG_LOG.log(Level.WARNING, "Exception occurred while closing listener", e);
            }
            this.transport.release();
        }
    }

    public InetSocketAddress getSocketAddress() {
        return this.socketAddress;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("LDAPListener(");
        builder.append(this.getSocketAddress().toString());
        builder.append(')');
        return builder.toString();
    }

    ServerConnectionFactory<LDAPClientContext, Integer> getConnectionFactory() {
        return this.connectionFactory;
    }

    FilterChain getDefaultFilterChain() {
        return this.defaultFilterChain;
    }

    LDAPListenerOptions getLDAPListenerOptions() {
        return this.options;
    }
}

